/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.toolWindow.tree.BVTreeStructure;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVModuleNode;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class BVTreeRootNode
extends AbstractBVNode {
    private Project myProject;
    private BVTreeStructure myTreeStructure;

    public BVTreeRootNode(@NotNull Project project, @NotNull BVTreeStructure structure) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/toolWindow/tree/nodes/BVTreeRootNode", "<init>"));
        }
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/beanValidation/toolWindow/tree/nodes/BVTreeRootNode", "<init>"));
        }
        super(null);
        this.myProject = project;
        this.myTreeStructure = structure;
    }

    @Override
    public SimpleNode[] getChildren() {
        ArrayList<BVModuleNode> children = new ArrayList<BVModuleNode>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!BVUtils.isBeanValidationDefined(module)) continue;
            children.add(new BVModuleNode(module, this.myTreeStructure, this));
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    public String getName() {
        return super.getName();
    }

    public boolean isAutoExpandNode() {
        return true;
    }
}

