/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.ValidatingTableEditor;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.ui.ServerPathCellEditor;

public class WorkspaceForm {
    private JTextField myNameField;
    private JLabel myServerField;
    private JLabel myOwnerField;
    private JLabel myComputerField;
    private JTextArea myCommentField;
    private JPanel myContentPane;
    private ValidatingTableEditor<WorkingFolderInfo> myTable;
    private JLabel myMessageLabel;
    private JLabel myWorkingFoldrersLabel;
    private ComboBox myLocationField;
    private ServerInfo myServer;
    private final Project myProject;
    @Nullable
    private String myWorkingFolderValidationMessage;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    private static ColumnInfo<WorkingFolderInfo, Object> STATUS_COLUMN = new ColumnInfo<WorkingFolderInfo, Object>(TFSBundle.message("working.folder.status.column", new Object[0])){

        public Object valueOf(WorkingFolderInfo item) {
            return item.getStatus();
        }

        public void setValue(WorkingFolderInfo item, Object value) {
            item.setStatus((WorkingFolderInfo.Status)((Object)value));
        }

        public boolean isCellEditable(WorkingFolderInfo workingFolderInfo) {
            return true;
        }

        public int getWidth(JTable table) {
            return 80;
        }

        public TableCellEditor getEditor(WorkingFolderInfo o) {
            return new AbstractTableCellEditor(){
                private ComboBox myCombo;

                public Object getCellEditorValue() {
                    return this.myCombo.getSelectedItem();
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    EnumComboBoxModel model = new EnumComboBoxModel(WorkingFolderInfo.Status.class);
                    model.setSelectedItem(value);
                    this.myCombo = new ComboBox((ComboBoxModel)model, this.getWidth(table));
                    return this.myCombo;
                }
            };
        }
    };
    private ColumnInfo<WorkingFolderInfo, String> SERVER_PATH_COLUMN;

    private void createUIComponents() {
        this.myTable = new ValidatingTableEditor<WorkingFolderInfo>(){

            protected WorkingFolderInfo cloneOf(WorkingFolderInfo item) {
                return item.getCopy();
            }

            protected WorkingFolderInfo createItem() {
                String path = WorkspaceForm.this.myProject.isDefault() ? "" : WorkspaceForm.this.myProject.getBaseDir().getPath();
                return new WorkingFolderInfo(VcsUtil.getFilePath((String)path));
            }

            @Nullable
            protected String validate(WorkingFolderInfo item) {
                if (StringUtil.isEmpty((String)item.getLocalPath().getPath())) {
                    return TFSBundle.message("local.path.is.empty", new Object[0]);
                }
                if (StringUtil.isEmpty((String)item.getServerPath())) {
                    return TFSBundle.message("server.path.is.empty", new Object[0]);
                }
                if (!item.getServerPath().startsWith("$/")) {
                    return TFSBundle.message("server.path.is.invalid", new Object[0]);
                }
                return null;
            }

            protected void displayMessageAndFix(@Nullable Pair<String, ValidatingTableEditor.Fix> messageAndFix) {
                WorkspaceForm.this.myWorkingFolderValidationMessage = messageAndFix != null ? (String)messageAndFix.first : null;
                ((ChangeListener)WorkspaceForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        };
        this.myTable.hideMessageLabel();
        this.myTable.setColumnReorderingAllowed(false);
    }

    private void setupLocations() {
        for (WorkspaceInfo.Location location : WorkspaceInfo.Location.values()) {
            this.myLocationField.addItem((Object)location);
        }
    }

    private WorkspaceForm(Project project) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.SERVER_PATH_COLUMN = new ColumnInfo<WorkingFolderInfo, String>(TFSBundle.message("working.folder.server.path.column", new Object[0])){

            public String valueOf(WorkingFolderInfo item) {
                return item.getServerPath();
            }

            public void setValue(WorkingFolderInfo item, String value) {
                item.setServerPath(value);
            }

            public boolean isCellEditable(WorkingFolderInfo item) {
                return true;
            }

            public TableCellEditor getEditor(WorkingFolderInfo item) {
                return new ServerPathCellEditor(TFSBundle.message("choose.server.path.dialog.title", new Object[0]), WorkspaceForm.this.myProject, WorkspaceForm.this.myServer);
            }
        };
        this.myProject = project;
        this.myWorkingFoldrersLabel.setLabelFor(this.myTable.getPreferredFocusedComponent());
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)WorkspaceForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(e));
            }
        };
        this.myNameField.getDocument().addDocumentListener((DocumentListener)listener);
        this.myCommentField.getDocument().addDocumentListener((DocumentListener)listener);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.setupLocations();
    }

    public WorkspaceForm(Project project, @NotNull ServerInfo server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/ui/WorkspaceForm", "<init>"));
        }
        this(project);
        this.myServer = server;
        this.myServerField.setText(this.myServer.getPresentableUri());
        this.myOwnerField.setText(this.myServer.getQualifiedUsername());
        this.myComputerField.setText(Workstation.getComputerName());
        this.myTable.setModel(new ColumnInfo[]{STATUS_COLUMN, new LocalPathColumn(), this.SERVER_PATH_COLUMN}, new ArrayList());
    }

    public WorkspaceForm(Project project, @NotNull WorkspaceInfo workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/ui/WorkspaceForm", "<init>"));
        }
        this(project, workspace.getServer());
        this.myNameField.setText(workspace.getName());
        this.myLocationField.setSelectedItem((Object)workspace.getLocation());
        this.myCommentField.setText(workspace.getComment());
        this.myTable.setModel(new ColumnInfo[]{STATUS_COLUMN, new LocalPathColumn(), this.SERVER_PATH_COLUMN}, new ArrayList<WorkingFolderInfo>(workspace.getWorkingFoldersCached()));
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public String getWorkspaceName() {
        return this.myNameField.getText();
    }

    @NotNull
    public WorkspaceInfo.Location getWorkspaceLocation() {
        WorkspaceInfo.Location location = (WorkspaceInfo.Location)((Object)this.myLocationField.getSelectedItem());
        if (location == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkspaceForm", "getWorkspaceLocation"));
        }
        return location;
    }

    public String getWorkspaceComment() {
        return this.myCommentField.getText();
    }

    public List<WorkingFolderInfo> getWorkingFolders() {
        return this.myTable.getItems();
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void setErrorMessage(@Nullable String message) {
        this.myMessageLabel.setText(message);
        this.myMessageLabel.setVisible(message != null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    @Nullable
    public String validateWorkingFolders() {
        return this.myWorkingFolderValidationMessage;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JLabel jLabel2;
        JTextArea jTextArea;
        JLabel jLabel3;
        JLabel jLabel4;
        JLabel jLabel5;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Name:");
        jLabel6.setDisplayedMnemonic('N');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Server:");
        jPanel.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerField = jLabel5 = new JLabel();
        jLabel5.setText("http://");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Owner:");
        jPanel.add((Component)jLabel8, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOwnerField = jLabel4 = new JLabel();
        jLabel4.setText("domain\\user");
        jPanel.add((Component)jLabel4, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Computer:");
        jPanel.add((Component)jLabel9, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myComputerField = jLabel3 = new JLabel();
        jLabel3.setText("localhost");
        jPanel.add((Component)jLabel3, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Comment:");
        jLabel10.setDisplayedMnemonic('O');
        jLabel10.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel10, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.myCommentField = jTextArea = new JTextArea();
        jTextArea.setText("");
        jTextArea.setRows(3);
        jTextArea.setLineWrap(true);
        jBScrollPane.setViewportView(jTextArea);
        ValidatingTableEditor<WorkingFolderInfo> validatingTableEditor = this.myTable;
        JComponent jComponent = validatingTableEditor.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myWorkingFoldrersLabel = jLabel2 = new JLabel();
        jLabel2.setText("Working folders:");
        jLabel2.setDisplayedMnemonic('W');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(9, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Location:");
        jLabel11.setDisplayedMnemonic('L');
        jLabel11.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel11, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocationField = comboBox = new ComboBox();
        comboBox.setEditable(false);
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        jLabel6.setLabelFor(jTextField);
        jLabel10.setLabelFor(jTextArea);
        jLabel11.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private class LocalPathColumn
    extends ColumnInfo<WorkingFolderInfo, String>
    implements ValidatingTableEditor.RowHeightProvider {
        public LocalPathColumn() {
            super(TFSBundle.message("working.folder.local.path.column", new Object[0]));
        }

        public String valueOf(WorkingFolderInfo item) {
            return item.getLocalPath().getPresentableUrl();
        }

        public boolean isCellEditable(WorkingFolderInfo workingFolderInfo) {
            return true;
        }

        public void setValue(WorkingFolderInfo item, String value) {
            item.setLocalPath(VcsUtil.getFilePath((String)value));
        }

        public TableCellEditor getEditor(WorkingFolderInfo item) {
            return new LocalPathCellEditor(TFSBundle.message("select.local.path.title", new Object[0]), WorkspaceForm.this.myProject);
        }

        public int getRowHeight() {
            return new JTextField().getPreferredSize().height + 1;
        }
    }
}

