/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.xml.XmlToken;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.JavaFxCSSElementDescriptionProvider;
import org.jetbrains.plugins.javaFX.indexing.JavaFxIdsIndex;

public class JavaFxCssIdCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/javaFX/css/JavaFxCssIdCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/javaFX/css/JavaFxCssIdCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        if (position instanceof XmlToken && ((XmlToken)position).getTokenType() == CssElementTypes.CSS_HASH && JavaFxCSSElementDescriptionProvider.isJavaFXCSS(position)) {
            Project project = position.getProject();
            Collection<String> registeredIds = JavaFxIdsIndex.getAllRegisteredIds(project);
            for (String registeredId : registeredIds) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)registeredId));
            }
        }
    }
}

