/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.rename;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxStylesheetsIndex;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;

public class JavaFxRenameCssIdSelectorProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/css/rename/JavaFxRenameCssIdSelectorProcessor", "canProcessElement"));
        }
        if (element instanceof CssIdSelector) {
            return JavaFxStylesheetsIndex.isUsedInFxml(element.getProject(), element.getContainingFile());
        }
        return false;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        String oldName;
        if (element instanceof CssIdSelector && !StringUtil.isEmpty((String)(oldName = ((CssIdSelector)element).getName()))) {
            Set<VirtualFile> fxmls = JavaFxStylesheetsIndex.getFxmls(element.getProject(), element.getContainingFile());
            PsiManager manager = element.getManager();
            for (VirtualFile fxml : fxmls) {
                PsiReference[] references;
                XmlAttributeValue value;
                PsiFile psiFile = manager.findFile(fxml);
                if (psiFile == null || !psiFile.isValid() || (value = JavaFxPsiUtil.collectFileIds(psiFile, "controller").get(oldName)) == null) continue;
                for (PsiReference reference : references = value.getReferences()) {
                    PsiElement resolved;
                    if (!(reference instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef) || !((resolved = reference.resolve()) instanceof PsiField)) continue;
                    allRenames.put(resolved, newName);
                }
            }
        }
    }
}

