/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.psd.datareaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.mylzw.BitsToByteInputStream;
import org.apache.sanselan.common.mylzw.MyBitInputStream;
import org.apache.sanselan.formats.psd.ImageContents;
import org.apache.sanselan.formats.psd.PSDHeaderInfo;
import org.apache.sanselan.formats.psd.dataparsers.DataParser;
import org.apache.sanselan.formats.psd.datareaders.DataReader;

public class UncompressedDataReader
extends DataReader {
    public UncompressedDataReader(DataParser fDataParser) {
        super(fDataParser);
    }

    @Override
    public void readData(InputStream is, BufferedImage bi, ImageContents imageContents, BinaryFileParser bfp) throws ImageReadException, IOException {
        PSDHeaderInfo header = imageContents.header;
        int width = header.Columns;
        int height = header.Rows;
        bfp.setDebug(false);
        int channel_count = this.dataParser.getBasicChannelsCount();
        int depth = header.Depth;
        MyBitInputStream mbis = new MyBitInputStream(is, 77);
        BitsToByteInputStream bbis = new BitsToByteInputStream(mbis, 8);
        int[][][] data = new int[channel_count][height][width];
        for (int channel = 0; channel < channel_count; ++channel) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int b = bbis.readBits(depth);
                    data[channel][y][x] = (byte)b;
                }
            }
        }
        this.dataParser.parseData(data, bi, imageContents);
    }
}

