/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.wsdl.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.ws.wsdl.model.WsdlNameOwner;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WsdlDomReference
extends PsiReferenceBase<PsiElement> {
    private final GenericDomValue<String> myDomValue;
    private final List<? extends WsdlNameOwner> myNames;

    public WsdlDomReference(@NotNull PsiElement element, GenericDomValue<String> genericDomValue, List<? extends WsdlNameOwner> names) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/wsdl/converters/WsdlDomReference", "<init>"));
        }
        super(element, true);
        this.myDomValue = genericDomValue;
        this.myNames = names;
    }

    public PsiElement resolve() {
        String name = this.myDomValue.getStringValue();
        if (name != null && !StringUtil.isEmptyOrSpaces((String)name)) {
            if (name.contains(":")) {
                name = name.substring(name.indexOf(58) + 1);
            }
            for (WsdlNameOwner wsdlNameOwner : this.myNames) {
                XmlAttribute attr;
                XmlElement xmlElement;
                if (!name.equals(wsdlNameOwner.getName().getValue()) || !((xmlElement = wsdlNameOwner.getXmlElement()) instanceof XmlTag) || (attr = ((XmlTag)xmlElement).getAttribute("name")) == null) continue;
                return attr.getValueElement();
            }
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<String> result = new ArrayList<String>();
        for (WsdlNameOwner wsdlNameOwner : this.myNames) {
            String value = (String)wsdlNameOwner.getName().getValue();
            if (value == null || value.length() <= 0 || result.contains(value)) continue;
            result.add(value);
        }
        Object[] objectArray = ArrayUtil.toStringArray(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/wsdl/converters/WsdlDomReference", "getVariants"));
        }
        return objectArray;
    }

    public TextRange getRangeInElement() {
        String value = (String)this.myDomValue.getValue();
        if (value != null && value.contains(":")) {
            return new TextRange(value.indexOf(58) + 2, value.length() + 1);
        }
        return super.getRangeInElement();
    }
}

