/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Floats;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public class PrimitiveFloatArraySubject
extends AbstractArraySubject<PrimitiveFloatArraySubject, float[]> {
    PrimitiveFloatArraySubject(FailureStrategy failureStrategy, @Nullable float[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "float";
    }

    @Override
    protected List<Float> listRepresentation() {
        return Floats.asList((float[])((float[])this.getSubject()));
    }

    @Override
    @Deprecated
    public void isEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of floats is unsafe, use isEqualTo(float[] array, float tolerance) instead.");
    }

    @Deprecated
    public void isEqualTo(Object expected, float tolerance) {
        float[] actual = (float[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            float[] expectedArray = (float[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Floats.asList((float[])expectedArray), Floats.asList((float[])actual));
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equals(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Floats.asList((float[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    @Deprecated
    public void isNotEqualTo(Object expected) {
        throw new UnsupportedOperationException("Comparing raw equality of floats is unsafe, use isNotEqualTo(float[] array, float tolerance) instead.");
    }

    @Deprecated
    public void isNotEqualTo(Object expectedArray, float tolerance) {
        float[] actual = (float[])this.getSubject();
        try {
            float[] expected = (float[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Floats.asList((float[])expected));
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equals(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Floats.asList((float[])expected));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public TolerantPrimitiveFloatArrayComparison hasValuesWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void of(float[] expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.getSubject());
                if (actual.length != expected.length) {
                    PrimitiveFloatArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveFloatArraySubject.this.getDisplaySubject(), Float.valueOf(tolerance), Floats.asList((float[])expected), expected.length, actual.length);
                }
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                for (int i = 0; i < expected.length; ++i) {
                    if (MathUtil.equals(actual[i], expected[i], tolerance)) continue;
                    mismatches.add(i);
                }
                if (!mismatches.isEmpty()) {
                    float f = tolerance;
                    PrimitiveFloatArraySubject.this.failWithBadResults(new StringBuilder(36).append("has values within ").append(f).append(" of").toString(), Floats.asList((float[])expected), "differs at indexes", mismatches);
                }
            }
        };
    }

    public TolerantPrimitiveFloatArrayComparison hasValuesNotWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void of(float[] expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.getSubject());
                if (expected.length != actual.length) {
                    return;
                }
                boolean pass = false;
                for (int i = 0; i < expected.length; ++i) {
                    if (!MathUtil.notEquals(actual[i], expected[i], tolerance)) continue;
                    pass = true;
                    break;
                }
                if (!pass) {
                    float f = tolerance;
                    PrimitiveFloatArraySubject.this.fail(new StringBuilder(40).append("has values not within ").append(f).append(" of").toString(), (Object)Floats.asList((float[])expected));
                }
            }
        };
    }

    private IterableSubject<?, Float, List<Float>> asList() {
        return IterableSubject.create(this.failureStrategy, this.listRepresentation());
    }

    public abstract class TolerantPrimitiveFloatArrayComparison {
        private TolerantPrimitiveFloatArrayComparison() {
        }

        public abstract void of(float[] var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare floats, use .of(float[]) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

