/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.cloud;

import com.intellij.appengine.actions.AppEngineUploader;
import com.intellij.appengine.cloud.AppEngineCloudConfigurable;
import com.intellij.appengine.cloud.AppEngineServerConfiguration;
import com.intellij.appengine.util.AppEngineUtil;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DummyDeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.JavaDeploymentSourceUtil;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import icons.GoogleAppEngineIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AppEngineCloudType
extends ServerType<AppEngineServerConfiguration> {
    public static AppEngineCloudType getInstance() {
        return (AppEngineCloudType)((Object)EP_NAME.findExtension(AppEngineCloudType.class));
    }

    public AppEngineCloudType() {
        super("google-app-engine");
    }

    @NotNull
    public String getPresentableName() {
        if ("Google App Engine" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType", "getPresentableName"));
        }
        return "Google App Engine";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GoogleAppEngineIcons.AppEngine;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public AppEngineServerConfiguration createDefaultConfiguration() {
        AppEngineServerConfiguration appEngineServerConfiguration = new AppEngineServerConfiguration();
        if (appEngineServerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType", "createDefaultConfiguration"));
        }
        return appEngineServerConfiguration;
    }

    @NotNull
    public RemoteServerConfigurable createServerConfigurable(@NotNull AppEngineServerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/appengine/cloud/AppEngineCloudType", "createServerConfigurable"));
        }
        AppEngineCloudConfigurable appEngineCloudConfigurable = new AppEngineCloudConfigurable(configuration, null, true);
        if (appEngineCloudConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType", "createServerConfigurable"));
        }
        return appEngineCloudConfigurable;
    }

    @NotNull
    public ServerConnector<?> createConnector(@NotNull AppEngineServerConfiguration configuration, @NotNull ServerTaskExecutor asyncTasksExecutor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/appengine/cloud/AppEngineCloudType", "createConnector"));
        }
        if (asyncTasksExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncTasksExecutor", "com/intellij/appengine/cloud/AppEngineCloudType", "createConnector"));
        }
        AppEngineServerConnector appEngineServerConnector = new AppEngineServerConnector(configuration);
        if (appEngineServerConnector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType", "createConnector"));
        }
        return appEngineServerConnector;
    }

    @NotNull
    public AppEngineDeploymentConfigurator createDeploymentConfigurator(Project project) {
        AppEngineDeploymentConfigurator appEngineDeploymentConfigurator = new AppEngineDeploymentConfigurator(project);
        if (appEngineDeploymentConfigurator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType", "createDeploymentConfigurator"));
        }
        return appEngineDeploymentConfigurator;
    }

    private static class AppEngineRuntimeInstance
    extends ServerRuntimeInstance<DummyDeploymentConfiguration> {
        private final AppEngineServerConfiguration myConfiguration;

        public AppEngineRuntimeInstance(AppEngineServerConfiguration configuration) {
            this.myConfiguration = configuration;
        }

        public void deploy(@NotNull DeploymentTask<DummyDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineRuntimeInstance", "deploy"));
            }
            if (logManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineRuntimeInstance", "deploy"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineRuntimeInstance", "deploy"));
            }
            Artifact artifact = ((ArtifactDeploymentSource)task.getSource()).getArtifact();
            if (artifact == null) {
                return;
            }
            AppEngineUploader uploader = AppEngineUploader.createUploader(task.getProject(), artifact, this.myConfiguration, callback, logManager.getMainLoggingHandler());
            if (uploader != null) {
                uploader.startUploading();
            }
        }

        public void computeDeployments(@NotNull ServerRuntimeInstance.ComputeDeploymentsCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineRuntimeInstance", "computeDeployments"));
            }
            callback.succeeded();
        }

        public void disconnect() {
        }
    }

    private static class AppEngineServerConnector
    extends ServerConnector<DummyDeploymentConfiguration> {
        private final AppEngineServerConfiguration myConfiguration;

        public AppEngineServerConnector(AppEngineServerConfiguration configuration) {
            this.myConfiguration = configuration;
        }

        public void connect(@NotNull ServerConnector.ConnectionCallback<DummyDeploymentConfiguration> callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineServerConnector", "connect"));
            }
            callback.connected((ServerRuntimeInstance)new AppEngineRuntimeInstance(this.myConfiguration));
        }
    }

    private static class AppEngineDeploymentConfigurator
    extends DeploymentConfigurator<DummyDeploymentConfiguration, AppEngineServerConfiguration> {
        private final Project myProject;

        public AppEngineDeploymentConfigurator(Project project) {
            this.myProject = project;
        }

        @NotNull
        public List<DeploymentSource> getAvailableDeploymentSources() {
            List<Artifact> artifacts = AppEngineUtil.collectAppEngineArtifacts(this.myProject, true);
            List list = JavaDeploymentSourceUtil.getInstance().createArtifactDeploymentSources(this.myProject, artifacts);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineDeploymentConfigurator", "getAvailableDeploymentSources"));
            }
            return list;
        }

        @NotNull
        public DummyDeploymentConfiguration createDefaultConfiguration(@NotNull DeploymentSource source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineDeploymentConfigurator", "createDefaultConfiguration"));
            }
            DummyDeploymentConfiguration dummyDeploymentConfiguration = new DummyDeploymentConfiguration();
            if (dummyDeploymentConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineDeploymentConfigurator", "createDefaultConfiguration"));
            }
            return dummyDeploymentConfiguration;
        }

        public SettingsEditor<DummyDeploymentConfiguration> createEditor(@NotNull DeploymentSource source, @NotNull RemoteServer<AppEngineServerConfiguration> server) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineDeploymentConfigurator", "createEditor"));
            }
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/appengine/cloud/AppEngineCloudType$AppEngineDeploymentConfigurator", "createEditor"));
            }
            return null;
        }
    }
}

