/**
 * Extensions for typescript server protocol
 * Provides new messages / fields
 */
declare namespace ts {
    /**
     * expose core api
     */
    export function normalizePath(path: string): string;
}

/**
 * see TypeScriptServiceInitialStateObject
 */
interface TypeScriptPluginState extends PluginState {
    serverFolderPath: string;
}

declare namespace ts.server.CommandNames {
    export var IDEChangeFiles;
    export var IDECompile;
    export var IDEGetErrors;
    export var IDECompletions;
}

declare namespace ts.server.protocol {

    /**
     *  Extend request by adding config file relates to the file
     */
    export interface OpenRequestArgs extends FileRequestArgs {
        tsConfig: string;
    }

    export interface IDEUpdateFilesRequest extends Request {
        arguments: IDEUpdateFilesContentArgs;
    }

    export interface IDEUpdateFilesContentArgs {
        /**
         * map filepath -> new content
         */
        files: {
            [name: string]: string;
        }

        filesToReloadContentFromDisk:string[];
    }

    export interface IDECompileFileRequest extends Request {

        /**
         * path to typescript file or ts config
         */
        arguments: FileRequestArgs;
    }

    export interface IDEGetErrorRequest extends Request {
        arguments: GeterrRequestArgs;
    }


    export interface IDECompletionsRequest extends FileLocationRequest {
        arguments: CompletionsRequestArgs;
    }

    export interface IDECompletionResponse extends Response {
        body?: CompletionEntryDetails[];
    }
}