const toReplace:string = "ioSession.listen()"
const replacement:string = "//ioSession.listen()"

/**
 * Provide service for old & new integration (ts-complier-host-impl)
 */
export function getService(serverFolderPath:string, acceptServices?):{ context:any,
    serverFilePath:string } {

    if (serverFolderPath == null) {
        throw new Error('ERROR_BRIDGE: Server file is not passed');
    }
    let fs:typeof NodeJS.fs = require('fs');

    let data = getFilePathIfExists(fs, serverFolderPath, acceptServices);


    if (!data) {
        throw new Error('ERROR_BRIDGE: Cannot find tsserverlibrary.js or tsserver.js file');
    }
    let filePath = data.path;
    let context:any = null;

    let vm = require('vm');
    context = createContext(context, vm);

    vm.runInNewContext(data.data, context);

    if (!context || !context.ts) {
        throw new Error('ERROR_BRIDGE: Cannot find typescript tsserver implementation in the file ' + filePath);
    }

    return {
        context,
        serverFilePath: filePath
    };
}
function getFilePathIfExists(fs:typeof NodeJS.fs, serverFolderPath:string, acceptServices?:boolean):{
    data:string,
    path:string
} {
    {
        let pathToServicesFile = serverFolderPath + "tsserverlibrary.js";
        if (fs.existsSync(pathToServicesFile)) {
            return {
                data: fs.readFileSync(pathToServicesFile, 'utf-8'),
                path: pathToServicesFile
            }
        }
    }

    {
        let pathToServerFile = serverFolderPath + "tsserver.js";
        if (fs.existsSync(pathToServerFile)) {
            let fileData:string = fs.readFileSync(pathToServerFile, 'utf-8');
            return {
                data: fileData.replace(toReplace, replacement),
                path: pathToServerFile
            }
        }
    }

    {
        if (acceptServices) {
            let pathToServicesFile = serverFolderPath + "typescriptServices.js";
            if (fs.existsSync(pathToServicesFile)) {
                return {
                    data: fs.readFileSync(pathToServicesFile, 'utf-8'),
                    path: pathToServicesFile
                }
            }
        }
    }


    return null;
}

function createContext(context:any, vm:any) {
    context = vm.createContext();
    context.module = module;
    context.require = require;
    context.process = process;
    context.__dirname = __dirname;
    context.__filename = __filename;
    context.Buffer = Buffer;
    context.setTimeout = setTimeout;
    context.setInterval = setInterval;
    context.setInterval = setInterval;
    context.setImmediate = setImmediate;
    context.global = global;
    context.console = console;
    context.clearTimeout = clearTimeout;
    context.clearInterval = clearInterval;
    context.clearImmediate = clearImmediate;
    context.exports = exports;
    return context;
}
