/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;

public abstract class SpringModificationTrackersManager {

  private final static NotNullLazyKey<SpringModificationTrackersManager, Project> INSTANCE_CACHE =
    ServiceManager.createLazyKey(SpringModificationTrackersManager.class);

  public static SpringModificationTrackersManager getInstance(Project project) {
    return INSTANCE_CACHE.getValue(project);
  }

  public abstract ModificationTracker getProfilesModificationTracker();

  public abstract ModificationTracker getMultipleContextsModificationTracker();

  public abstract void fireActiveProfilesChanged();

  public abstract void fireMultipleContextsChanged();

  public abstract ModificationTracker getOuterModelsModificationTracker();

  public abstract Object[] getOuterModelsDependencies();
}
