/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.util.containers.hash.HashSet;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;
import java.util.Set;

public class IncludeAnnotationsFilter extends SpringContextFilter.IncludeClasses {

  public IncludeAnnotationsFilter(@NotNull Collection<PsiClass> classes) {
    super(classes);
  }

  @NotNull
  @Override
  public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
    Set<SpringStereotypeElement>  includes = new HashSet<SpringStereotypeElement>();
    GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module);
    for (PsiClass psiClass : getClasses()) {
      final String qualifiedName = psiClass.getQualifiedName();
      if (qualifiedName != null) {
        includes.addAll(SpringContextIncludeAnnotationFilter.getAnnotatedStereotypes(psiClass, searchScope, packages));
      }
    }
    return includes;
  }
}
