package com.intellij.psi.css.descriptor;

import org.jetbrains.annotations.NotNull;

import java.util.Comparator;

public enum CssMediaGroup {
  ALL,AURAL,
  CONTINUOUS,PAGED,
  VISUAL,AUDIO,SPEECH,TACTILE,
  GRID,BITMAP,
  INTERACTIVE,STATIC;

  public static final Comparator<? super CssMediaGroup> COMPARATOR = new Comparator<CssMediaGroup>() {
    @Override
    public int compare(@NotNull CssMediaGroup o1, @NotNull CssMediaGroup o2) {
      return o2.name().compareTo(o1.name());
    }
  };

}
