package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * @author nik
 */
public class JavaeeFrameworkSupportInfoCollector {
  private static final Key<JavaeeFrameworkSupportInfoCollector> JAVAEE_SUPPORT_INFO_COLLECTOR = Key.create("JAVAEE_SUPPORT_INFO_COLLECTOR");
  private final Map<ArtifactType, Artifact> myArtifacts = new HashMap<ArtifactType, Artifact>();
  private final Map<FacetTypeId<?>, Facet> myFacets = new HashMap<FacetTypeId<?>, Facet>();
  private CommonModel myRunConfiguration;
  private VirtualFile myIndexJspFile;

  public static JavaeeFrameworkSupportInfoCollector getOrCreateCollector(@NotNull FrameworkSupportModel model) {
    JavaeeFrameworkSupportInfoCollector data = getCollector(model);
    if (data == null) {
      data = new JavaeeFrameworkSupportInfoCollector();
      model.putUserData(JAVAEE_SUPPORT_INFO_COLLECTOR, data);
    }
    return data;
  }

  @Nullable
  public static JavaeeFrameworkSupportInfoCollector getCollector(FrameworkSupportModel model) {
    return model.getUserData(JAVAEE_SUPPORT_INFO_COLLECTOR);
  }

  public CommonModel getRunConfiguration() {
    return myRunConfiguration;
  }

  public void setRunConfiguration(CommonModel runConfiguration) {
    myRunConfiguration = runConfiguration;
  }

  @Nullable
  public <F extends Facet> F getFacet(FacetTypeId<F> id) {
    //noinspection unchecked
    return (F)myFacets.get(id);
  }

  public <F extends Facet> void setFacet(FacetTypeId<F> id, F facet) {
    myFacets.put(id, facet);
  }

  public void setArtifact(ArtifactType type, Artifact artifact) {
    myArtifacts.put(type, artifact);
  }

  @Nullable
  public Artifact getArtifact(ArtifactType key) {
    return myArtifacts.get(key);
  }

  public void setIndexJsp(VirtualFile indexJspFile) {
    myIndexJspFile = indexJspFile;
  }

  public VirtualFile getIndexJspFile() {
    return myIndexJspFile;
  }
}
