/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.database.util;

import org.jetbrains.annotations.NotNull;

/**
 * @author gregsh
 */
public final class Casing {

  public final Case plain;
  public final Case quoted;

  @NotNull
  public static Casing create(@NotNull Case plain, @NotNull Case quoted) {
    return new Casing(plain, quoted);
  }

  private Casing(@NotNull Case plain, @NotNull Case quoted) {
    this.plain = plain;
    this.quoted = quoted;
  }

  @NotNull
  public Case choose(boolean isPlain) {
    return  isPlain ? plain : quoted;
  }

  @Override
  public String toString() {
    return "Casing{" +
           "plain=" + plain +
           ", quoted=" + quoted +
           '}';
  }
}
