/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.javascript.debugger.DebuggableFileFinderImpl;
import com.jetbrains.javascript.debugger.JavaScriptDebugEngine;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDebugConfigUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final GroupDescriptor GROUP_ID = GroupDescriptor.create((String)"JSDebugConfig");

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GROUP_ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/execution/JSDebugConfigUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(final @NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/JSDebugConfigUsagesCollector", "getProjectUsages"));
        }
        THashSet result = new THashSet();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                JavascriptDebugConfigurationType jsConfigType = JavascriptDebugConfigurationType.getTypeInstance();
                for (RunConfiguration runConfig : RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)jsConfigType)) {
                    if (!(runConfig instanceof JavaScriptDebugConfiguration)) continue;
                    String key = JSDebugConfigUsagesCollector.getStatisticsKey(project, (JavaScriptDebugConfiguration)runConfig);
                    this.val$result.add(new UsageDescriptor(key, 1));
                }
            }
        });
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/execution/JSDebugConfigUsagesCollector", "getProjectUsages"));
        }
        return tHashSet;
    }

    public static String getStatisticsKey(@NotNull Project project, @NotNull JavaScriptDebugConfiguration runConfig) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/JSDebugConfigUsagesCollector", "getStatisticsKey"));
        }
        if (runConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfig", "com/intellij/javascript/debugger/execution/JSDebugConfigUsagesCollector", "getStatisticsKey"));
        }
        String browserId = runConfig.getEngineId();
        WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(browserId);
        WebBrowser preferredBrowser = JSDebugConfigUsagesCollector.getPreferredBrowser(project, runConfig.getUri());
        List<RemoteUrlMappingBean> mappings = runConfig.getMappings();
        return "browser-" + (browser == null ? "default" : browser.getName()) + ".preferredBrowser-" + (preferredBrowser == null ? "null" : preferredBrowser.getId()) + (mappings.isEmpty() ? ".no_mappings" : ".with_mappings");
    }

    @Nullable
    private static WebBrowser getPreferredBrowser(@NotNull Project project, @Nullable String uri) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/JSDebugConfigUsagesCollector", "getPreferredBrowser"));
        }
        Url url = uri == null ? null : Urls.newFromIdea((CharSequence)uri);
        DebuggableFileFinderImpl fileFinder = url == null ? null : new DebuggableFileFinderImpl(project, url);
        VirtualFile file = fileFinder == null ? null : fileFinder.findFile(url, project);
        PsiFile psiFile = file == null ? null : PsiManager.getInstance((Project)project).findFile(file);
        return psiFile == null ? null : JavaScriptDebugEngine.Companion.getPreferredBrowser(psiFile);
    }
}

