/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.openapi.fileEditor.impl.http.LocalFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import org.jetbrains.annotations.NotNull;

class JavaScriptDebuggerLocalFileFinder
extends LocalFileFinder {
    JavaScriptDebuggerLocalFileFinder() {
    }

    public VirtualFile findLocalFile(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/execution/JavaScriptDebuggerLocalFileFinder", "findLocalFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/JavaScriptDebuggerLocalFileFinder", "findLocalFile"));
        }
        for (JavaScriptDebugProcess process : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
            VirtualFile file = process.findFile(url);
            if (file == null || !file.isInLocalFileSystem()) continue;
            return file;
        }
        return null;
    }
}

