/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.settings.CustomObjectPresentationState;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class JavaScriptDataViewsConfigurableUi
implements ConfigurableUi<JavaScriptDebuggerSettings> {
    private JPanel panel;
    private JCheckBox myEnableAlternativeObjectView;
    private JPanel propertiesPanel;
    private SortedListModel<String> propertiesListModel;

    public JavaScriptDataViewsConfigurableUi() {
        this.$$$setupUI$$$();
        this.myEnableAlternativeObjectView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaScriptDataViewsConfigurableUi.this.updatePropertiesListPanel();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/settings/JavaScriptDataViewsConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    public boolean isModified(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/debugger/settings/JavaScriptDataViewsConfigurableUi", "isModified"));
        }
        return this.myEnableAlternativeObjectView.isSelected() != settings.getObjectPresentation().isEnabled() || !this.propertiesListModel.getItems().equals(settings.getObjectPresentation().getPropertiesToShow());
    }

    public void apply(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/debugger/settings/JavaScriptDataViewsConfigurableUi", "apply"));
        }
        CustomObjectPresentationState objectPresentation = settings.getObjectPresentation();
        objectPresentation.setEnabled(this.myEnableAlternativeObjectView.isSelected());
        objectPresentation.setPropertiesToShow(this.propertiesListModel.getItems());
        JavaScriptDebuggerSettings.onSettingsChanged(true, false);
    }

    public void reset(@NotNull JavaScriptDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/debugger/settings/JavaScriptDataViewsConfigurableUi", "reset"));
        }
        CustomObjectPresentationState objectPresentation = settings.getObjectPresentation();
        this.myEnableAlternativeObjectView.setSelected(objectPresentation.isEnabled());
        this.propertiesListModel.setAll(objectPresentation.getPropertiesToShow());
        this.updatePropertiesListPanel();
    }

    private void updatePropertiesListPanel() {
        GuiUtils.enableChildren((boolean)this.myEnableAlternativeObjectView.isSelected(), (Component[])new Component[]{this.propertiesPanel});
    }

    private void createUIComponents() {
        JBList list = new JBList();
        this.propertiesListModel = new SortedListModel(String.CASE_INSENSITIVE_ORDER);
        list.setModel(this.propertiesListModel);
        this.propertiesPanel = ToolbarDecorator.createDecorator((JList)list).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String name = Messages.showInputDialog((Component)JavaScriptDataViewsConfigurableUi.this.panel, (String)JSDebuggerBundle.message("label.text.specify.property.name", new Object[0]), (String)JSDebuggerBundle.message("dialog.title.add.property", new Object[0]), null);
                if (name != null) {
                    JavaScriptDataViewsConfigurableUi.this.propertiesListModel.add((Object)name);
                }
            }
        }).disableUpAction().disableDownAction().createPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEnableAlternativeObjectView = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JSDebuggerBundle").getString("checkbox.text.show.the.following.properties.for.object.node"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = this.propertiesPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

