/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.el.contextProviders.SpringElInjectionContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringElContextInjector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/el/SpringElContextInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/spring/el/SpringElContextInjector", "getLanguagesToInject"));
        }
        if (host instanceof PsiLiteralExpression && host instanceof PsiLanguageInjectionHost) {
            Project project = host.getProject();
            if (!SpringLibraryUtil.hasSpringLibrary((Project)project)) {
                return;
            }
            for (SpringElInjectionContext injectionContext : SpringElInjectionContext.getProviders()) {
                if (!injectionContext.isSpringElCompatibleHost((PsiLiteralExpression)host)) continue;
                registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, ElementManipulators.getValueTextRange((PsiElement)host)).doneInjecting();
                break;
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiLiteralExpression>> list = Collections.singletonList(PsiLiteralExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/SpringElContextInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

