/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.highlighting;

import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.spring.el.lexer.SpringELLexer;
import com.intellij.spring.el.lexer.SpringELTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpringELHighlighter
extends SyntaxHighlighterBase {
    private static Map<IElementType, TextAttributesKey> keys;
    public static final TextAttributesKey SPEL_BACKGROUND;
    public static final TextAttributesKey SPEL_IDENTIFIER;
    public static final TextAttributesKey SPEL_KEYWORD;
    public static final TextAttributesKey SPEL_OPERATIONS;
    public static final TextAttributesKey SPEL_STRING;
    public static final TextAttributesKey SPEL_NUMBER;
    public static final TextAttributesKey SPEL_PARENTHESES;
    public static final TextAttributesKey SPEL_BRACKETS;
    public static final TextAttributesKey SPEL_BRACES;
    public static final TextAttributesKey SPEL_COMMA;
    public static final TextAttributesKey SPEL_DOT;
    public static final TextAttributesKey SPEL_COLON;
    public static final TextAttributesKey SPEL_BOUNDS;
    public static final TextAttributesKey SPEL_BEAN_PREFIX;
    public static final TextAttributesKey SPEL_QUALIFIED_TYPE;
    public static final TextAttributesKey SPEL_PROPERTY_KEY;
    public static final TextAttributesKey SPEL_METHOD_CALL;
    public static final TextAttributesKey SPEL_STATIC_FIELD;

    @NotNull
    public Lexer getHighlightingLexer() {
        SpringELLexer springELLexer = new SpringELLexer(){

            public IElementType getTokenType() {
                IElementType tokenType = super.getTokenType();
                if (tokenType == ELTokenType.JSP_EL_ESCAPED_STRING_LITERAL) {
                    tokenType = ELTokenType.JSP_EL_STRING_LITERAL;
                }
                return tokenType;
            }
        };
        if (springELLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/highlighting/SpringELHighlighter", "getHighlightingLexer"));
        }
        return springELLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SpringELHighlighter.pack((TextAttributesKey)SPEL_BACKGROUND, (TextAttributesKey)keys.get(tokenType));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/el/highlighting/SpringELHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        SPEL_BACKGROUND = TextAttributesKey.createTextAttributesKey((String)"SPEL.BACKGROUND", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        SPEL_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"SPEL.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        SPEL_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"SPEL.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        SPEL_OPERATIONS = TextAttributesKey.createTextAttributesKey((String)"SPEL.OPERATIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        SPEL_STRING = TextAttributesKey.createTextAttributesKey((String)"SPEL.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        SPEL_NUMBER = TextAttributesKey.createTextAttributesKey((String)"SPEL.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        SPEL_PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"SPEL.PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        SPEL_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"SPEL.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        SPEL_BRACES = TextAttributesKey.createTextAttributesKey((String)"SPEL.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        SPEL_COMMA = TextAttributesKey.createTextAttributesKey((String)"SPEL.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        SPEL_DOT = TextAttributesKey.createTextAttributesKey((String)"SPEL.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        SPEL_COLON = TextAttributesKey.createTextAttributesKey((String)"SPEL.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        SPEL_BOUNDS = TextAttributesKey.createTextAttributesKey((String)"SPEL.BOUNDS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        SPEL_BEAN_PREFIX = TextAttributesKey.createTextAttributesKey((String)"SPEL.BEAN_PREFIX", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
        SPEL_QUALIFIED_TYPE = TextAttributesKey.createTextAttributesKey((String)"SPEL.QUALIFIED_TYPE", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        SPEL_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"SPEL.PROPERTY_KEY", (TextAttributesKey)PropertiesHighlighter.PROPERTY_KEY);
        SPEL_METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"SPEL.METHOD_CALL", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        SPEL_STATIC_FIELD = TextAttributesKey.createTextAttributesKey((String)"SPEL.STATIC_FIELD", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
        keys = new HashMap<IElementType, TextAttributesKey>();
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_IDENTIFIER, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_IDENTIFIER});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_KEYWORD, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_AND, ELTokenType.JSP_EL_OR, ELTokenType.JSP_EL_NOT_KEYWORD, ELTokenType.JSP_EL_EQ, ELTokenType.JSP_EL_NE, ELTokenType.JSP_EL_LT, ELTokenType.JSP_EL_GT, ELTokenType.JSP_EL_LE, ELTokenType.JSP_EL_GE, ELTokenType.JSP_EL_TRUE, ELTokenType.JSP_EL_FALSE, ELTokenType.JSP_EL_NULL, ELTokenType.JSP_EL_DIV, ELTokenType.JSP_EL_MOD, ELTokenType.JSP_EL_INSTANCEOF});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_KEYWORD, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_MATCHES, SpringELTokenType.SPEL_NEW, SpringELTokenType.SPEL_TYPE, SpringELTokenType.SPEL_BETWEEN, SpringELTokenType.SPEL_VARIABLE_PREFIX, SpringELTokenType.SPEL_TYPE});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_OPERATIONS, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_PLUS, ELTokenType.JSP_EL_MINUS, ELTokenType.JSP_EL_NOT, ELTokenType.JSP_EL_DIVISION, ELTokenType.JSP_EL_MODULO, ELTokenType.JSP_EL_MULTIPLY, ELTokenType.JSP_EL_NOT_EQUAL, ELTokenType.JSP_EL_EQUAL, ELTokenType.JSP_EL_AND_AND, ELTokenType.JSP_EL_OR_OR, ELTokenType.JSP_EL_ASSIGNMENT, ELTokenType.JSP_EL_QUEST, ELTokenType.JSP_EL_LESS, ELTokenType.JSP_EL_GREATER, ELTokenType.JSP_EL_LESS_OR_EQUAL, ELTokenType.JSP_EL_GREATER_OR_EQUAL});
        SpringELHighlighter.fillMap(keys, (TokenSet)SpringELTokenType.OPERATIONS, (TextAttributesKey)SPEL_OPERATIONS);
        SpringELHighlighter.fillMap(keys, (TokenSet)SpringELTokenType.SELECTIONS, (TextAttributesKey)SPEL_OPERATIONS);
        SpringELHighlighter.fillMap(keys, (TokenSet)ELTokenType.JSP_EL_STRING_LITERALS, (TextAttributesKey)SPEL_STRING);
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_NUMBER, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_INTEGER_LITERAL, ELTokenType.JSP_EL_FLOATING_POINT_LITERAL});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_PARENTHESES, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_LPARENTH, ELTokenType.JSP_EL_RPARENTH});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BRACKETS, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_LBRACKET, ELTokenType.JSP_EL_RBRACKET});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BRACES, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_L_CURLY, SpringELTokenType.SPEL_R_CURLY});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_COMMA, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_COMMA});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_DOT, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_DOT});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_COLON, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_COLON});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BOUNDS, (IElementType[])new IElementType[]{ELTokenType.JSP_EL_START, ELTokenType.JSF_EL_START, ELTokenType.JSP_EL_END});
        SpringELHighlighter.fillMap(keys, (TextAttributesKey)SPEL_BEAN_PREFIX, (IElementType[])new IElementType[]{SpringELTokenType.SPEL_BEAN_PREFIX});
    }
}

