/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.lang.StdLanguages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUrlChangeAdapter;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JspContextManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JspContextManagerImpl
extends JspContextManager
implements ProjectComponent,
PersistentStateComponent<JspContextManagerState> {
    @NonNls
    public static final String COMPONENT_NAME = "JspContextManager";
    private final PsiManager myPsiManager;
    private final VirtualFileManager myVirtualFileManager;
    private final JspFileIndex myJspFileIndex;
    private final BidirectionalMap<String, String> myFileUrlToContextUrl = new BidirectionalMap();
    private static final ThreadLocal<THashSet<PsiFile>> myProcessedContexts = new ThreadLocal<THashSet<PsiFile>>(){

        @Override
        protected THashSet<PsiFile> initialValue() {
            return new THashSet();
        }
    };

    public JspContextManagerImpl(PsiManager psiManager, VirtualFileManager virtualFileManager, JspFileIndex jspFileIndex) {
        this.myPsiManager = psiManager;
        this.myVirtualFileManager = virtualFileManager;
        this.myJspFileIndex = jspFileIndex;
    }

    public static JspContextManagerImpl getInstance(Project project) {
        JspContextManagerImpl manager = (JspContextManagerImpl)((Object)project.getComponent(JspContextManager.class));
        assert (manager != null);
        return manager;
    }

    public void projectOpened() {
        this.myVirtualFileManager.addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)this.myPsiManager.getProject());
    }

    public void projectClosed() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void clearState() {
        this.myFileUrlToContextUrl.clear();
    }

    public void loadState(JspContextManagerState state) {
        for (JspContextMappingState mapping : state.getMappings()) {
            String contextFileUrl;
            String fileUrl = mapping.getAFileUrl();
            if (fileUrl == null || (contextFileUrl = mapping.getContextFileUrl()) == null) continue;
            this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)contextFileUrl);
        }
    }

    public JspContextManagerState getState() {
        JspContextManagerState state = new JspContextManagerState();
        for (Map.Entry entry : this.myFileUrlToContextUrl.entrySet()) {
            String fileUrl = (String)entry.getKey();
            String contextUrl = (String)entry.getValue();
            this.writeFile(state, fileUrl, contextUrl);
        }
        return state;
    }

    private void writeFile(JspContextManagerState state, String fileUrl, @Nullable String contextUrl) {
        if (this.myVirtualFileManager.findFileByUrl(fileUrl) != null && contextUrl != null && this.myVirtualFileManager.findFileByUrl(contextUrl) != null) {
            JspContextMappingState mapping = new JspContextMappingState();
            mapping.setAFileUrl(fileUrl);
            mapping.setContextFileUrl(contextUrl);
            state.getMappings().add(mapping);
        }
    }

    @Nullable
    private BaseJspFile findAndSetFirstSuitableContext(PsiFile file) {
        return this.myJspFileIndex.getFirstIncludingFile(file);
    }

    @Nullable
    public JspFile getConfiguredContextFile(@NotNull PsiFile file) {
        PsiFile psiFile;
        VirtualFile contextVirtualFile;
        String fileUrl;
        String contextUrl;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "getConfiguredContextFile"));
        }
        VirtualFile virtualFile = JspContextManagerImpl.getVirtualFile(file);
        if (virtualFile != null && (contextUrl = (String)this.myFileUrlToContextUrl.get((Object)(fileUrl = virtualFile.getUrl()))) != null && (contextVirtualFile = this.myVirtualFileManager.findFileByUrl(contextUrl)) != null && (psiFile = this.myPsiManager.findFile(contextVirtualFile)) instanceof JspFile) {
            return (JspFile)psiFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile file) {
        return file.getOriginalFile().getVirtualFile();
    }

    public void setContextFile(@NotNull PsiFile file, @Nullable BaseJspFile contextFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "setContextFile"));
        }
        this.setContextInternal(file, contextFile);
        this.myPsiManager.dropResolveCaches();
        ((PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker()).incCounter();
    }

    private void setContextInternal(@NotNull PsiFile file, @Nullable BaseJspFile contextFile) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "setContextInternal"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            String fileUrl = virtualFile.getUrl();
            if (contextFile != null) {
                VirtualFile contextVirtualFile = contextFile.getVirtualFile();
                if (contextVirtualFile != null) {
                    this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)contextVirtualFile.getUrl());
                }
            } else {
                this.myFileUrlToContextUrl.remove((Object)fileUrl);
            }
        }
    }

    @Nullable
    public BaseJspFile getContextFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "getContextFile"));
        }
        JspFile contextFile = this.getConfiguredContextFile(file);
        if (contextFile == null) {
            contextFile = this.findAndSetFirstSuitableContext(file);
        }
        return contextFile;
    }

    public BaseJspFile[] getSuitableContextFiles(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "getSuitableContextFiles"));
        }
        Object[] files = this.myJspFileIndex.getIncludingFiles(file);
        int index = ArrayUtil.find((Object[])files, (Object)file);
        if (index != -1) {
            return (BaseJspFile[])ArrayUtil.remove((Object[])files, (int)index);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processContextElements(@NotNull FileViewProvider fileViewProvider, PsiScopeProcessor processor) {
        if (fileViewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileViewProvider", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "processContextElements"));
        }
        JspFile initialFile = (JspFile)fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        if (initialFile == null) {
            return true;
        }
        THashSet<PsiFile> recursionGuard = myProcessedContexts.get();
        if (recursionGuard.contains((Object)initialFile)) {
            return true;
        }
        JspFile realInitialFile = initialFile;
        recursionGuard.add((Object)realInitialFile);
        try {
            BaseJspFile context;
            initialFile = (JspFile)initialFile.getOriginalFile();
            THashSet files = new THashSet(4);
            JspFile currentFile = initialFile;
            do {
                files.add(currentFile);
                context = this.getContextFile((PsiFile)currentFile);
                PsiElement element = this.findFirstIncludeElementForFile(context, (BaseJspFile)currentFile);
                if (element == null && (element = this.findFirstIncludeElementForFile(context = this.getConfiguredContextFile((PsiFile)currentFile), (BaseJspFile)currentFile)) == null) {
                    context = this.findAndSetFirstSuitableContext((PsiFile)currentFile);
                    element = this.findFirstIncludeElementForFile(context, (BaseJspFile)currentFile);
                }
                if (context == null) break;
                if (element == null) {
                    break;
                }
                if (context instanceof JspFile && !PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)element, (PsiElement)((JspFile)context).getJavaClass())) {
                    boolean bl = false;
                    return bl;
                }
                PsiFile javaFile = context.getViewProvider().getPsi(StdLanguages.JAVA);
                if (javaFile == null) continue;
                javaFile.processDeclarations(processor, ResolveState.initial(), (PsiElement)currentFile, element);
            } while (!files.contains(currentFile = context));
        }
        finally {
            recursionGuard.remove((Object)realInitialFile);
        }
        return true;
    }

    @Nullable
    private PsiElement findFirstIncludeElementForFile(@Nullable BaseJspFile file, @NotNull BaseJspFile referencedFile) {
        if (referencedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedFile", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl", "findFirstIncludeElementForFile"));
        }
        if (file == null || !file.isValid()) {
            return null;
        }
        int minOffset = this.myJspFileIndex.getFirstIncludeElementForFile(file, referencedFile);
        if (minOffset == -1) {
            VirtualFile virtualFile = referencedFile.getVirtualFile();
            if (virtualFile != null) {
                minOffset = file.getTextLength() - 1;
            } else {
                return null;
            }
        }
        return file.getViewProvider().findElementAt(minOffset, StdLanguages.JAVA);
    }

    private void changeContext(String oldUrl, String newUrl) {
        List fileUrls;
        String oldContext = (String)this.myFileUrlToContextUrl.get((Object)oldUrl);
        if (oldContext != null) {
            this.myFileUrlToContextUrl.remove((Object)oldUrl);
            this.myFileUrlToContextUrl.put((Object)newUrl, (Object)oldContext);
        }
        if ((fileUrls = this.myFileUrlToContextUrl.getKeysByValue((Object)oldUrl)) != null) {
            String[] urls;
            for (String fileUrl : urls = ArrayUtil.toStringArray((Collection)fileUrls)) {
                this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)newUrl);
            }
        }
    }

    public static class JspContextManagerState {
        private List<JspContextMappingState> myMappings = new ArrayList<JspContextMappingState>();

        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<JspContextMappingState> getMappings() {
            return this.myMappings;
        }

        public void setMappings(List<JspContextMappingState> mappings) {
            this.myMappings = mappings;
        }
    }

    @Tag(value="jsp-to-context")
    public static class JspContextMappingState {
        private String myAFileUrl;
        private String myContextFileUrl;

        @Attribute(value="jsp-file")
        public String getAFileUrl() {
            return this.myAFileUrl;
        }

        public void setAFileUrl(String AFileUrl) {
            this.myAFileUrl = AFileUrl;
        }

        @Attribute(value="context-file")
        public String getContextFileUrl() {
            return this.myContextFileUrl;
        }

        public void setContextFileUrl(String contextFileUrl) {
            this.myContextFileUrl = contextFileUrl;
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileUrlChangeAdapter {
        private MyVirtualFileListener() {
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/source/jsp/JspContextManagerImpl$MyVirtualFileListener", "fileDeleted"));
            }
            String fileUrl = event.getFile().getUrl();
            JspContextManagerImpl.this.myFileUrlToContextUrl.remove((Object)fileUrl);
            List list = JspContextManagerImpl.this.myFileUrlToContextUrl.getKeysByValue((Object)fileUrl);
            if (list != null) {
                String[] toRemove;
                for (String s : toRemove = ArrayUtil.toStringArray((Collection)list)) {
                    JspContextManagerImpl.this.myFileUrlToContextUrl.remove((Object)s);
                }
            }
        }

        protected void fileUrlChanged(String oldUrl, String newUrl) {
            JspContextManagerImpl.this.changeContext(oldUrl, newUrl);
        }
    }
}

