/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.jsp;

import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class EscapedJavaLexer
extends LexerBase {
    private char mySurroundingQuote;
    private final Lexer myJavaLexer;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private int myCurOffset;
    private IElementType myTokenType = null;
    private int myTokenEnd;

    public EscapedJavaLexer(char surroundingQuote, LanguageLevel languageLevel) {
        this.mySurroundingQuote = surroundingQuote;
        this.myJavaLexer = JavaParserDefinition.createLexer((LanguageLevel)languageLevel);
    }

    public char getSurroundingQuote() {
        return this.mySurroundingQuote;
    }

    public void setSurroundingQuote(char surroundingQuote) {
        this.mySurroundingQuote = surroundingQuote;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int state) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/parsing/jsp/EscapedJavaLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myCurOffset = startOffset;
        this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myTokenType = null;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/jsp/EscapedJavaLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public final int getTokenStart() {
        this.locateToken();
        return this.myCurOffset;
    }

    public final int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public final void advance() {
        this.locateToken();
        this.myTokenType = null;
        this.myCurOffset = this.myTokenEnd;
    }

    public final int getBufferEnd() {
        return this.myBufferEnd;
    }

    private void locateToken() {
        int offset;
        if (this.myTokenType != null) {
            return;
        }
        if (this.myCurOffset >= this.myBufferEnd) {
            return;
        }
        boolean esc = false;
        int state = 0;
        char literalStarter = '\u0000';
        for (offset = this.myCurOffset; offset < this.myBufferEnd; ++offset) {
            char c = this.myBuffer.charAt(offset);
            boolean wasEsc = esc;
            esc = false;
            if (c == '\\') {
                if (!wasEsc) {
                    esc = true;
                } else {
                    state = 2;
                }
            } else if (state == 0) {
                if (c == '\'' || c == '\"') {
                    literalStarter = c;
                    state = 1;
                }
            } else if (state == 1) {
                if (c == literalStarter) {
                    state = 0;
                    ++offset;
                    break;
                }
            } else if (state == 2) {
                state = 1;
            }
            if (!esc && state == 0) break;
        }
        if (offset >= this.myBufferEnd - 1) {
            state = 0;
        }
        switch (state) {
            case 0: {
                if (offset == this.myCurOffset) {
                    this.myJavaLexer.start(this.myBuffer, this.myCurOffset, this.myBufferEnd);
                    this.myTokenType = this.myJavaLexer.getTokenType();
                    this.myTokenEnd = this.myJavaLexer.getTokenEnd();
                    break;
                }
                this.myTokenType = literalStarter == '\"' ? JavaTokenType.STRING_LITERAL : JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEnd = offset;
                break;
            }
            case 1: {
                this.myTokenType = literalStarter == '\"' ? JavaTokenType.STRING_LITERAL : JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEnd = offset;
                break;
            }
            default: {
                this.myTokenType = TokenType.BAD_CHARACTER;
                this.myTokenEnd = offset;
            }
        }
    }
}

