/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectPusher
implements FilePropertyPusher<CssDialect> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("css_dialect_persistence", 2, true);
    private static final VfsDependentEnum<String> CSS_DIALECT_ENUMERATOR = new VfsDependentEnum("css_dialects", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);
    private ThreadLocal<CssDialect> myModuleDefaultMapping = new ThreadLocal();

    @NotNull
    public Key<CssDialect> getFileDataKey() {
        Key<CssDialect> key = CssDialectMappings.CSS_DIALECT_KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/CssDialectPusher", "getFileDataKey"));
        }
        return key;
    }

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/CssDialectPusher", "initExtra"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/lang/css/CssDialectPusher", "initExtra"));
        }
        if (languageLevelUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevelUpdater", "com/intellij/lang/css/CssDialectPusher", "initExtra"));
        }
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public CssDialect getDefaultValue() {
        CssDialect cssDialect = (CssDialect)ObjectUtils.notNull((Object)this.myModuleDefaultMapping.get(), (Object)CssDialect.CLASSIC);
        if (cssDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/CssDialectPusher", "getDefaultValue"));
        }
        return cssDialect;
    }

    @Nullable
    public CssDialect getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/CssDialectPusher", "getImmediateValue"));
        }
        return (CssDialect)CssDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    @Nullable
    public CssDialect getImmediateValue(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/css/CssDialectPusher", "getImmediateValue"));
        }
        this.myModuleDefaultMapping.set(CssDialect.getDefaultDialect((Module)module));
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/css/CssDialectPusher", "acceptsFile"));
        }
        return CssFileType.INSTANCE.equals(file.getFileType());
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/css/CssDialectPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/CssDialectPusher", "acceptsDirectory"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull CssDialect dialect) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/CssDialectPusher", "persistAttribute"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/css/CssDialectPusher", "persistAttribute"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/css/CssDialectPusher", "persistAttribute"));
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String oldDialectName = (String)CSS_DIALECT_ENUMERATOR.getById(DataInputOutputUtil.readINT((DataInput)iStream));
                if (Comparing.equal((String)oldDialectName, (String)dialect.getName())) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)CSS_DIALECT_ENUMERATOR.getId((Object)dialect.getName()));
        oStream.close();
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, this::acceptsFile);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/CssDialectPusher", "afterRootsChanged"));
        }
    }
}

