/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.CssIntentionFilter;
import org.jetbrains.annotations.NotNull;

public abstract class CssBaseElementAtCaretIntentionAction
extends BaseElementAtCaretIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        CssIntentionFilter filter;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssBaseElementAtCaretIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CssBaseElementAtCaretIntentionAction", "isAvailable"));
        }
        if (!element.isValid()) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof StylesheetFile) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            return false;
        }
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)element);
        return language == null || (filter = (CssIntentionFilter)CssIntentionFilter.INSTANCE.forLanguage(language)) == null || filter.isSupported(((Object)((Object)this)).getClass());
    }
}

