/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssRulesetUpDownMover
extends StatementUpDownMover {
    private boolean myInsertEmptyLine;

    public void afterMove(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "afterMove"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "afterMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "afterMove"));
        }
        super.afterMove(editor, file, info, down);
        if (this.myInsertEmptyLine) {
            Document document = editor.getDocument();
            if (down) {
                int newLine = info.toMove.startLine;
                document.replaceString(document.getLineStartOffset(newLine) - 1, document.getLineEndOffset(newLine), (CharSequence)"");
            } else {
                int diff = info.toMove.endLine - info.toMove.startLine - 1;
                int newLine = info.toMove.startLine + diff;
                document.replaceString(document.getLineStartOffset(newLine) - 1, document.getLineEndOffset(newLine), (CharSequence)"");
            }
            this.myInsertEmptyLine = false;
        }
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "beforeMove"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "beforeMove"));
        }
        super.beforeMove(editor, info, down);
        if (this.myInsertEmptyLine) {
            Document document = editor.getDocument();
            if (down) {
                int offset = document.getLineStartOffset(info.toMove2.startLine) - 1;
                document.insertString(offset, (CharSequence)"\n");
                info.toMove2 = new LineRange(info.toMove2.startLine, info.toMove2.startLine + 1);
            } else {
                int offset = document.getLineStartOffset(info.toMove2.endLine);
                document.insertString(offset, (CharSequence)"\n");
                info.toMove = new LineRange(info.toMove.startLine + 1, info.toMove.endLine + 1);
                info.toMove2 = new LineRange(info.toMove2.endLine, info.toMove2.endLine + 1);
            }
        }
    }

    @Nullable
    private static Couple<PsiElement> computeFirstAndLastElements(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        block7: {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "computeFirstAndLastElements"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "computeFirstAndLastElements"));
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                return CssRulesetUpDownMover.computeFirstAndLastElements(file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            }
            int offset = editor.getCaretModel().getOffset();
            element = file.findElementAt(offset);
            if (!(element instanceof PsiWhiteSpace)) break block7;
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(offset);
            if (logicalPosition.column == 0) {
                int endOffset = editor.getDocument().getLineEndOffset(logicalPosition.line);
                for (int i = offset; i < endOffset; ++i) {
                    PsiElement _e = file.findElementAt(i);
                    if (_e instanceof PsiWhiteSpace) continue;
                    element = _e;
                    break;
                }
            } else {
                int endOffset = editor.getDocument().getLineStartOffset(logicalPosition.line);
                for (int i = offset; i >= endOffset; --i) {
                    PsiElement _e = file.findElementAt(i);
                    if (_e instanceof PsiWhiteSpace) continue;
                    element = _e;
                    break;
                }
            }
        }
        return element != null ? Couple.of((Object)element, (Object)element) : null;
    }

    @Nullable
    private static Couple<PsiElement> computeFirstAndLastElements(PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement endElement;
        PsiElement startElement = file.findElementAt(selectionStart);
        if (startElement instanceof PsiWhiteSpace) {
            for (int i = selectionStart; i < selectionEnd; ++i) {
                PsiElement _e = file.findElementAt(i);
                if (_e instanceof PsiWhiteSpace) continue;
                startElement = _e;
                break;
            }
            if (startElement instanceof PsiWhiteSpace) {
                return null;
            }
        }
        if ((endElement = file.findElementAt(selectionEnd)) instanceof PsiWhiteSpace) {
            for (int i = selectionEnd; i > selectionStart; --i) {
                PsiElement _e = file.findElementAt(i);
                if (_e instanceof PsiWhiteSpace) continue;
                endElement = _e;
                break;
            }
            if (endElement instanceof PsiWhiteSpace) {
                return null;
            }
        }
        return Couple.of((Object)startElement, (Object)endElement);
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/css/actions/CssRulesetUpDownMover", "checkAvailable"));
        }
        if (info.toMove == null) {
            return false;
        }
        FileType type = file.getFileType();
        if (CssFileType.INSTANCE != type && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            return false;
        }
        Couple<PsiElement> pair = CssRulesetUpDownMover.computeFirstAndLastElements(editor, file);
        if (pair == null) {
            return false;
        }
        PsiElement first = (PsiElement)pair.first;
        PsiElement last = (PsiElement)pair.second;
        if (last == null || first == null) {
            info.toMove2 = null;
            return true;
        }
        first = CssRulesetUpDownMover.findParent(first);
        last = CssRulesetUpDownMover.findParent(last);
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)last);
        first = CssRulesetUpDownMover.findOuterElement(first, commonParent);
        last = CssRulesetUpDownMover.findOuterElement(last, commonParent);
        if (commonParent instanceof CssDeclaration || commonParent instanceof CssBlock) {
            return this.checkAvailableForRulesetsMoving(editor, file, info, down, first, last, commonParent);
        }
        if (commonParent instanceof CssRulesetList || commonParent instanceof CssRuleset || commonParent instanceof CssStylesheet) {
            return this.checkAvailableForBlocksMoving(editor, file, info, down, first, last);
        }
        return false;
    }

    private boolean checkAvailableForBlocksMoving(Editor editor, PsiFile file, StatementUpDownMover.MoveInfo info, final boolean down, PsiElement first, PsiElement last) {
        final PsiElement toMove = first.getTextOffset() > last.getTextOffset() ? (down ? first : last) : (down ? last : first);
        final PsiElement[] moveTo = new PsiElement[]{null};
        file.accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
                ASTNode node = element.getNode();
                if (node != null && CssElementTypes.CSS_COMMENT == node.getElementType()) {
                    moveTo[0] = this.updateMoveTo(element, down, moveTo[0]);
                }
            }

            public void visitCssRuleset(CssRuleset ruleset) {
                moveTo[0] = this.updateMoveTo((PsiElement)ruleset, down, moveTo[0]);
                super.visitCssRuleset(ruleset);
            }

            private PsiElement updateMoveTo(PsiElement element, boolean down2, PsiElement moveTo2) {
                if (down2 && element.getTextOffset() > toMove.getTextOffset()) {
                    if (moveTo2 == null) {
                        return element;
                    }
                    if (moveTo2.getTextOffset() > element.getTextOffset()) {
                        return element;
                    }
                } else if (!down2 && element.getTextOffset() < toMove.getTextOffset()) {
                    if (moveTo2 == null) {
                        return element;
                    }
                    if (moveTo2.getTextOffset() < element.getTextOffset()) {
                        return element;
                    }
                }
                return moveTo2;
            }
        });
        if (moveTo[0] == null) {
            PsiElement parent = toMove.getParent();
            if (parent != null && !(parent instanceof CssRulesetList) && !(parent instanceof CssStylesheet)) {
                int line = down ? editor.offsetToLogicalPosition((int)parent.getTextRange().getEndOffset()).line : editor.offsetToLogicalPosition((int)parent.getTextRange().getStartOffset()).line;
                info.toMove = new LineRange(first, last, editor.getDocument());
                info.toMove2 = new LineRange(line, line);
                this.myInsertEmptyLine = true;
                return true;
            }
            info.toMove2 = null;
            return true;
        }
        info.toMove = new LineRange(first, last, editor.getDocument());
        info.toMove2 = new LineRange(moveTo[0], moveTo[0], editor.getDocument());
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)moveTo[0]);
        this.myInsertEmptyLine = !(parent instanceof CssStylesheet) && (first.getParent() != parent || moveTo[0].getParent() != parent);
        return true;
    }

    private boolean checkAvailableForRulesetsMoving(Editor editor, PsiFile file, StatementUpDownMover.MoveInfo info, final boolean down, PsiElement first, PsiElement last, PsiElement parent) {
        final PsiElement toMove = parent instanceof CssBlock ? (first.getTextOffset() > last.getTextOffset() ? (down ? first : last) : (down ? last : first)) : parent;
        final PsiElement[] moveTo = new PsiElement[]{null};
        file.accept((PsiElementVisitor)new CssElementVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
                ASTNode node = element.getNode();
                if (node != null && CssElementTypes.CSS_COMMENT == node.getElementType() && element.getParent() instanceof CssBlock) {
                    moveTo[0] = this.updateMoveTo(element, down, moveTo[0]);
                }
            }

            public void visitCssDeclaration(CssDeclaration declaration) {
                moveTo[0] = this.updateMoveTo((PsiElement)declaration, down, moveTo[0]);
                super.visitCssDeclaration(declaration);
            }

            private PsiElement updateMoveTo(PsiElement element, boolean down2, PsiElement moveTo2) {
                if (down2 && element.getTextOffset() > toMove.getTextOffset() ? moveTo2 == null || moveTo2.getTextOffset() > element.getTextOffset() : !down2 && element.getTextOffset() < toMove.getTextOffset() && (moveTo2 == null || moveTo2.getTextOffset() < element.getTextOffset())) {
                    return element;
                }
                return moveTo2;
            }
        });
        if (moveTo[0] == null || moveTo[0] == parent || moveTo[0] == toMove.getParent()) {
            info.toMove2 = null;
            return true;
        }
        if (moveTo[0] instanceof CssBlock) {
            CssBlock block = (CssBlock)moveTo[0];
            CssDeclaration[] declarations = block.getDeclarations();
            if (declarations.length > 0) {
                moveTo[0] = down ? declarations[0] : declarations[declarations.length - 1];
            } else {
                PsiElement[] children;
                for (PsiElement child : children = block.getChildren()) {
                    if (child.getNode().getElementType() != CssElementTypes.CSS_COMMENT) continue;
                    moveTo[0] = child;
                    if (down) break;
                }
            }
        }
        info.toMove = new LineRange(first, last, editor.getDocument());
        info.toMove2 = new LineRange(moveTo[0], moveTo[0]);
        this.myInsertEmptyLine = !(PsiTreeUtil.findCommonParent((PsiElement)first, (PsiElement)moveTo[0]) instanceof CssBlock);
        return true;
    }

    private static PsiElement findParent(PsiElement first) {
        PsiElement p;
        while (!CssRulesetUpDownMover.isSuitableElement(first) && (p = first.getParent()) != null) {
            first = p;
        }
        return first;
    }

    private static boolean isSuitableElement(PsiElement e) {
        return e instanceof PsiComment || e instanceof CssDeclaration || e instanceof CssRuleset;
    }

    private static PsiElement findOuterElement(PsiElement e, PsiElement parent) {
        PsiElement p;
        if (e == parent) {
            return e;
        }
        while (e.getParent() != parent && !(e.getParent() instanceof CssStylesheet) && !(e.getParent() instanceof CssRulesetList) && (p = e.getParent()) != null) {
            e = p;
        }
        return e;
    }
}

