/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.smartenter.fixers;

import com.google.common.collect.Lists;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.actions.smartenter.fixers.CssFixer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMissingBraceFixer
implements CssFixer {
    @Override
    public boolean isApplicable(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "isApplicable"));
        }
        return CssMissingBraceFixer.getClosestRuleset(psiElement) != null;
    }

    @Override
    public boolean apply(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "apply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "apply"));
        }
        Project project = psiElement.getProject();
        boolean elementChanged = false;
        CssRuleset closestRuleset = CssMissingBraceFixer.getClosestRuleset(psiElement);
        if (closestRuleset != null) {
            elementChanged = true;
            CssBlock block = closestRuleset.getBlock();
            Document document = editor.getDocument();
            if (block == null) {
                int offset = closestRuleset.getTextRange().getEndOffset();
                document.insertString(offset, (CharSequence)"{\n}");
                editor.getCaretModel().moveToOffset(offset + 1);
                CssMissingBraceFixer.plainEnter(editor);
            } else {
                int blockStartLineNumber;
                int currentLine = document.getLineNumber(psiElement.getTextRange().getStartOffset());
                if (currentLine < (blockStartLineNumber = document.getLineNumber(block.getTextRange().getStartOffset()))) {
                    for (int lineNumber = currentLine; lineNumber < blockStartLineNumber; ++lineNumber) {
                        int lineStartOffset = document.getLineStartOffset(lineNumber);
                        int lineEndOffset = document.getLineEndOffset(lineNumber);
                        CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
                        if (lineText.length() <= 0 || StringUtil.endsWithChar((CharSequence)lineText.toString().trim(), (char)',')) continue;
                        CssMissingBraceFixer.addAllMissingBraces(block, document);
                        document.insertString(lineEndOffset, (CharSequence)"{\n}");
                        editor.getCaretModel().moveToOffset(lineEndOffset + 1);
                        CssMissingBraceFixer.plainEnter(editor);
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                        return true;
                    }
                }
                CssMissingBraceFixer.addAllMissingBraces(block, document);
                CssMissingBraceFixer.placeCaretInDeclarationBlock(editor, document, block);
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
        return elementChanged;
    }

    private static void addAllMissingBraces(@NotNull CssBlock block, @NotNull Document document) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "addAllMissingBraces"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "addAllMissingBraces"));
        }
        List reversedListOfBlocks = Lists.reverse(new ArrayList());
        CssBlock parentBlock = block;
        while (parentBlock != null) {
            reversedListOfBlocks.add(parentBlock);
            parentBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)parentBlock, CssBlock.class);
        }
        for (CssBlock aBlock : Lists.reverse((List)reversedListOfBlocks)) {
            if (aBlock.getRBrace() != null) continue;
            document.insertString(aBlock.getTextRange().getEndOffset(), (CharSequence)"\n}");
        }
    }

    private static void placeCaretInDeclarationBlock(@NotNull Editor editor, @NotNull Document document, @NotNull CssBlock block) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "placeCaretInDeclarationBlock"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "placeCaretInDeclarationBlock"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/psi/css/actions/smartenter/fixers/CssMissingBraceFixer", "placeCaretInDeclarationBlock"));
        }
        TextRange blockTextRange = block.getTextRange();
        if (StringUtil.isEmptyOrSpaces((String)block.getText())) {
            document.deleteString(blockTextRange.getStartOffset() + 1, blockTextRange.getEndOffset());
        }
        if (!blockTextRange.contains(editor.getCaretModel().getOffset() - 1)) {
            editor.getCaretModel().moveToOffset(blockTextRange.getStartOffset());
        }
        CssMissingBraceFixer.plainEnter(editor);
    }

    private static void plainEnter(Editor editor) {
        EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
        enterHandler.execute(editor, ((EditorEx)editor).getDataContext());
    }

    @Override
    @Nullable
    public PsiElement getElementToReformat(@Nullable PsiElement currentElement) {
        CssRuleset closestRuleset = CssMissingBraceFixer.getClosestRuleset(currentElement);
        return closestRuleset != null ? closestRuleset.getBlock() : null;
    }

    @Nullable
    private static CssRuleset getClosestRuleset(@Nullable PsiElement psiElement) {
        CssRuleset element = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssRuleset.class, (boolean)false);
        if (element == null) {
            element = (CssRuleset)PsiTreeUtil.getChildOfType((PsiElement)psiElement, CssRuleset.class);
        }
        return element;
    }
}

