/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.actions.colors.CssChooseColorIntention;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.browse.CssColorGutterTooltipBuilder;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.ColorIconCache;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssColorGutterRenderer
extends GutterIconRenderer
implements Comparable {
    private static final String COLOR_DECLARATION = "color";
    @NotNull
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    @NotNull
    private final ColorDeclarationType myColorDeclarationType;

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/css/browse/CssColorGutterRenderer", "compareTo"));
        }
        if (o instanceof CssColorGutterRenderer) {
            PsiElement myElement = this.getElement();
            PsiElement themElement = ((CssColorGutterRenderer)o).getElement();
            if (myElement != null && themElement != null) {
                return myElement.getTextOffset() - themElement.getTextOffset();
            }
        }
        return 0;
    }

    public CssColorGutterRenderer(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/browse/CssColorGutterRenderer", "<init>"));
        }
        this.myElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        this.myColorDeclarationType = ColorDeclarationType.fromColorTerm(element);
    }

    @Nullable
    public static Color getColor(@Nullable PsiElement element) {
        if (element == null || !element.isValid() || element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            return null;
        }
        return CssPsiColorUtil.getColor(element);
    }

    public AnAction getClickAction() {
        final Color color = CssColorGutterRenderer.getColor(this.getElement());
        if (color != null) {
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    CssChooseColorIntention.changeColorWithPicker((Editor)CommonDataKeys.EDITOR.getData(e.getDataContext()), color, CssColorGutterRenderer.this.myColorDeclarationType, CssColorGutterRenderer.this.getElement());
                }
            };
        }
        return null;
    }

    @Nullable
    protected PsiElement getElement() {
        return this.myElementPointer.getElement();
    }

    public String getTooltipText() {
        String[] strings;
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        if (declaration == null) {
            return null;
        }
        if (!declaration.isShorthandProperty()) {
            return null;
        }
        CssColorGutterTooltipBuilder tooltipBuilder = new CssColorGutterTooltipBuilder();
        tooltipBuilder.startColorPreviewCode();
        boolean ok = false;
        for (String string : strings = declaration.expandShorthandProperty()) {
            Color color;
            PsiElement[] shorthandPsiValue = declaration.getShorthandPsiValue(string);
            if (!string.contains(COLOR_DECLARATION) || shorthandPsiValue == null || shorthandPsiValue.length <= 0 || (color = CssPsiColorUtil.getColor(shorthandPsiValue[0])) == null) continue;
            ok = true;
            tooltipBuilder.appendOneColoredProperty(string, color);
        }
        return ok ? tooltipBuilder.finishColorPreviewCode().build() : null;
    }

    @NotNull
    public Icon getIcon() {
        Icon result = EmptyIcon.ICON_8;
        try {
            Color color = CssColorGutterRenderer.getColor(this.getElement());
            if (color != null) {
                result = ColorIconCache.getIconCache().getIcon(color, JBUI.scale((int)8));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        Icon icon = result;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/browse/CssColorGutterRenderer", "getIcon"));
        }
        return icon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssColorGutterRenderer renderer = (CssColorGutterRenderer)o;
        if (this.myColorDeclarationType != renderer.myColorDeclarationType) {
            return false;
        }
        return this.getElement() == renderer.getElement();
    }

    public int hashCode() {
        PsiElement element = this.getElement();
        int result = element != null ? element.hashCode() : 0;
        result = 31 * result + this.myColorDeclarationType.hashCode();
        return result;
    }
}

