/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.stubs.CssPseudoSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssPseudoSelectorBase
extends CssNamedStubElement<CssPseudoSelectorStub<? extends CssPseudoSelector>>
implements CssPseudoSelector {
    public CssPseudoSelectorBase(@NotNull CssPseudoSelectorStub<? extends CssPseudoSelector> stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssPseudoSelectorBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "<init>"));
        }
        super(node);
    }

    @NotNull
    public String getName() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getName"));
            }
            return string;
        }
        String string = CssPsiUtil.getTokenText((PsiElement)this.getNameIdentifier());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getName"));
        }
        return string;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement token = CssPsiUtil.findToken((CssElement)this, (TokenSet)CssElementTypes.NAME_TOKEN_TYPES);
        if (token == null) {
            return null;
        }
        PsiElement sibling = token.getNextSibling();
        return sibling == null || sibling.getNode().getElementType() == CssElementTypes.CSS_LPAREN || sibling.getNode().getElementType() == CssElementTypes.CSS_RPAREN ? token : null;
    }

    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "isMatch"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "isMatch"));
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitPseudoSelector((CssPseudoSelector)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public int getColonPrefixLength() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            return stub.getColonPrefixLength();
        }
        int result = 0;
        for (ASTNode element : this.getNode().getChildren(null)) {
            if (element == null || element.getElementType() != CssElementTypes.CSS_COLON) break;
            ++result;
        }
        return result;
    }

    @NotNull
    public TextRange getColonPrefixRange() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            TextRange textRange = stub.getColonPrefixRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getColonPrefixRange"));
            }
            return textRange;
        }
        int result = 0;
        for (ASTNode element : this.getNode().getChildren(null)) {
            if (element == null || element.getElementType() != CssElementTypes.CSS_COLON) break;
            result += element.getTextLength();
        }
        TextRange textRange = TextRange.create((int)0, (int)result);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getColonPrefixRange"));
        }
        return textRange;
    }

    @NotNull
    public Collection<CssPseudoSelectorDescriptor> getDescriptors() {
        Collection<CssPseudoSelectorDescriptor> collection = this.getDescriptors((PsiElement)this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getDescriptors"));
        }
        return collection;
    }

    @NotNull
    public Collection<CssPseudoSelectorDescriptor> getDescriptors(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getDescriptors"));
        }
        Collection descriptors = CssDescriptorsUtil.getPseudoSelectorDescriptors((String)this.getName(), (PsiElement)context);
        Collection filteredDescriptors = CssDescriptorsUtil.filterDescriptorsByContext((Collection)descriptors, (PsiElement)context);
        Collection collection = CssDescriptorsUtil.filterPseudoSelectorDescriptorsByColonPrefix((Collection)(filteredDescriptors.isEmpty() ? descriptors : filteredDescriptors), (int)this.getColonPrefixLength());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getDescriptors"));
        }
        return collection;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "setName"));
        }
        PsiElement token = this.getNameIdentifier();
        if (token != null) {
            CssPsiUtil.replaceToken((PsiElement)token, (String)name);
        }
        return this;
    }

    @NotNull
    public CssSelectorSuffixType getType() {
        CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.UNKNOWN;
        if (cssSelectorSuffixType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssPseudoSelectorBase", "getType"));
        }
        return cssSelectorSuffixType;
    }

    public ItemPresentation getPresentation() {
        return new CssNamedItemPresentation((PsiNamedElement)this, CssPsiUtil.getTokenText((PsiElement)this));
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }
}

