/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.table.CssTableLoaderValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.css.impl.util.table.XmlStringWriter;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssTableGeneratorUtil {
    @NonNls
    public static final String FILE_NAME = "propidx.html";
    @NonNls
    public static final String OUTPUT_FILE_NAME = "csstable.xml";
    @NonNls
    public static final String BASE_PATH = "../CSS/src/";
    @NonNls
    private static final List<String> mySingleTagNames = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        new CssTableGeneratorUtil().generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate() throws IOException {
        String packagePath = this.getClass().getCanonicalName().replace('.', '/');
        File output = new File(BASE_PATH + packagePath.substring(0, packagePath.lastIndexOf(47)), OUTPUT_FILE_NAME);
        if (output.exists()) {
            output.delete();
        }
        try (OutputStreamWriter osw = null;){
            osw = new OutputStreamWriter(new FileOutputStream(output));
            XmlStringWriter writer = new XmlStringWriter(osw);
            Tag rootTag = CssTableGeneratorUtil.parse(this.getClass().getResourceAsStream(FILE_NAME));
            Tag tbody = CssTableGeneratorUtil.findFirstChildTag("tbody", rootTag);
            assert (tbody != null);
            writer.addAttribute("version", "2_1");
            writer.addAttribute("generator-version", "9");
            writer.addAttribute("baseHelpRef", "http://www.w3.org/TR/CSS21/");
            writer.printlnOpeningTag("css-property-table");
            CssTableGeneratorUtil.generate(tbody, writer);
            writer.printlnClosingTag();
            writer.flush();
            osw.flush();
            osw.close();
        }
    }

    private static void generate(@NotNull Tag tbody, final @NotNull XmlStringWriter writer) {
        if (tbody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tbody", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "generate"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "generate"));
        }
        final ArrayList properties = new ArrayList();
        tbody.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$1", "fun"));
                }
                properties.addAll(CssTableGeneratorUtil.gatherNames(t.getChildren().get(0)));
            }
        }, "tr");
        tbody.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$2", "fun"));
                }
                CssTableGeneratorUtil.proceedRow(t, properties, writer);
            }
        }, "tr");
    }

    private static void proceedRow(@NotNull Tag row, @NotNull List<String> properties, @NotNull XmlStringWriter writer) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "proceedRow"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "proceedRow"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "proceedRow"));
        }
        List<Tag> children = row.getChildren();
        List<String> propertyNames = CssTableGeneratorUtil.gatherNames(children.get(0));
        for (String propertyName : propertyNames) {
            writer.addAttribute("name", propertyName);
            writer.addAttribute("helpRef", CssTableGeneratorUtil.gatherHelpRef(children.get(0)));
            writer.addAttribute("initialValue", CssTableGeneratorUtil.gatherTdValue(children.get(2), null));
            writer.addAttribute("appliesTo", CssTableGeneratorUtil.gatherTdValue(children.get(3), "all"));
            writer.addAttribute("inherited", CssTableGeneratorUtil.gatherTdValue(children.get(4), null));
            writer.addAttribute("percentage", CssTableGeneratorUtil.gatherTdValue(children.get(5), "n/a"));
            writer.addAttribute("mediaGroup", CssTableGeneratorUtil.gatherMediaGroup(children.get(6)));
            writer.printlnOpeningTag("property");
            CssTableGeneratorUtil.gatherValues(propertyName, children.get(1), properties, writer);
            writer.printlnClosingTag();
        }
    }

    private static void gatherValues(@NotNull String propertyName, @NotNull Tag td, final @NotNull List<String> properties, @NotNull XmlStringWriter writer) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherValues"));
        }
        if (td == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "td", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherValues"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherValues"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherValues"));
        }
        final StringBuffer sb = new StringBuffer();
        td.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$3", "fun"));
                }
                CssTableGeneratorUtil.accumulateValue(t, properties, sb);
            }
        }, null);
        CssTableLoaderValue value = CssTableGeneratorUtil.processValuesList(sb.toString());
        CssTableGeneratorUtil.collapseEmptyGroups(value);
        value.write(propertyName, writer);
    }

    public static void collapseEmptyGroups(@NotNull CssTableLoaderValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "collapseEmptyGroups"));
        }
        value.accept((CssTableValueVisitor)new CssTableValueVisitor<CssTableLoaderValue>(){

            public void visit(@NotNull CssTableLoaderValue value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$4", "visit"));
                }
                if (value.isGroup()) {
                    List children = value.getChildren();
                    if (children.size() == 1) {
                        CssTableLoaderValue value1 = (CssTableLoaderValue)children.get(0);
                        if (value1.isGroup()) {
                            value.setType(value1.getType());
                            if (value.getMinCount() == -1) {
                                value.setMaxCount(value1.getMaxCount());
                                value.setMinCount(value1.getMinCount());
                            }
                            value.removeChild(value1);
                            List children1 = value1.getChildren();
                            for (CssTableLoaderValue each : children1.toArray(new CssTableLoaderValue[children1.size()])) {
                                value1.removeChild(each);
                                value.addChild(each);
                            }
                            value.accept(this);
                        }
                    } else {
                        for (CssTableLoaderValue each : value.getChildren()) {
                            each.accept(this);
                        }
                    }
                }
            }
        });
    }

    public static CssTableLoaderValue processValuesList(@NotNull String values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "processValuesList"));
        }
        return CssTableGeneratorUtil.processValuesList(values, false);
    }

    public static CssTableLoaderValue processValuesList(@NotNull String values, boolean separateComma) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "processValuesList"));
        }
        CssTableLoaderValue g = new CssTableLoaderValue(CssTableValue.Type.DEFAULT);
        CssTableLoaderValue prev = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer old = null;
        boolean orChar = false;
        boolean doubleOrChar = false;
        block11: for (byte ch : values.getBytes()) {
            char c = (char)ch;
            switch (c) {
                case '[': {
                    CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    sb = new StringBuffer();
                    g = g.addChild(new CssTableLoaderValue(CssTableValue.Type.DEFAULT));
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case ']': {
                    CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    sb = new StringBuffer();
                    prev = g;
                    g = g.getParent();
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '{': {
                    old = sb;
                    sb = new StringBuffer();
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '}': {
                    String countValue = sb.toString();
                    String[] strings = countValue.split(",");
                    assert (strings.length == 2);
                    assert (old != null);
                    CssTableLoaderValue p = CssTableGeneratorUtil.flushProperty(g, old.toString().trim(), doubleOrChar);
                    if (p != null) {
                        p.setMinCount(Integer.valueOf(strings[0]));
                        p.setMaxCount(Integer.valueOf(strings[1]));
                    } else {
                        prev.setMinCount(Integer.valueOf(strings[0]));
                        prev.setMaxCount(Integer.valueOf(strings[1]));
                    }
                    sb = new StringBuffer();
                    old = null;
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '+': {
                    CssTableLoaderValue p1 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    if (p1 != null) {
                        p1.setMinCount(1);
                        p1.setMaxCount(-1);
                    } else {
                        assert (prev != null);
                        prev.setMinCount(1);
                        prev.setMaxCount(-1);
                    }
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '*': {
                    CssTableLoaderValue p2 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    if (p2 != null) {
                        p2.setMinCount(0);
                        p2.setMaxCount(-1);
                    } else {
                        assert (prev != null);
                        prev.setMinCount(0);
                        prev.setMaxCount(-1);
                    }
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '?': {
                    CssTableLoaderValue p3 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    if (p3 != null) {
                        p3.setMinCount(0);
                        p3.setMaxCount(1);
                    } else {
                        assert (prev != null);
                        prev.setMinCount(0);
                        prev.setMaxCount(1);
                    }
                    sb = new StringBuffer();
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '|': {
                    CssTableLoaderValue p4 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    g.setType(CssTableValue.Type.OR);
                    if (orChar) {
                        doubleOrChar = true;
                        if (p4 != null) {
                            p4.setType(CssTableValue.Type.ANY);
                        } else {
                            g.setType(CssTableValue.Type.ANY);
                        }
                    } else {
                        doubleOrChar = false;
                    }
                    sb = new StringBuffer();
                    orChar = true;
                    continue block11;
                }
                case ',': {
                    if (separateComma) {
                        sb = new StringBuffer();
                        CssTableGeneratorUtil.flushProperty(g, ",", doubleOrChar);
                        continue block11;
                    }
                }
                default: {
                    orChar = false;
                    sb.append(c);
                }
            }
        }
        CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
        while (g.getParent() != null) {
            g = g.getParent();
        }
        return g;
    }

    @Nullable
    private static CssTableLoaderValue flushProperty(@NotNull CssTableLoaderValue group, @NotNull String name, boolean orChar) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "flushProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "flushProperty"));
        }
        if (!name.isEmpty()) {
            if (-1 != name.indexOf(32) && -1 == name.indexOf(40) && -1 == name.indexOf(44) && -1 == name.indexOf(47)) {
                String[] values = name.split(" ");
                CssTableLoaderValue g1 = new CssTableLoaderValue(CssTableValue.Type.DEFAULT);
                CssTableLoaderValue result = null;
                for (String value : values) {
                    result = g1.addChild(new CssTableLoaderValue(value));
                }
                group.addChild(g1);
                assert (result != null);
                return result;
            }
            if (-1 != name.indexOf(47)) {
                String[] values = name.split(" ");
                assert (values.length == 2);
                CssTableLoaderValue result = new CssTableLoaderValue(values[1]);
                result.setPrefix(values[0]);
                return group.addChild(result);
            }
            if (orChar) {
                group.setType(CssTableValue.Type.ANY);
            }
            return group.addChild(new CssTableLoaderValue(name));
        }
        return null;
    }

    private static void accumulateValue(@NotNull Tag tag, final @NotNull List<String> properties, final @NotNull StringBuffer sb) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "accumulateValue"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "accumulateValue"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "accumulateValue"));
        }
        if (tag.isValueTag()) {
            Tag parent = tag.getParent();
            while (!"td".equals(parent.getName()) && !"a".equals(parent.getName())) {
                parent = parent.getParent();
            }
            String value = CssTableGeneratorUtil.stripLtGt(StringUtil.stripQuotesAroundValue((String)tag.getValue().trim()));
            if (properties.contains(value)) {
                sb.append(' ').append(value).append("#propref");
            } else if ("a".equals(parent.getName())) {
                String href = parent.getAttributeValue("href");
                if (href != null) {
                    if (href.contains("value-def")) {
                        sb.append(' ').append(value).append("#helpref=").append(href.substring(href.lastIndexOf(47) + 1));
                    } else if (href.contains("propdef")) {
                        sb.append(' ').append(value).append("#propref");
                    }
                }
            } else {
                sb.append(' ').append(tag.getValue());
            }
        }
        tag.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$5", "fun"));
                }
                CssTableGeneratorUtil.accumulateValue(t, properties, sb);
            }
        }, null);
    }

    @NotNull
    private static String stripLtGt(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "stripLtGt"));
        }
        String string = s.replaceAll("&lt;([^&]+)&gt;", "$1");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "stripLtGt"));
        }
        return string;
    }

    private static String gatherMediaGroup(@NotNull Tag td) {
        if (td == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "td", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherMediaGroup"));
        }
        Tag a = CssTableGeneratorUtil.findFirstChildTag("a", td);
        assert (a != null);
        return a.getChildren().get(0).getValue();
    }

    private static String gatherTdValue(@NotNull Tag td, @NonNls @Nullable String defValue) {
        if (td == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "td", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherTdValue"));
        }
        List<Tag> children = td.getChildren();
        if (children.isEmpty() && defValue != null) {
            return defValue;
        }
        return td.getChildren().get(0).getValue();
    }

    private static String gatherHelpRef(@NotNull Tag td) {
        if (td == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "td", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherHelpRef"));
        }
        Tag a = CssTableGeneratorUtil.findFirstChildTag("a", td);
        assert (a != null);
        String href = a.getAttributeValue("href");
        assert (href != null);
        int index = href.lastIndexOf("/");
        return href.substring(index + 1);
    }

    private static List<String> gatherNames(@NotNull Tag td) {
        if (td == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "td", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "gatherNames"));
        }
        List<Tag> spanList = CssTableGeneratorUtil.findSubTags("span", td);
        ArrayList<String> result = new ArrayList<String>();
        for (Tag span : spanList) {
            result.add(StringUtil.stripQuotesAroundValue((String)span.getChildren().get(0).getValue()));
        }
        return result;
    }

    @Nullable
    private static Tag findFirstChildTag(@NotNull @NonNls String name, @NotNull Tag root) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "findFirstChildTag"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "findFirstChildTag"));
        }
        if (name.equals(root.getName())) {
            return root;
        }
        for (Tag child : root.getChildren()) {
            Tag tag = CssTableGeneratorUtil.findFirstChildTag(name, child);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    @NotNull
    private static List<Tag> findSubTags(@NotNull @NonNls String name, @NotNull Tag root) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "findSubTags"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "findSubTags"));
        }
        if (name.equals(root.getName())) {
            ArrayList<Tag> result = new ArrayList<Tag>();
            result.add(root);
            ArrayList<Tag> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "findSubTags"));
            }
            return arrayList;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag child : root.getChildren()) {
            List<Tag> tempList = CssTableGeneratorUtil.findSubTags(name, child);
            result.addAll(tempList);
        }
        ArrayList<Tag> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "findSubTags"));
        }
        return arrayList;
    }

    private static Tag parse(@NotNull InputStream is) throws IOException {
        int c;
        if (is == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil", "parse"));
        }
        boolean tagStart = false;
        StringBuffer startNameBuffer = null;
        StringBuffer endNameBuffer = null;
        StringBuffer valueBuffer = null;
        StringBuffer currentBuffer = null;
        Tag current = null;
        block6: while ((c = is.read()) != -1) {
            switch ((char)c) {
                case '<': {
                    if (valueBuffer != null && current != null) {
                        String value = valueBuffer.toString().trim();
                        if (!value.isEmpty()) {
                            current.addChild(Tag.createValueTag(value));
                        }
                        valueBuffer = null;
                    }
                    tagStart = true;
                    currentBuffer = startNameBuffer = new StringBuffer();
                    continue block6;
                }
                case '>': {
                    if (startNameBuffer != null) {
                        Tag childTag = Tag.parseTag(startNameBuffer.toString());
                        if (current != null) {
                            current.addChild(childTag);
                        }
                        if (!mySingleTagNames.contains(childTag.getName())) {
                            current = childTag;
                        }
                        startNameBuffer = null;
                    } else if (endNameBuffer != null) {
                        if (current != null) {
                            String closeName = endNameBuffer.toString();
                            while (current != null && !closeName.equals(current.getName())) {
                                current = current.getParent();
                            }
                            if (current != null) {
                                current = current.getParent();
                            }
                        }
                        endNameBuffer = null;
                    }
                    currentBuffer = valueBuffer = new StringBuffer();
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\u00a0': {
                    continue block6;
                }
                case '/': {
                    if (!tagStart) break;
                    startNameBuffer = null;
                    currentBuffer = endNameBuffer = new StringBuffer();
                    continue block6;
                }
            }
            tagStart = false;
            if (currentBuffer == null) continue;
            currentBuffer.append((char)c);
        }
        return current;
    }

    static {
        mySingleTagNames.add("hr");
        mySingleTagNames.add("link");
        mySingleTagNames.add("meta");
        mySingleTagNames.add("br");
    }

    static interface TagFunction {
        public void fun(@NotNull Tag var1);
    }

    private static class Tag {
        private Tag myParent;
        private final Map<String, String> myAttributes;
        private final List<Tag> myChildren;
        private String myValue;
        private String myName;

        private Tag(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "<init>"));
            }
            this.myAttributes = new THashMap();
            this.myChildren = new ArrayList<Tag>();
            this.myName = name;
        }

        private Tag() {
            this.myAttributes = new THashMap();
            this.myChildren = new ArrayList<Tag>();
        }

        public static Tag createValueTag(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "createValueTag"));
            }
            Tag tag = new Tag();
            tag.setValue(s);
            return tag;
        }

        public static Tag parseTag(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "parseTag"));
            }
            StringTokenizer tokenizer = new StringTokenizer(s);
            Tag result = new Tag(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String pair = tokenizer.nextToken();
                int eqNdx = pair.indexOf(61);
                if (eqNdx != -1) {
                    result.addAttribute(pair.substring(0, eqNdx), StringUtil.stripQuotesAroundValue((String)pair.substring(eqNdx + 1)));
                    continue;
                }
                result.addAttribute(pair, null);
            }
            return result;
        }

        public void for_each(@NotNull TagFunction func, @NonNls @Nullable String nameFilter) {
            if (func == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "for_each"));
            }
            for (Tag tag : this.getChildren()) {
                if ((nameFilter == null || !nameFilter.equals(tag.getName())) && nameFilter != null) continue;
                func.fun(tag);
            }
        }

        @NonNls
        public String getName() {
            return this.myName;
        }

        public void addAttribute(@NotNull String name, @Nullable String value) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "addAttribute"));
            }
            this.myAttributes.put(name, value);
        }

        public void setParent(Tag parent) {
            this.myParent = parent;
        }

        public void addChild(@NotNull Tag child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "addChild"));
            }
            this.myChildren.add(child);
            child.setParent(this);
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        @NotNull
        public List<Tag> getChildren() {
            List<Tag> list = this.myChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "getChildren"));
            }
            return list;
        }

        public String getValue() {
            return this.myValue;
        }

        public Tag getParent() {
            return this.myParent;
        }

        public boolean isValueTag() {
            return this.myValue != null;
        }

        @Nullable
        public String getAttributeValue(@NonNls @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag", "getAttributeValue"));
            }
            return this.myAttributes.get(name);
        }

        public String toString() {
            if (this.myName == null) {
                return this.myValue;
            }
            StringBuilder result = new StringBuilder(this.getName());
            if (!this.myAttributes.isEmpty()) {
                result.append(" [");
                for (String key : this.myAttributes.keySet()) {
                    result.append(" ").append(key).append("=").append(this.myAttributes.get(key));
                }
                result.append("]");
            }
            return result.toString();
        }
    }
}

