/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.xml.impl.mapping;

import com.intellij.hibernate.model.converters.AttributeMemberConverter;
import com.intellij.hibernate.model.enums.AccessType;
import com.intellij.hibernate.model.enums.HibernateAttributeType;
import com.intellij.hibernate.model.xml.impl.mapping.HbmHibernateMappingImpl;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmColumnsHolderBase;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeMapKey;
import com.intellij.hibernate.model.xml.mapping.HbmContainer;
import com.intellij.hibernate.model.xml.mapping.HbmEmbeddedAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmId;
import com.intellij.hibernate.model.xml.mapping.HbmKeyManyToOne;
import com.intellij.hibernate.model.xml.mapping.HbmKeyProperty;
import com.intellij.hibernate.model.xml.mapping.HbmMap;
import com.intellij.hibernate.model.xml.mapping.HbmMapKey;
import com.intellij.hibernate.model.xml.mapping.HbmMapKeyManyToMany;
import com.intellij.hibernate.model.xml.mapping.HbmPersistentObjectBase;
import com.intellij.hibernate.model.xml.mapping.HbmTypeHolderBase;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jam.model.common.BaseImpl;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.helpers.PersistentAttributeModelHelper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HbmAttributeBaseImpl
extends BaseImpl
implements HbmAttributeBase {
    private static final Function<PersistentAttribute, PsiType> TYPE_PROVIDER = persistentAttribute -> {
        if (persistentAttribute instanceof HbmTypeHolderBase) {
            PsiClass value;
            HbmTypeHolderBase typeHolder = (HbmTypeHolderBase)persistentAttribute;
            Object componentType = DomUtil.hasXml(typeHolder.getTypeAttr()) ? (PsiType)typeHolder.getTypeAttr().getValue() : ((value = (PsiClass)typeHolder.getType().getName().getValue()) == null ? null : JavaPsiFacade.getInstance((Project)value.getProject()).getElementFactory().createType(value));
            DomElement parent = typeHolder.getParent();
            if (parent instanceof HbmContainer) {
                return HibernateAttributeType.createContainerType((HbmContainer)parent, componentType);
            }
            return componentType;
        }
        return null;
    };
    private final PersistentAttributeModelHelper myHelper = this.createHelper();

    protected HbmAttributeBaseImpl() {
    }

    protected PersistentAttributeModelHelper createHelper() {
        return new MyHelper();
    }

    @NotNull
    public PersistentAttributeModelHelper getAttributeModelHelper() {
        PersistentAttributeModelHelper persistentAttributeModelHelper = this.myHelper;
        if (persistentAttributeModelHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/xml/impl/mapping/HbmAttributeBaseImpl", "getAttributeModelHelper"));
        }
        return persistentAttributeModelHelper;
    }

    @Nullable
    public PsiType getPsiType() {
        return JpaUtil.findType((PersistentAttribute)this, TYPE_PROVIDER);
    }

    @Override
    public GenericDomValue<String> getName() {
        return JpaUtil.toGenericStringValue(this.getClass(), () -> this.getTargetMember());
    }

    @Override
    @Nullable
    public PsiMember getPsiMember() {
        return (PsiMember)this.getTargetMember().getValue();
    }

    @Nullable
    public PersistentObject getPersistentObject() {
        for (DomElement cur = this.getParent(); cur != null; cur = cur.getParent()) {
            if (cur instanceof HbmPersistentObjectBase) {
                return (HbmPersistentObjectBase)cur;
            }
            if (!(cur instanceof HbmEmbeddedAttributeBase) || cur instanceof HbmCompositeId && !HibernateUtil.isEmbedded((HbmCompositeId)cur)) continue;
            HbmHibernateMappingImpl mappings = (HbmHibernateMappingImpl)cur.getParentOfType(HbmHibernateMappingImpl.class, true);
            if (mappings == null) {
                return null;
            }
            return mappings.getEmbeddableByAttribute((HbmEmbeddedAttributeBase)cur);
        }
        return null;
    }

    protected class MyHelper
    implements PersistentAttributeModelHelper {
        protected MyHelper() {
        }

        public HbmAttributeBaseImpl getDelegate() {
            return HbmAttributeBaseImpl.this;
        }

        public boolean isFieldAccess() {
            AccessType thisAccess = (AccessType)((Object)HbmAttributeBaseImpl.this.getAccess().getValue());
            return thisAccess == AccessType.FIELD || thisAccess == null && AttributeMemberConverter.isDefaultAccessField((DomElement)this.getDelegate());
        }

        public boolean isIdAttribute() {
            return this.getDelegate() instanceof HbmId || this.getDelegate() instanceof HbmKeyProperty || this.getDelegate() instanceof HbmKeyManyToOne;
        }

        public List<? extends GenericValue<String>> getMappedColumns() {
            if (this.getDelegate() instanceof HbmColumnsHolderBase) {
                HbmColumnsHolderBase columnsHolder = (HbmColumnsHolderBase)((Object)this.getDelegate());
                if (DomUtil.hasXml(columnsHolder.getColumn())) {
                    return Collections.singletonList(columnsHolder.getColumn());
                }
                return ContainerUtil.map2List(columnsHolder.getColumns(), hbmColumn -> hbmColumn.getName());
            }
            return Collections.emptyList();
        }

        public boolean isContainer() {
            return this.getDelegate().getParent() instanceof HbmContainer;
        }

        public boolean isLob() {
            PsiType type = HbmAttributeBaseImpl.this.getPsiType();
            PsiClass psiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
            return JamCommonUtil.isSuperClass((PsiClass)psiClass, (String)"java.sql.Blob") || JamCommonUtil.isSuperClass((PsiClass)psiClass, (String)"java.sql.Clob");
        }

        public GenericValue<PsiClass> getMapKeyClass() {
            DomElement parent = this.getDelegate().getParent();
            if (parent instanceof HbmMap) {
                HbmCompositeMapKey compositeMapKey;
                HbmMap hbmMap = (HbmMap)parent;
                HbmMapKey mapKey = hbmMap.getMapKey();
                if (DomUtil.hasXml((DomElement)mapKey)) {
                    PsiClass type = PsiTypesUtil.getPsiClass((PsiType)((PsiType)mapKey.getType().getValue()));
                    return type == null ? ReadOnlyGenericValue.nullInstance() : ReadOnlyGenericValue.getInstance((Object)type);
                }
                HbmMapKeyManyToMany mapKeyManyToMany = hbmMap.getMapKeyManyToMany();
                Object type = DomUtil.hasXml((DomElement)mapKeyManyToMany) ? (PsiClass)mapKeyManyToMany.getClazz().getValue() : (DomUtil.hasXml((DomElement)(compositeMapKey = hbmMap.getCompositeMapKey())) ? (PsiClass)compositeMapKey.getClazz().getValue() : null);
                if (type != null) {
                    return ReadOnlyGenericValue.getInstance((Object)type);
                }
            }
            return ReadOnlyGenericValue.nullInstance();
        }
    }
}

