/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetEditorsFactory;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tapestry.intellij.facet.TapestryFacet;
import com.intellij.tapestry.intellij.facet.TapestryLibrariesValidatorDescription;
import com.intellij.tapestry.intellij.facet.TapestryVersion;
import com.intellij.tapestry.intellij.facet.ui.FacetEditor;
import java.net.URL;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TapestryFacetConfiguration
implements FacetConfiguration {
    private String _filterName;
    private String _applicationPackage;
    private TapestryVersion _version;

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        FacetLibrariesValidator validator = FacetEditorsFactory.getInstance().createLibrariesValidator(TapestryFacetConfiguration.getLibraryInfos(TapestryVersion.TAPESTRY_5_3_6.toString()), (FacetLibrariesValidatorDescription)new TapestryLibrariesValidatorDescription(), editorContext, validatorsManager);
        validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
        return new FacetEditorTab[]{new FacetEditor((TapestryFacet)editorContext.getFacet(), this)};
    }

    @NotNull
    public static LibraryInfo[] getLibraryInfos(@NotNull String versionId) {
        if (versionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionId", "com/intellij/tapestry/intellij/facet/TapestryFacetConfiguration", "getLibraryInfos"));
        }
        Artifact version = LibrariesDownloadAssistant.findVersion((String)versionId, (URL[])new URL[]{TapestryFacetConfiguration.getUrl()});
        if (version != null) {
            LibraryInfo[] libraryInfoArray = LibrariesDownloadAssistant.getLibraryInfos((Artifact)version);
            if (libraryInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/facet/TapestryFacetConfiguration", "getLibraryInfos"));
            }
            return libraryInfoArray;
        }
        if (LibraryInfo.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/facet/TapestryFacetConfiguration", "getLibraryInfos"));
        }
        return LibraryInfo.EMPTY_ARRAY;
    }

    private static URL getUrl() {
        return TapestryFacetConfiguration.class.getResource("/libraries/tapestry.xml");
    }

    public void readExternal(Element element) throws InvalidDataException {
        this._filterName = JDOMExternalizer.readString((Element)element, (String)"filterName");
        this._applicationPackage = JDOMExternalizer.readString((Element)element, (String)"applicationPackage");
        this._version = TapestryVersion.fromString(JDOMExternalizer.readString((Element)element, (String)"version"));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JDOMExternalizer.write((Element)element, (String)"filterName", (String)this._filterName);
        JDOMExternalizer.write((Element)element, (String)"applicationPackage", (String)this._applicationPackage);
        JDOMExternalizer.write((Element)element, (String)"version", this._version != null ? this._version.toString() : null);
    }

    public String getFilterName() {
        return this._filterName;
    }

    public void setFilterName(String filterName) {
        this._filterName = filterName;
    }

    public String getApplicationPackage() {
        return this._applicationPackage;
    }

    public void setApplicationPackage(String applicationPackage) {
        this._applicationPackage = applicationPackage;
    }

    public TapestryVersion getVersion() {
        return this._version;
    }

    public void setVersion(TapestryVersion version) {
        this._version = version;
    }
}

