/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class HelperFilesLocator {
    private static final String HELPERS_DIR = "helpers";

    @NotNull
    public static File getBundledHelpersDir() {
        String jarPath = PathUtil.getJarPathForClass(HelperFilesLocator.class);
        if (!jarPath.endsWith(".jar")) {
            File file = new File(jarPath, HELPERS_DIR);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/HelperFilesLocator", "getBundledHelpersDir"));
            }
            return file;
        }
        File jarFile = new File(jarPath);
        if (!jarFile.isFile()) {
            throw new RuntimeException("Not a file (" + jarFile.getAbsolutePath() + ")");
        }
        File pluginBaseDir = jarFile.getParentFile().getParentFile();
        File file = new File(pluginBaseDir, HELPERS_DIR);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/HelperFilesLocator", "getBundledHelpersDir"));
        }
        return file;
    }

    @NotNull
    public static File getFileRelativeToHelpersDir(@NotNull String relativePath) throws IOException {
        String systemDependentRelativePath;
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javascript/HelperFilesLocator", "getFileRelativeToHelpersDir"));
        }
        File jsDir = HelperFilesLocator.getBundledHelpersDir();
        File file = new File(jsDir, systemDependentRelativePath = FileUtil.toSystemDependentName((String)relativePath));
        if (!file.isFile()) {
            throw new IOException("Cannot find " + relativePath + ", not a file " + file.getAbsolutePath());
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/HelperFilesLocator", "getFileRelativeToHelpersDir"));
        }
        return file2;
    }
}

