/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class StylelintPackage {
    private static final String UNDEFINED_VERSION = "<unknown>";
    private final File myCli;
    private final String myVersion;

    public StylelintPackage(@NotNull NodePackage pkg) throws IOException {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "<init>"));
        }
        if (StringUtil.isEmpty((String)pkg.getSystemDependentPath())) {
            throw new IOException("Please specify Stylelint package");
        }
        File dir = new File(pkg.getSystemDependentPath());
        if (!dir.isDirectory() || !dir.isAbsolute()) {
            throw new IOException("Please specify Stylelint package correctly: no such directory");
        }
        this.myCli = new File(dir, "dist" + File.separator + "cli.js");
        if (!this.myCli.isFile()) {
            throw new IOException("Please specify Stylelint package correctly: \".../dist/cli.js\" file not found");
        }
        SemVer stylelintVersion = NodePackageVersionUtil.getPackageVersion(dir);
        this.myVersion = stylelintVersion != null ? stylelintVersion.getRawVersion() : UNDEFINED_VERSION;
    }

    @NotNull
    public File getCli() {
        File file = this.myCli;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "getCli"));
        }
        return file;
    }

    @NotNull
    public String getVersionStr() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintPackage", "getVersionStr"));
        }
        return string;
    }
}

