/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6ReplaceImportFromClauseFix
extends FixAndIntentionAction {
    private static final String ACTION_TEXT = "Replace import";
    private final String myUnquotedText;

    public ES6ReplaceImportFromClauseFix(@NotNull ES6ImportExportDeclaration importDeclaration, @NotNull String unquotedText) {
        if (importDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDeclaration", "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix", "<init>"));
        }
        if (unquotedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedText", "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix", "<init>"));
        }
        this.myUnquotedText = unquotedText;
        this.registerElementRefForFix((PsiElement)importDeclaration, null);
    }

    @Nls
    @NotNull
    public String getName() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String string = ES6ReplaceImportFromClauseFix.getActionText("");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix", "getName"));
            }
            return string;
        }
        String string = ES6ReplaceImportFromClauseFix.getActionText(StringUtil.wrapWithDoubleQuote((String)this.myUnquotedText));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix", "getName"));
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        if (!psiElement.isValid()) {
            return;
        }
        if (!(psiElement instanceof ES6ImportExportDeclaration)) {
            return;
        }
        ES6ImportExportDeclaration importDeclaration = (ES6ImportExportDeclaration)psiElement;
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        ASTNode node = clause.getNode();
        ASTNode oldValue = node.findChildByType(JSTokenTypes.STRING_LITERALS);
        if (oldValue == null) {
            return;
        }
        String quote = ES6ReplaceImportFromClauseFix.getQuote(oldValue);
        ASTNode newLiteral = JSChangeUtil.createNameIdentifier(project, quote + this.myUnquotedText + quote, (IElementType)null);
        node.replaceChild(oldValue, newLiteral);
    }

    private static String getQuote(ASTNode oldValue) {
        String text = oldValue.getText();
        return StringUtil.isEmpty((String)text) ? "\"" : String.valueOf(text.charAt(0));
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public static String getActionText(@NotNull String with) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix", "getActionText"));
        }
        String string = JSBundle.message((String)"es6.replace.import.action.name", (Object[])new Object[]{with});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix", "getActionText"));
        }
        return string;
    }
}

