/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSmartCompletionVariantsHandler {
    private static final Key<PsiElement> ourPlaceKey = Key.create((String)"place");

    @Nullable
    static Collection getSmartVariants(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/completion/JSSmartCompletionVariantsHandler", "getSmartVariants"));
        }
        JSSmartCompletionContributor contributor = (JSSmartCompletionContributor)JSSmartCompletionContributor.EP_NAME.forLanguage(DialectDetector.languageOfElement((PsiElement)expr));
        if (contributor == null) {
            return null;
        }
        List<?> variants = contributor.getSmartCompletionVariants(expr);
        return variants != null ? JSSmartCompletionVariantsHandler.wrapVariants(variants, (PsiElement)expr) : null;
    }

    @Nullable
    private static List<?> wrapVariants(@NotNull List<?> variants, PsiElement expr) {
        Object nextParameter;
        Object[] parameters;
        int index;
        JSArgumentList argumentList;
        JSParameterItem parameter;
        PsiElement parent;
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/lang/javascript/completion/JSSmartCompletionVariantsHandler", "wrapVariants"));
        }
        if (!variants.isEmpty() && (parent = expr.getParent()) instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)expr, argumentList = (JSArgumentList)parent)) instanceof JSParameter && (index = ArrayUtil.indexOf((Object[])(parameters = ((JSParameterList)((JSParameter)parameter).getParent()).getParameters()), (Object)parameter)) >= 0 && index + 1 < parameters.length && !(nextParameter = parameters[index + 1]).isOptional() && !nextParameter.isRest()) {
            for (Object o : variants) {
                if (!(o instanceof LookupItem)) continue;
                ((LookupItem)o).setAttribute(JSInsertHandler.FORCED_TAIL_TYPE, (Object)TailType.COMMA);
            }
        }
        return variants;
    }

    public static boolean isAcceptableVariant(PsiElement element, @NotNull JSType expectedType, ProcessingContext processingContext) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/lang/javascript/completion/JSSmartCompletionVariantsHandler", "isAcceptableVariant"));
        }
        if (expectedType instanceof JSPrimitiveFunctionType && element instanceof JSFunction && !((JSFunction)element).isGetProperty()) {
            return true;
        }
        JSType elementType = JSTypeImpl.fromElement(element, (PsiElement)processingContext.get(ourPlaceKey));
        if (elementType == null) {
            return false;
        }
        String typeText = elementType.getTypeText();
        Boolean aBoolean = (Boolean)processingContext.get((Object)typeText);
        if (aBoolean == Boolean.TRUE) {
            return true;
        }
        if (aBoolean == Boolean.FALSE) {
            return false;
        }
        boolean result = JSTypeUtils.typeCanBeAssignedWithoutCoercion(expectedType, elementType) && expectedType.isDirectlyAssignableType(elementType, processingContext);
        processingContext.put((Object)typeText, (Object)(result ? Boolean.TRUE : Boolean.FALSE));
        return result;
    }

    public static ProcessingContext initProcessingContext(PsiElement place) {
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourPlaceKey, (Object)place);
        return processingContext;
    }
}

