/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntIntHashMap;
import gnu.trove.decorator.TIntIntHashMapDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationUtils {
    private static final String NAME = "[\\p{L}_\\$][\\p{LD}_\\$-]*";
    private static final String PARAM_FIELD = "((?:(?:\\[\\])*\\.[\\p{L}_\\$][\\p{LD}_\\$-]*)+)?";
    private static final String NAMEPATH = "[\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?";
    private static final Pattern ourDojoParametersPattern = Pattern.compile("^\\s*([\\p{L}_\\$][\\p{LD}_\\$-]*):(.*)$", 64);
    private static final Pattern ourJSDocParametersPattern = Pattern.compile("^\\s*@param((:? |\\s*\\{).*)$");
    private static final Pattern ourJSDocParametersRestPattern = Pattern.compile("^\\s*(?:(\\[?\\(?\\{?`?([\\p{L}_\\$][\\p{LD}_\\$-]*)((?:(?:\\[\\])*\\.[\\p{L}_\\$][\\p{LD}_\\$-]*)+)?(\\.\\.\\.)?`?(?:\\s*=\\s*((?:\\[[^\\]]*\\])|[^\\]\\s]*|(?:'[^']*')|(?:\"[^\"]*\")))?\\)?\\]?)(?:\\s:\\s(\\S+))?)?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourYuiDocParametersPattern = Pattern.compile("^\\s*([\\p{L}_\\$][\\p{LD}_\\$-]*)\\s*(\\{.*)$");
    private static final Pattern ourJSDocEventPattern = Pattern.compile("^\\s*@event\\s*([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(?:\\s:\\s(\\S+))?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocRemarkPattern = Pattern.compile("^\\s*@remarks (.*)$");
    private static final Pattern ourJSDocMethodPattern = Pattern.compile("^\\s*@method(?:\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*)(.*))?$");
    private static final Pattern ourJSDocClassPattern = Pattern.compile("^\\s*@class(?:\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)\\s*|(\\s.*)?)$");
    private static final Pattern ourJSDocDeprecatedPattern = Pattern.compile("^\\s*@deprecated\\s*(.*)$");
    private static final Pattern ourJSDocConstructorPattern = Pattern.compile("^\\s*@constructor\\s*$");
    private static final Pattern ourJSDocConstructsPattern = Pattern.compile("^\\s*@construct(?:s?)\\s*$");
    private static final Pattern ourJSDocConstantPattern = Pattern.compile("^\\s*@const(?:ant)?(?:\\s+(.*))?$");
    private static final Pattern ourJSDocFinalPattern = Pattern.compile("^\\s*@final\\s*$");
    private static final Pattern ourJSDocPrivatePattern = Pattern.compile("^\\s*@private(?:\\s+(.+)|\\s*)$");
    private static final Pattern ourJSDocPublicPattern = Pattern.compile("^\\s*@public(?:\\s+(.+)|\\s*)$");
    private static final Pattern ourJSDocProtectedPattern = Pattern.compile("^\\s*@protected(?:\\s+(.+)|\\s*)$");
    private static final Pattern ourJSDocOptionalPattern = Pattern.compile("^\\s*@optional(.*)$");
    private static final Pattern ourJSDocStaticPattern = Pattern.compile("^\\s*@static\\s*$");
    private static final Pattern ourJSDocSeePattern = Pattern.compile("^\\s*@see (.*)$");
    private static final Pattern ourJSDocDescriptionPattern = Pattern.compile("^\\s*@description\\s*(.+)$");
    private static final Pattern ourJSDocReturnPattern = Pattern.compile("^\\s*@return(?:s)?\\s*(?::)?\\s*(.+)?$");
    private static final Pattern ourJSDocNamespacePattern = Pattern.compile("^\\s*@namespace\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)?(.*)$");
    private static final Pattern ourJSDocNamePattern = Pattern.compile("^\\s*@name\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocAliasPattern = Pattern.compile("^\\s*@alias\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocConfigPattern = Pattern.compile("^\\s*@config\\s*(\\{)?(.*)$");
    private static final Pattern ourJSDocPropertyPattern = Pattern.compile("^\\s*@prop(?:erty)?\\s*(\\{)?(.*)$");
    private static final Pattern ourJSDocPropertyRestPattern = Pattern.compile("^\\s*(\\[?)([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(?:\\s*=\\s*([^\\]\\s]*|(?:'[^']*')|(?:\"[^\"]*\")))?\\]?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocTypePattern = Pattern.compile("^\\s*@type([ {].*)$");
    private static final Pattern ourJSDocRequiresPattern = Pattern.compile("^\\s*@requires\\s*(\\S+)(.*)$");
    private static final Pattern ourJSDocDefaultPattern = Pattern.compile("^\\s*@default\\s*(.*)$");
    private static final Pattern ourJSDocExtendsPattern = Pattern.compile("^\\s*@extends(.*)$");
    private static final Pattern ourJSDocAugmentsPattern = Pattern.compile("^\\s*@augments(.*)$");
    private static final Pattern ourJSDocLendsPattern = Pattern.compile("^\\s*@lends(.*)$");
    private static final Pattern ourJSDocThrowsPattern = Pattern.compile("^\\s*@throws\\s*(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocLinkPattern = Pattern.compile("(\\[[^\\]]+\\])?\\{@link(?:code|plain)?\\s+([^\\}]+)\\}");
    private static final Pattern ourJSDocCfgPattern = Pattern.compile("^\\s*@cfg (?:\\{([^\\}]+)\\}\\s+)?([\\p{L}_\\$][\\p{LD}_\\$-]*)(.*)$");
    private static final Pattern ourJSDocBrowserPattern = Pattern.compile("^\\s*@browser\\s+(.*)$");
    private static final Pattern ourJSDocInheritDocPattern = Pattern.compile("^\\s*@inherit[Dd]oc(.*)$");
    private static final Pattern ourJSDocTypedefPattern = Pattern.compile("^\\s*@typedef\\s+(.*)$");
    private static final Pattern ourJSDocNameTailPattern = Pattern.compile("^([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)?(.*)$");
    private static final Pattern ourJSDocEnumPattern = Pattern.compile("^\\s*@enum(.*)$");
    private static final Pattern ourJSDocInterfacePattern = Pattern.compile("^\\s*@interface(?:\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?))?(\\s*)$");
    private static final Pattern ourJSDocImplementsPattern = Pattern.compile("^\\s*@implements(.*)$");
    private static final Pattern ourJSDocOverridePattern = Pattern.compile("^\\s*@override(.*)$");
    private static final Pattern ourJSDocThisPattern = Pattern.compile("^\\s*@this(.*)$");
    private static final Pattern ourJSDocMixinPattern = Pattern.compile("^\\s*@mixin(|[^s](.*))$");
    private static final Pattern ourJSDocMixesPattern = Pattern.compile("^\\s*@mix(es|ins)(.*)$");
    private static final Pattern ourJSDocFunctionPattern = Pattern.compile("^\\s*@func(?:tion)?(?:\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?))?(\\s*)$");
    private static final Pattern ourJSDocExportsPattern = Pattern.compile("^\\s*@exports(?:\\s+[\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?\\s+as)?\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocTemplatePattern = Pattern.compile("^\\s*@template\\s+(?:[\\{\\(<])?((?:[\\p{L}_\\$][\\p{LD}_\\$-]*|[\\s,])+)(?:\\}\\)>)?(.*)$");
    private static final Pattern ourJSDocAuthorPattern = Pattern.compile("^\\s*@author\\s+(.*)$");
    private static final Pattern ourJSDocExamplePattern = Pattern.compile("^\\s*@example(?:|(.*))$");
    private static final Pattern ourJSDocFileOverviewPattern = Pattern.compile("^\\s*@fileOverview\\s+(.*)$");
    private static final Pattern ourJSDocSincePattern = Pattern.compile("^\\s*@since\\s+(.*)$");
    private static final Pattern ourJSDocVersionPattern = Pattern.compile("^\\s*@version\\s+(.*)$");
    private static final Pattern ourJSDocMemberOfPattern = Pattern.compile("^\\s*@member[Oo]f!?\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocMethodOfPattern = Pattern.compile("^\\s*@methodOf\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocFieldOfPattern = Pattern.compile("^\\s*@fieldOf\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocAbstractPattern = Pattern.compile("^\\s*@abstract(\\s.*)?$");
    private static final Pattern ourJSDocVirtualPattern = Pattern.compile("^\\s*@virtual(\\s.*)?$");
    private static final Pattern ourJSDocCallbackPattern = Pattern.compile("^\\s*@callback\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)?$");
    private static final Pattern ourJSDocExternalPattern = Pattern.compile("^\\s*@external\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)?$");
    private static final Pattern ourJSDocHostPattern = Pattern.compile("^\\s*@host\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)?$");
    private static final Pattern ourJSDocGlobalPattern = Pattern.compile("^\\s*@global(\\s.*)?$");
    private static final Pattern ourJSDocMemberPattern = Pattern.compile("^\\s*@member\\s+(.*)$");
    private static final Pattern ourJSDocVarPattern = Pattern.compile("^\\s*@var\\s+(.*)$");
    private static final Pattern ourJSDocModulePattern = Pattern.compile("^\\s*@module(?:\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?))?(.*)$");
    private static final Pattern ourJSDocFiresPattern = Pattern.compile("^\\s*@fires\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocEmitsPattern = Pattern.compile("^\\s*@emits\\s+([\\p{L}_\\$][\\p{LD}_\\$-]*(?:[\\.#~:/][\\p{L}_\\$][\\p{LD}_\\$-]*)*#?)(.*)$");
    private static final Pattern ourJSDocTodoPattern = Pattern.compile("^\\s*@todo(?:\\s+(.*))?$");
    private static final Pattern ourJSDocExtendedTypeNamePattern = Pattern.compile("^[\\p{L}_\\$][\\p{LD}_\\$-]*$");
    private static final Map<Pattern, String> patternToHintMap = new THashMap();
    private static final Map<Pattern, JSDocumentationProcessor.MetaDocType> patternToMetaDocTypeMap = new THashMap();
    private static final Map<Pattern, JSDocumentationProcessor.MetaDocType> inlinePatternToMetaDocTypeMap = new THashMap();
    static final String HYPERLINK_SEPARATOR = "%";
    @NonNls
    private static final Map<Pattern, String> prefixToPatternToHintMap;
    private static final TokenSet DOC_COMMENT_ALLOWED_AFTER;
    public static final TokenSet ourPrimitiveTypeFilter;
    public static final TokenSet ourTypeFilter;

    public static void processDocumentationTextFromComment(ASTNode _initialComment, JSDocumentationProcessor processor) {
        Enumeration<Object> commentLineIterator;
        boolean eolComment;
        ASTNode prev = _initialComment.getTreePrev();
        if (prev != null && prev.getPsi() instanceof OuterLanguageElement) {
            while (prev != null && prev.getPsi() instanceof OuterLanguageElement) {
                prev = prev.getTreePrev();
            }
        } else {
            prev = null;
        }
        if (prev != null && !(prev.getPsi() instanceof PsiComment)) {
            prev = null;
        }
        final ASTNode initialComment = prev != null ? prev : _initialComment;
        boolean bl = eolComment = initialComment.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT;
        if (eolComment) {
            commentLineIterator = new Enumeration<Object>(){
                ASTNode commentNode;
                {
                    this.commentNode = initialComment;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.commentNode != null;
                }

                @Override
                public String nextElement() {
                    String text;
                    ASTNode resultCommentNode = this.commentNode;
                    this.commentNode = this.commentNode.getTreeNext();
                    if (this.commentNode != null && this.commentNode.getElementType() == TokenType.WHITE_SPACE) {
                        this.commentNode = this.commentNode.getTreeNext();
                    }
                    if (this.commentNode != null && this.commentNode.getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) {
                        this.commentNode = null;
                    }
                    if ((text = resultCommentNode.getText()).startsWith("//")) {
                        return text.substring(2);
                    }
                    return "";
                }
            };
        } else {
            String text = initialComment.getText();
            text = JSDocumentationUtils.unwrapCommentDelimiters(text);
            commentLineIterator = new StringTokenizer(text, "\r\n");
        }
        boolean needPlainCharData = processor.needsPlainCommentData();
        String lastParameterName = null;
        DocTag tag = null;
        String multilineCommentTag = null;
        while (commentLineIterator.hasMoreElements()) {
            String s = (String)commentLineIterator.nextElement();
            if (s.indexOf(64) == -1 && s.indexOf(58) == -1 && !needPlainCharData && (tag == null || !tag.continueType)) continue;
            if (needPlainCharData && s.contains("{@link")) {
                Matcher m = ourJSDocLinkPattern.matcher(s);
                StringBuffer b = new StringBuffer();
                int lastEnd = 0;
                while (m.find()) {
                    String text;
                    StringBuilder b2 = new StringBuilder();
                    String linkText = m.group(1);
                    String linkUrl = m.group(2).trim();
                    if (linkText != null && linkText.length() > 2) {
                        text = linkText.substring(1, linkText.length() - 1).trim();
                    } else {
                        int separatorIndex = StringUtil.indexOfAny((String)linkUrl, (String)" |");
                        if (separatorIndex >= 0) {
                            text = linkUrl.substring(separatorIndex + 1).trim();
                            linkUrl = linkUrl.substring(0, separatorIndex);
                        } else {
                            text = null;
                        }
                    }
                    if (BrowserUtil.isAbsoluteURL((String)linkUrl)) {
                        b2.append("<a href=\"").append(linkUrl).append("\">").append(text != null ? text : linkUrl).append("</a>");
                    } else {
                        JSDocumentationUtils.appendHyperLinkToElement(null, linkUrl, b2, StringUtil.isEmpty((String)text) ? linkUrl : text, null);
                    }
                    b.append(s.substring(lastEnd, m.start()));
                    lastEnd = m.end();
                    b.append((CharSequence)b2);
                }
                b.append(s.substring(lastEnd));
                s = b.toString();
            }
            String commentText = JSDocumentationUtils.prepareCommentLine(s);
            if (tag != null && tag.continueType && !commentText.contains("@")) {
                tag.matchName = tag.matchName + commentText;
                if (JSDocumentationUtils.getTypeStringLength(tag.matchName) <= tag.matchName.length()) {
                    tag = JSDocumentationUtils.handleCommentLine(multilineCommentTag + tag.matchName, lastParameterName, processor, patternToMetaDocTypeMap);
                }
            } else {
                tag = JSDocumentationUtils.handleCommentLine(commentText, lastParameterName, processor, eolComment ? inlinePatternToMetaDocTypeMap : patternToMetaDocTypeMap);
                if (tag != null && tag.continueType) {
                    multilineCommentTag = commentText.substring(0, commentText.length() - tag.matchName.length());
                }
            }
            if (tag != null) {
                if (tag.breakEnd) break;
                lastParameterName = tag.lastParameterName;
                continue;
            }
            if (!needPlainCharData || processor.onCommentLine(commentText)) continue;
            break;
        }
        processor.postProcess();
    }

    private static String prepareCommentLine(String s) {
        String commentText = s.replace('\t', ' ');
        for (Map.Entry<Pattern, String> entry : prefixToPatternToHintMap.entrySet()) {
            Matcher matcher = commentText.contains(entry.getValue()) ? entry.getKey().matcher(commentText) : null;
            if (matcher == null || !matcher.matches()) continue;
            commentText = matcher.group(1);
            break;
        }
        return commentText;
    }

    private static String trimBrackets(String type) {
        boolean outerBrackets = true;
        int length = type.length();
        int begin = 0;
        int end = length - 1;
        while (begin <= end) {
            if (Character.isSpaceChar(type.charAt(begin))) {
                ++begin;
                continue;
            }
            if (Character.isSpaceChar(type.charAt(end))) {
                --end;
                continue;
            }
            if (!outerBrackets || type.charAt(begin) != '{' || type.charAt(end) != '}') break;
            outerBrackets = false;
            ++begin;
            --end;
        }
        if (begin < length && type.charAt(begin) == '{') {
            int nextNonWs;
            for (nextNonWs = begin + 1; nextNonWs < length && Character.isSpaceChar(type.charAt(nextNonWs)); ++nextNonWs) {
            }
            int matchedClosingBracketPos = type.lastIndexOf(125, end - 1);
            if (nextNonWs < length && type.charAt(nextNonWs) == '{' && matchedClosingBracketPos > 0) {
                begin = nextNonWs;
                end = matchedClosingBracketPos;
            }
        }
        return type.substring(begin, end + 1);
    }

    private static int getTypeStringLength(@NotNull String tailText) {
        int i;
        if (tailText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tailText", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getTypeStringLength"));
        }
        boolean startsWithBrace = false;
        for (i = 0; i < tailText.length() && tailText.charAt(i) == ' '; ++i) {
        }
        if (i < tailText.length() && tailText.charAt(i) == '{') {
            ++i;
            startsWithBrace = true;
        }
        if (startsWithBrace && tailText.indexOf(123, i) == -1 && tailText.indexOf(125, i) >= 0) {
            return tailText.indexOf(125, i) + 1;
        }
        JSTypeParser parser = new JSTypeParser(tailText.substring(i), JSTypeSource.EMPTY);
        JSParameterTypeDecorator type = parser.parseParameterType(true);
        if (type != null) {
            if (startsWithBrace) {
                i += parser.getTypeStringLength();
                while (i < tailText.length() && tailText.charAt(i) == ' ') {
                    ++i;
                }
                return i < tailText.length() && tailText.charAt(i) == '}' ? i + 1 : tailText.length() + 1;
            }
            return i + parser.getTypeStringLength();
        }
        return startsWithBrace ? tailText.length() + 1 : 0;
    }

    private static String createParameterOrParameterFieldReference(String matchName, String fieldName) {
        if (fieldName == null) {
            return matchName;
        }
        if (!StringUtil.startsWithChar((CharSequence)fieldName, (char)'.') && !StringUtil.startsWithChar((CharSequence)fieldName, (char)'[')) {
            fieldName = "." + fieldName;
        }
        return matchName + fieldName;
    }

    public static String unwrapCommentDelimiters(String text) {
        String marker;
        block7: {
            block8: {
                block6: {
                    marker = "/**";
                    if (!text.startsWith("/**")) break block6;
                    text = text.substring(marker.length());
                    break block7;
                }
                marker = "/*";
                if (text.startsWith("/*")) break block8;
                marker = "//";
                if (!text.startsWith("//")) break block7;
            }
            text = text.substring(marker.length());
        }
        marker = "*/";
        if (text.endsWith("*/")) {
            text = text.substring(0, text.length() - marker.length());
        }
        marker = "-->";
        if (text.endsWith("-->")) {
            text = text.substring(0, text.length() - marker.length());
        }
        marker = "<!---";
        if (text.startsWith("<!---")) {
            text = text.substring(marker.length());
        }
        return text;
    }

    @Nullable
    static ASTNode findTrailingCommentInFunctionBody(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findTrailingCommentInFunctionBody"));
        }
        ASTNode block = function.getNode().findChildByType((IElementType)JSElementTypes.BLOCK_STATEMENT);
        if (block == null) {
            return null;
        }
        for (ASTNode prev = block.getLastChildNode(); prev != null; prev = prev.getTreePrev()) {
            if (prev.getElementType() == JSElementTypes.RETURN_STATEMENT) {
                PsiElement prevLeaf;
                ASTNode comment = block.findChildByType(JSTokenTypes.COMMENTS, prev);
                if (comment != null && (prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)comment.getPsi())) instanceof PsiWhiteSpace && prevLeaf.textContains('\n')) {
                    comment = null;
                }
                return comment;
            }
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(prev.getElementType())) break;
        }
        return null;
    }

    @Nullable
    static ASTNode findLeadingCommentInFunctionBody(@NotNull PsiElement element) {
        ASTNode node;
        ASTNode block;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findLeadingCommentInFunctionBody"));
        }
        ASTNode functionNode = element.getNode();
        ASTNode aSTNode = block = functionNode != null ? functionNode.findChildByType((IElementType)JSElementTypes.BLOCK_STATEMENT) : null;
        if (block == null) {
            return null;
        }
        ASTNode firstChildNode = block.getFirstChildNode();
        ASTNode aSTNode2 = node = firstChildNode != null ? firstChildNode.getTreeNext() : null;
        while (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType != TokenType.WHITE_SPACE) {
                if (JSTokenTypes.COMMENTS.contains(nodeType)) {
                    return node;
                }
                return null;
            }
            node = node.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static JSType findTypeFromInlineComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findTypeFromInlineComment"));
        }
        PsiElement prevSibling = element.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof JSDocComment) {
            String type = JSDocumentationUtils.findDocForAnchor(prevSibling, JSDocumentationProcessor.MetaDocType.TYPE);
            return JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource(prevSibling, true));
        }
        return null;
    }

    @Nullable
    public static JSDocComment findOwnDocComment(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findOwnDocComment"));
        }
        if (element instanceof JSExpression) {
            Object anchor = element instanceof JSDefinitionExpression ? element.getParent() : element;
            PsiElement prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace((PsiElement)anchor);
            if (prevSibling instanceof JSDocComment) {
                return (JSDocComment)prevSibling;
            }
        } else if (element instanceof JSVariable || element instanceof JSFunction || element instanceof JSClass || element instanceof JSNamespaceDeclaration || element instanceof JSExportAssignment || element instanceof JSProperty) {
            PsiElement parent;
            JSDocComment comment = JSDocumentationUtils.getStartingChildDocComment((PsiElement)element);
            if (comment != null) {
                return comment;
            }
            if (element instanceof JSVariable && (parent = element.getParent()) instanceof JSVarStatement && ((JSVarStatement)parent).getVariables().length == 1 && (comment = JSDocumentationUtils.getStartingChildDocComment((PsiElement)element)) != null) {
                return comment;
            }
        }
        return null;
    }

    public static PsiComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findDocComment"));
        }
        return JSDocumentationUtils.findDocComment(element, null, (Ref<PsiElement>)Ref.create(null));
    }

    static PsiComment findDocComment(@NotNull PsiElement element, @Nullable PsiElement context, @NotNull Ref<PsiElement> elementToAttach) {
        PsiElement associatedElement;
        JSDocComment _docComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findDocComment"));
        }
        if (elementToAttach == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToAttach", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findDocComment"));
        }
        ProgressManager.checkCanceled();
        if (element instanceof JSDocComment) {
            return (JSDocComment)element;
        }
        if (element instanceof JSAttributeListOwner && context == null) {
            JSAttributeListOwner jsClass = (JSAttributeListOwner)element;
            JSAttributeList attributeList = jsClass.getAttributeList();
            PsiElement anchor = null;
            if (attributeList != null) {
                for (ASTNode currentNode = attributeList.getNode().getLastChildNode(); currentNode != null; currentNode = currentNode.getTreePrev()) {
                    IElementType nodeType = currentNode.getElementType();
                    if (JSTokenTypes.MODIFIERS.contains(nodeType) || nodeType == JSStubElementTypes.ES6_DECORATOR || nodeType == JSTokenTypes.WHITE_SPACE || nodeType == JSElementTypes.REFERENCE_EXPRESSION || nodeType == JSStubElementTypes.ATTRIBUTE) continue;
                    ASTNode nextNode = currentNode.getTreeNext();
                    if (nextNode == null) break;
                    anchor = nextNode.getPsi();
                    break;
                }
            }
            if (anchor != null) {
                element = anchor;
            }
        }
        if (!element.isValid() || element.getContainingFile() == null) {
            return null;
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return null;
        }
        PsiComment docComment = null;
        PsiElement parentToSearchDocComment = null;
        if (element instanceof JSParameter) {
            JSFunction function;
            PsiElement prevSibling = element.getPrevSibling();
            while (prevSibling instanceof PsiWhiteSpace) {
                prevSibling = prevSibling.getPrevSibling();
            }
            if (prevSibling instanceof PsiComment) {
                docComment = (PsiComment)prevSibling;
            }
            if ((function = ((JSParameter)element).getDeclaringFunction()) != null) {
                element = function;
            }
        }
        if ((element instanceof JSFunctionExpression || element instanceof JSDefinitionExpression) && (element.getParent() instanceof JSAssignmentExpression || element.getParent() instanceof JSProperty || element.getParent() instanceof JSVariable || element.getParent() instanceof JSExportAssignment)) {
            element = element.getParent();
        }
        if (element instanceof JSVariable || element instanceof JSField) {
            _docComment = JSDocumentationUtils.getStartingChildDocComment(element);
            if (_docComment != null) {
                docComment = _docComment;
            } else {
                element = element.getParent();
            }
        }
        if (element instanceof JSFunction || element instanceof JSClass || element instanceof JSExpressionStatement || element instanceof JSNamespaceDeclaration || element instanceof JSVarStatement || element instanceof JSExportAssignment) {
            parentToSearchDocComment = element;
        } else if (element instanceof JSProperty) {
            JSProperty property = (JSProperty)element;
            Object object = parentToSearchDocComment = property.isGetProperty() || property.isSetProperty() ? property.getValue() : element;
        }
        if (parentToSearchDocComment != null && (_docComment = JSDocumentationUtils.getStartingChildDocComment(parentToSearchDocComment)) != null) {
            docComment = _docComment;
        }
        if (docComment == null) {
            PsiElement docCommentPrevSibling;
            boolean searchInPrevExprStatementWithSameName = false;
            String propName = JSDocumentationUtils.getPropertyNameFromExprStatement(element);
            if (propName != null) {
                searchInPrevExprStatementWithSameName = true;
            }
            PsiElement parent = element;
            PsiElement elementToProcess = element;
            while (docComment == null) {
                String propNameFromPrev;
                if (elementToProcess instanceof JSExpressionStatement && searchInPrevExprStatementWithSameName && propName.equals(propNameFromPrev = JSDocumentationUtils.getPropertyNameFromExprStatement(elementToProcess))) {
                    JSDocComment ownComment = JSDocumentationUtils.getStartingChildDocComment(elementToProcess);
                    Object object = elementToProcess = ownComment != null ? ownComment : elementToProcess.getPrevSibling();
                }
                if (elementToProcess instanceof PsiComment) {
                    docComment = (PsiComment)elementToProcess;
                } else if (elementToProcess instanceof PsiWhiteSpace || elementToProcess == parent) {
                    elementToProcess = elementToProcess.getPrevSibling();
                    continue;
                }
                if (!(parent instanceof JSExpression)) break;
                elementToProcess = parent = parent.getParent();
                if (!(parent instanceof PsiFile)) continue;
            }
            if (docComment != null && (docCommentPrevSibling = docComment.getPrevSibling()) != null && !JSPsiTreeUtil.isLineBreakWhiteSpace(docCommentPrevSibling) && docCommentPrevSibling.getPrevSibling() instanceof JSSourceElement) {
                docComment = null;
            }
        }
        if (docComment != null) {
            PsiElement siblingSibling;
            while (docComment.getPrevSibling() instanceof OuterLanguageElement && (siblingSibling = docComment.getPrevSibling().getPrevSibling()) != null && siblingSibling instanceof PsiComment) {
                docComment = (PsiComment)siblingSibling;
            }
        }
        PsiElement psiElement = associatedElement = parentToSearchDocComment != null ? parentToSearchDocComment : element;
        if (associatedElement instanceof JSFunction || associatedElement instanceof JSVarStatement || associatedElement instanceof JSProperty || associatedElement instanceof JSClass) {
            associatedElement = associatedElement.getFirstChild();
            while (associatedElement instanceof OuterLanguageElement) {
                associatedElement = associatedElement.getNextSibling();
            }
        }
        elementToAttach.set((Object)associatedElement);
        return docComment;
    }

    @Nullable
    private static JSDocComment getStartingChildDocComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getStartingChildDocComment"));
        }
        for (ASTNode child = element.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSStubElementTypes.DOC_COMMENT) {
                return (JSDocComment)child.getPsi();
            }
            if (!DOC_COMMENT_ALLOWED_AFTER.contains(type)) break;
        }
        return null;
    }

    public static void createOrUpdateTagsInDocComment(@NotNull PsiElement element, @Nullable List<String> tagsToCreate, @Nullable Map<Integer, String> tagsToUpdate, @Nullable Set<Integer> tagsToDelete) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "createOrUpdateTagsInDocComment"));
        }
        ArrayList<Pair> indexedTagsToCreate = null;
        if (tagsToCreate != null) {
            indexedTagsToCreate = new ArrayList<Pair>(tagsToCreate.size());
            for (String s : tagsToCreate) {
                indexedTagsToCreate.add(Pair.create((Object)Integer.MAX_VALUE, (Object)s));
            }
        }
        JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes(element, indexedTagsToCreate, tagsToUpdate, tagsToDelete);
    }

    public static void createOrUpdateTagsWithInsertionIndexes(@NotNull PsiElement element, @Nullable List<Pair<Integer, String>> tagsToCreate, @Nullable Map<Integer, String> tagsToUpdate, @Nullable Set<Integer> tagsToDelete) {
        PsiFile file;
        PsiDocumentManager psiDocumentManager;
        Document document;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "createOrUpdateTagsWithInsertionIndexes"));
        }
        if (tagsToCreate != null) {
            Collections.sort(tagsToCreate, (o1, o2) -> ((Integer)o1.first).compareTo((Integer)o2.first));
        }
        if ((document = (psiDocumentManager = PsiDocumentManager.getInstance((Project)(file = element.getContainingFile()).getProject())).getDocument(file)) == null) {
            return;
        }
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        Ref elementToAttach = Ref.create(null);
        PsiComment docComment = JSDocumentationUtils.findDocComment(element, null, (Ref<PsiElement>)elementToAttach);
        if (docComment == null || !(docComment instanceof JSDocComment)) {
            if (elementToAttach.isNull()) {
                return;
            }
            StringBuilder comment = new StringBuilder("/**\n");
            if (tagsToCreate != null) {
                for (Pair<Integer, String> tag : tagsToCreate) {
                    comment.append(" * @").append((String)tag.second).append("\n");
                }
            }
            comment.append(" */\n");
            int startOffset = ((PsiElement)elementToAttach.get()).getTextRange().getStartOffset();
            document.insertString(startOffset, (CharSequence)comment);
            CodeStyleManager.getInstance((Project)file.getProject()).reformatText(file, startOffset, startOffset + comment.length());
        } else {
            JSDocComment jsDocComment = (JSDocComment)docComment;
            String oldText = docComment.getText();
            StringBuilder comment = new StringBuilder(oldText);
            int modifiedCommentLengthDelta = 0;
            JSDocTag[] tags = jsDocComment.getTags();
            ListIterator<Pair<Integer, String>> tagsToCreateIterator = tagsToCreate != null ? tagsToCreate.listIterator() : null;
            for (int i = 0; i < tags.length; ++i) {
                int tagEnd;
                String newTagValue;
                JSDocTag tag = tags[i];
                while (tagsToCreateIterator != null && tagsToCreateIterator.hasNext()) {
                    Pair<Integer, String> next = tagsToCreateIterator.next();
                    if ((Integer)next.first == i) {
                        char c;
                        int offsetInParent = modifiedCommentLengthDelta + tag.getStartOffsetInParent();
                        StringBuilder spacesPrefix = new StringBuilder();
                        for (int j = tag.getStartOffsetInParent() - 1; j >= 0 && ((c = oldText.charAt(j)) == ' ' || c == '\t' || c == '*' && j > 0 && oldText.charAt(j - 1) != '*'); --j) {
                            spacesPrefix.insert(0, c);
                        }
                        String tagToInsert = "@" + (String)next.second + "\n" + spacesPrefix.toString();
                        comment.insert(offsetInParent, tagToInsert);
                        modifiedCommentLengthDelta += tagToInsert.length();
                        continue;
                    }
                    tagsToCreateIterator.previous();
                    break;
                }
                String string = newTagValue = tagsToUpdate != null ? tagsToUpdate.get(i) : null;
                if (newTagValue != null) {
                    JSDocTagValue oldTagValue = tag.getValue();
                    int offsetInParent = modifiedCommentLengthDelta + (oldTagValue != null ? oldTagValue.getStartOffsetInParent() + tag.getStartOffsetInParent() : tag.getStartOffsetInParent() + tag.getTextLength());
                    int oldLength = oldTagValue != null ? oldTagValue.getTextLength() : 0;
                    comment.replace(offsetInParent, offsetInParent + oldLength, newTagValue);
                    modifiedCommentLengthDelta += newTagValue.length() - oldLength;
                    continue;
                }
                if (tagsToDelete == null || !tagsToDelete.contains(i)) continue;
                int tagStart = oldText.lastIndexOf(10, tag.getStartOffsetInParent());
                if (tagStart == -1) {
                    tagStart = tag.getStartOffsetInParent();
                }
                if ((tagEnd = oldText.indexOf(10, tag.getStartOffsetInParent())) == -1) {
                    tagEnd = tag.getStartOffsetInParent() + tag.getTextLength();
                }
                comment.delete(tagStart + modifiedCommentLengthDelta, tagEnd + modifiedCommentLengthDelta);
                modifiedCommentLengthDelta -= tagEnd - tagStart;
            }
            int newTagOffset = -1;
            if (tagsToCreateIterator != null && tagsToCreateIterator.hasNext()) {
                String newComment = comment.toString();
                int lastIndexOfNewline = newComment.lastIndexOf(10);
                if (lastIndexOfNewline != -1) {
                    newTagOffset = lastIndexOfNewline + 1;
                } else {
                    comment.insert(comment.length() - 2, '\n');
                    newTagOffset = comment.length() - 2;
                }
                while (tagsToCreateIterator.hasNext()) {
                    String tag = (String)tagsToCreateIterator.next().second;
                    comment.insert(newTagOffset, "\n").insert(newTagOffset, tag).insert(newTagOffset, " * @");
                    newTagOffset += tag.length() + 1 + 4;
                }
            }
            int startOffset = docComment.getTextRange().getStartOffset();
            String newComment = comment.toString();
            if (newComment.replaceAll("[\\s*/]", "").isEmpty()) {
                newComment = "";
            }
            document.replaceString(startOffset, docComment.getTextRange().getEndOffset(), (CharSequence)newComment);
            if (newTagOffset != -1) {
                CodeStyleManager.getInstance((Project)file.getProject()).reformatText(file, startOffset, startOffset + newComment.length());
            }
        }
    }

    @Nullable
    private static String getPropertyNameFromExprStatement(@NotNull PsiElement element) {
        JSExpression rOperand;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getPropertyNameFromExprStatement"));
        }
        String propName = null;
        if (element instanceof JSExpressionStatement) {
            element = ((JSExpressionStatement)element).getExpression();
        }
        if (element instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)element).getROperand()) instanceof JSFunctionExpression) {
            String name = rOperand.getName();
            propName = JSDocumentationUtils.getPropertyName(name);
        }
        return propName;
    }

    @Nullable
    public static String getPropertyName(String name) {
        if (name != null && name.length() > 3 && (StringUtil.startsWith((CharSequence)name, (CharSequence)"get") || StringUtil.startsWith((CharSequence)name, (CharSequence)"set"))) {
            return name.substring(3);
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromPreceedingComment(JSVariable variable) {
        if (variable instanceof JSParameter) {
            JSParameterTypeDecorator paramType = JSDocumentationUtils.getParameterTypeFromPrecedingComment((JSParameter)variable);
            return paramType != null ? paramType.getType() : null;
        }
        PsiElement prevSibling = JSDocumentationUtils.getReasonablePrevElement(variable);
        if (prevSibling instanceof PsiComment) {
            return JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)prevSibling, false, false, false);
        }
        return null;
    }

    public static JSParameterTypeDecorator getParameterTypeFromPrecedingComment(JSParameter parameter) {
        PsiElement prevSibling = JSDocumentationUtils.getReasonablePrevElement((JSVariable)parameter);
        if (prevSibling instanceof PsiComment && prevSibling.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT && JSDocumentationUtils.isTypeStringAcceptable(JSDocumentationUtils.unwrapCommentDelimiters(prevSibling.getText()), true)) {
            return JSTypeUtils.createParameterType(JSDocumentationUtils.unwrapCommentDelimiters(prevSibling.getText()), JSTypeSourceFactory.createTypeSource(prevSibling, true), true);
        }
        return null;
    }

    private static PsiElement getReasonablePrevElement(JSVariable variable) {
        PsiElement prevSibling = variable.getFirstChild();
        if (prevSibling != null && JSVariableBaseImpl.IDENTIFIER_TOKENS_SET.contains(prevSibling.getNode().getElementType())) {
            prevSibling = variable.getPrevSibling();
        }
        if (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Nullable
    private static JSType rawGetTypeForVariable(JSVariable variable) {
        String typeString;
        JSType typeFromPreceedingComment = JSDocumentationUtils.getTypeFromPreceedingComment(variable);
        if (typeFromPreceedingComment != null) {
            return typeFromPreceedingComment;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)variable);
        if (docComment instanceof JSDocComment && (typeString = JSDocumentationUtils.getTypeFromComment((JSDocComment)docComment)) != null) {
            return JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true));
        }
        return null;
    }

    @Nullable
    public static PsiComment findDocCommentWider(@Nullable PsiElement _anchor) {
        PsiElement anchor = _anchor;
        PsiComment docComment = null;
        if (_anchor instanceof JSExpression && (docComment = JSDocumentationUtils.findDocComment(_anchor)) == null) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)_anchor, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        if (anchor != null && docComment == null) {
            docComment = JSDocumentationUtils.findDocComment(anchor);
        }
        return docComment;
    }

    @Nullable
    public static String findDocForAnchor(PsiElement _anchor, final JSDocumentationProcessor.MetaDocType ... expectedTypes) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(_anchor);
        if (docComment != null) {
            final Ref detectedType = new Ref();
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$2", "onCommentLine"));
                    }
                    return true;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$2", "onPatternMatch"));
                    }
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$2", "onPatternMatch"));
                    }
                    if (patternMatched == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$2", "onPatternMatch"));
                    }
                    for (JSDocumentationProcessor.MetaDocType expectedType : expectedTypes) {
                        if (type != expectedType) continue;
                        detectedType.set((Object)matchName);
                        return false;
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }
            });
            return (String)detectedType.get();
        }
        return null;
    }

    @Nullable
    public static String findType(@Nullable PsiElement def) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(def);
        if (docComment instanceof JSDocComment) {
            return ((JSDocComment)docComment).getType();
        }
        return null;
    }

    @Nullable
    public static String getTypeFromComment(@NotNull JSDocComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getTypeFromComment"));
        }
        return comment.getType();
    }

    @Nullable
    public static JSType findContextType(@Nullable PsiElement anchor) {
        JSType thisType;
        JSType type;
        String fromType;
        if (anchor == null) {
            return null;
        }
        PsiComment element = JSDocumentationUtils.findDocCommentWider(anchor);
        if (element instanceof JSDocComment) {
            JSQualifiedName contextType;
            String fromTag = ((JSDocComment)element).getThisType();
            if (fromTag != null) {
                return JSTypeUtils.createType(fromTag, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
            }
            JSDocComment docComment = (JSDocComment)element;
            JSQualifiedName namespace = docComment.getNamespace();
            String name = docComment.getExplicitName();
            JSQualifiedName jSQualifiedName = docComment.getJSContext() == JSContext.INSTANCE ? namespace : (contextType = name != null ? JSQualifiedNameImpl.create(name, namespace) : null);
            if (contextType != null) {
                return JSNamedType.createType(contextType.getQualifiedName(), JSTypeSourceFactory.createTypeSource((PsiElement)element), JSContext.INSTANCE);
            }
        }
        if ((fromType = JSDocumentationUtils.findType(anchor)) != null && (type = JSTypeUtils.createType(fromType, JSTypeSource.EMPTY)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)type).getThisType()) != null) {
            return thisType;
        }
        return null;
    }

    public static String findReturnType(@Nullable PsiElement anchor) {
        return JSDocumentationUtils.findDocForAnchor(anchor, JSDocumentationProcessor.MetaDocType.RETURN);
    }

    public static String findEnumType(PsiElement anchor) {
        String matchName = JSDocumentationUtils.findDocForAnchor(anchor, JSDocumentationProcessor.MetaDocType.ENUM);
        return matchName == null ? null : (matchName.isEmpty() ? "number" : matchName);
    }

    @Contract(value="null, _ -> false")
    public static boolean hasJSDocTag(@Nullable PsiElement anchor, JSDocumentationProcessor.MetaDocType ... docTypesArray) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(anchor);
        if (docTypesArray.length == 0) {
            return false;
        }
        final EnumSet<JSDocumentationProcessor.MetaDocType[]> docTypes = EnumSet.of(docTypesArray[0], docTypesArray);
        if (docComment != null) {
            final Ref hasNeededTag = Ref.create((Object)Boolean.FALSE);
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$3", "onCommentLine"));
                    }
                    return true;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$3", "onPatternMatch"));
                    }
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$3", "onPatternMatch"));
                    }
                    if (patternMatched == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$3", "onPatternMatch"));
                    }
                    if (docTypes.contains((Object)type)) {
                        hasNeededTag.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }
            });
            return (Boolean)hasNeededTag.get();
        }
        return false;
    }

    @NotNull
    public static List<Pair<String, String>> findParameters(PsiElement anchor) {
        PsiComment docComment = JSDocumentationUtils.findDocComment(anchor);
        if (docComment != null) {
            final ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$4", "onCommentLine"));
                    }
                    return true;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$4", "onPatternMatch"));
                    }
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$4", "onPatternMatch"));
                    }
                    if (patternMatched == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$4", "onPatternMatch"));
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                        parameters.add(Pair.create((Object)matchName, (Object)matchValue));
                    } else if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS) {
                        for (int i = 0; i < parameters.size(); ++i) {
                            Pair parameter = (Pair)parameters.get(i);
                            if (parameter == null || matchName == null || !matchName.equals(parameter.first)) continue;
                            parameters.set(i, Pair.create((Object)parameter.first, (Object)((String)parameter.second + "=")));
                        }
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }
            });
            ArrayList<Pair<String, String>> arrayList = parameters;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findParameters"));
            }
            return arrayList;
        }
        List<Pair<String, String>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findParameters"));
        }
        return list;
    }

    public static boolean isDeprecated(PsiElement element) {
        if (element instanceof JSPsiElementBase) {
            return ((JSPsiElementBase)element).isDeprecated();
        }
        if (element instanceof TypeScriptPropertySignature) {
            return ((TypeScriptPropertySignature)element).isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated(element);
    }

    public static boolean calculateDeprecated(PsiElement element) {
        return (Boolean)JSDocumentationUtils.calculateConstAndDeprecated((PsiElement)element).second;
    }

    public static boolean calculateConst(PsiElement element) {
        return (Boolean)JSDocumentationUtils.calculateConstAndDeprecated((PsiElement)element).first;
    }

    @NotNull
    private static Couple<Boolean> calculateConstAndDeprecated(PsiElement element) {
        PsiComment docComment;
        if (element instanceof JSParameter) {
            Couple couple = Couple.of((Object)Boolean.FALSE, (Object)Boolean.FALSE);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "calculateConstAndDeprecated"));
            }
            return couple;
        }
        if (element instanceof JSExpression) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        PsiComment psiComment = docComment = element != null ? JSDocumentationUtils.findDocComment(element) : null;
        if (docComment != null) {
            final Ref myIsConst = Ref.create((Object)Boolean.FALSE);
            final Ref myIsDeprecated = Ref.create((Object)Boolean.FALSE);
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$5", "onCommentLine"));
                    }
                    return true;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$5", "onPatternMatch"));
                    }
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$5", "onPatternMatch"));
                    }
                    if (patternMatched == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$5", "onPatternMatch"));
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
                        myIsDeprecated.set((Object)Boolean.TRUE);
                    } else if (type == JSDocumentationProcessor.MetaDocType.FINAL) {
                        myIsConst.set((Object)Boolean.TRUE);
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }
            });
            Couple couple = Couple.of((Object)myIsConst.get(), (Object)myIsDeprecated.get());
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "calculateConstAndDeprecated"));
            }
            return couple;
        }
        Couple couple = Couple.of((Object)Boolean.FALSE, (Object)Boolean.FALSE);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "calculateConstAndDeprecated"));
        }
        return couple;
    }

    public static void appendHyperLinkToElement(@Nullable PsiElement element, String elementName, StringBuilder buffer, String presentableName, @Nullable String presentableFileName) {
        boolean isJsElement;
        String fileName;
        PsiFile containingFile;
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : null;
        String string = containingFile == null ? null : (fileName = !JSResolveUtil.isFromPredefinedFile(containingFile) ? containingFile.getVirtualFile().getPresentableUrl() : containingFile.getViewProvider().getVirtualFile().getName());
        if (presentableFileName != null && presentableFileName.startsWith("(") && presentableFileName.endsWith(")")) {
            presentableFileName = presentableFileName.substring(1, presentableFileName.length() - 1);
        }
        JSQualifiedName namespace = (isJsElement = element instanceof JSElementBase) ? ((JSElementBase)element).getNamespace() : null;
        String linkText = (fileName != null ? fileName + HYPERLINK_SEPARATOR : "") + elementName + (namespace != null ? HYPERLINK_SEPARATOR + namespace.getQualifiedName() : (isJsElement ? "%null" : ""));
        DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (String)linkText, (String)(presentableName + (StringUtil.isEmpty((String)presentableFileName) ? "" : " in " + presentableFileName)), (boolean)true);
    }

    @Nullable
    public static PsiComment findFunctionComment(JSFunction _anchor) {
        PsiComment docComment;
        JSFunction anchor = _anchor;
        if (anchor instanceof JSFunctionExpression) {
            docComment = JSDocumentationUtils.findDocComment((PsiElement)anchor);
            if (docComment instanceof JSDocComment && JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) == _anchor) {
                return docComment;
            }
            PsiElement parent = anchor.getParent();
            PsiElement grandparent = parent.getParent();
            anchor = parent instanceof JSVariable && grandparent.getNode().findChildByType(JSElementTypes.BODY_VARIABLES) != parent.getNode() ? parent : PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        if (anchor != null && (docComment = JSDocumentationUtils.findDocComment((PsiElement)anchor)) instanceof JSDocComment && JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) == _anchor) {
            return docComment;
        }
        return null;
    }

    @Nullable
    public static JSFunction findFunctionAppliedTo(@NotNull JSDocComment comment) {
        JSExpression expression;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findFunctionAppliedTo"));
        }
        PsiElement parent = comment.getParent();
        if (parent instanceof JSFunction) {
            return (JSFunction)parent;
        }
        if (parent instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)parent).getInitializer();
            if (initializer instanceof JSFunction) {
                return (JSFunction)initializer;
            }
        } else if (parent instanceof JSVarStatement) {
            JSExpression initializer;
            JSVariable var = (JSVariable)PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, JSVariable.class);
            if (var != null && (initializer = var.getInitializer()) instanceof JSFunction) {
                return (JSFunction)initializer;
            }
        } else if (parent instanceof JSExpressionStatement) {
            JSExpression expression2 = ((JSExpressionStatement)parent).getExpression();
            if (expression2 instanceof JSAssignmentExpression) {
                JSExpression methodExpression;
                JSExpression rOperand = JSUtils.unparenthesize(((JSAssignmentExpression)expression2).getROperand());
                if (rOperand instanceof JSFunction) {
                    return (JSFunction)rOperand;
                }
                if (rOperand instanceof JSCallExpression && (methodExpression = JSUtils.unparenthesize(((JSCallExpression)rOperand).getMethodExpression())) instanceof JSFunctionExpression) {
                    return (JSFunctionExpression)methodExpression;
                }
            }
        } else if (parent instanceof JSProperty) {
            JSExpression value = ((JSProperty)parent).getValue();
            if (value instanceof JSFunction) {
                return (JSFunction)value;
            }
        } else if (parent instanceof ES6ExportDefaultAssignment && (expression = ((ES6ExportDefaultAssignment)parent).getExpression()) instanceof JSFunctionExpression) {
            return (JSFunctionExpression)expression;
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromTrailingComment(JSFunction function) {
        ASTNode lastCommentInFunctionBody = JSDocumentationUtils.findTrailingCommentInFunctionBody(function);
        if (lastCommentInFunctionBody != null) {
            JSType type = JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)lastCommentInFunctionBody.getPsi(), false, true, false);
            if (!(type instanceof JSSpecialNamedTypeImpl)) {
                type = JSTypeUtils.copyWithExplicitlyDeclared(type, false);
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromReturnTypeComment(JSFunction function) {
        JSParameterList list = function.getParameterList();
        JSType type = null;
        if (list != null) {
            PsiElement reasonableNextElement = list.getNextSibling();
            if (reasonableNextElement instanceof PsiWhiteSpace) {
                reasonableNextElement = reasonableNextElement.getNextSibling();
            }
            if (reasonableNextElement instanceof JSDocComment) {
                type = JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)((JSDocComment)reasonableNextElement), false, true, false);
            }
        }
        return type;
    }

    public static JSType tryCreateTypeFromComment(@NotNull PsiComment comment, boolean spaceAllowed, boolean allowEOLComment, boolean allowCommentAfterType) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "tryCreateTypeFromComment"));
        }
        if (!allowEOLComment && comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            return null;
        }
        String body = JSDocumentationUtils.unwrapCommentDelimiters(comment.getText());
        if (allowEOLComment) {
            body = body.trim();
        }
        if (!JSDocumentationUtils.isTypeStringAcceptable(body, spaceAllowed)) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)comment, true);
        return JSTypeUtils.createType(body, typeSource, allowCommentAfterType);
    }

    private static boolean isTypeStringAcceptable(String typeString, boolean spaceAllowed) {
        if (typeString.indexOf(10) != -1) {
            return false;
        }
        if (!spaceAllowed && typeString.indexOf(32) != -1) {
            return false;
        }
        return !(typeString = typeString.trim()).equals("TODO") && !typeString.equals("INTERNAL") && typeString.length() != 0 && !typeString.endsWith(",") && !typeString.startsWith(",");
    }

    @Nullable
    public static JSType findTypeFromComments(JSNamedElement element) {
        if (element instanceof JSVariable) {
            return JSDocumentationUtils.rawGetTypeForVariable((JSVariable)element);
        }
        if (element instanceof JSFunction) {
            JSType type = JSDocumentationUtils.getTypeFromTrailingComment((JSFunction)element);
            if (type != null) {
                return type;
            }
            String comment = JSDocumentationUtils.findDocForAnchor((PsiElement)element, JSDocumentationProcessor.MetaDocType.RETURN, JSDocumentationProcessor.MetaDocType.TYPE);
            return JSTypeUtils.createType(comment, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
        }
        return null;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static String doCapitalizeCommentTypeIfNeeded(String comment) {
        if (!StringUtil.isEmpty((String)comment)) {
            if (comment.equals("number") || comment.equals("string") || comment.equals("function") || comment.equals("boolean") || comment.equals("object")) {
                comment = StringUtil.capitalize((String)comment);
            } else if ("Integer".equals(comment)) {
                comment = "int";
            }
        }
        return comment;
    }

    @Nullable
    public static String stripTypeDecorations(@Nullable String textFragment) {
        int commaIndex;
        int i;
        if (textFragment == null) {
            return null;
        }
        if ((textFragment = textFragment.trim()).startsWith("...")) {
            textFragment = textFragment.substring(3);
        }
        if (textFragment.startsWith("!")) {
            textFragment = textFragment.substring(1);
        }
        if ((i = textFragment.indexOf(63)) != -1) {
            textFragment = i == 0 ? textFragment.substring(1) : textFragment.substring(0, i);
        }
        if (i < 1 && (i = textFragment.indexOf(61)) != -1) {
            textFragment = textFragment.substring(0, i);
        }
        if ((textFragment = StringUtil.trimEnd((String)textFragment, (String)".")).startsWith("(") && textFragment.endsWith(")")) {
            textFragment = textFragment.substring(1, textFragment.length() - 1);
        }
        if ((commaIndex = textFragment.indexOf(44)) != -1 && textFragment.indexOf(123) == -1) {
            textFragment = textFragment.substring(0, commaIndex).trim();
        }
        return textFragment;
    }

    @NotNull
    public static String getLibDocRelativeUrl(@NotNull String baseUrl, @NotNull String elementFQN) {
        String[] rules;
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getLibDocRelativeUrl"));
        }
        if (elementFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFQN", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getLibDocRelativeUrl"));
        }
        String baseKey = JSExternalLibraryDocBundle.getBaseURLKey(baseUrl);
        if (baseKey == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getLibDocRelativeUrl"));
            }
            return "";
        }
        String directUrl = JSExternalLibraryDocBundle.getElementUrl(baseKey, elementFQN);
        if (directUrl != null) {
            String string = directUrl;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getLibDocRelativeUrl"));
            }
            return string;
        }
        String prefix = JSExternalLibraryDocBundle.getPrefix(baseKey);
        String relativeUrl = elementFQN;
        String rulesStr = JSExternalLibraryDocBundle.getRules(baseKey);
        for (String rule : rules = rulesStr.split(";")) {
            String replacement;
            if (rule.trim().length() <= 0) continue;
            String[] args = rule.split(",");
            String opType = args[0].trim();
            String sample = args.length > 1 ? args[1].trim() : "";
            String string = replacement = args.length > 2 ? args[2].trim() : "";
            if (opType.startsWith("S")) {
                relativeUrl = relativeUrl.replace(sample, replacement);
                continue;
            }
            if (opType.startsWith("R")) {
                relativeUrl = relativeUrl.replaceAll(sample, replacement);
                continue;
            }
            if (opType.startsWith("L")) {
                relativeUrl = relativeUrl.toLowerCase();
                continue;
            }
            assert (false) : "Don't know how to handle " + opType + " in rule " + rule + " must be R or S";
        }
        if (JSExternalLibraryDocBundle.isLowerCase(baseKey)) {
            relativeUrl = relativeUrl.toLowerCase();
        }
        String string = prefix + relativeUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getLibDocRelativeUrl"));
        }
        return string;
    }

    @Nullable
    public static String getBaseKey(@NotNull String libUrl) {
        if (libUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libUrl", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getBaseKey"));
        }
        for (String baseKey : JSExternalLibraryDocBundle.getBasePatternKeys()) {
            String patterns = JSExternalLibraryDocBundle.getPatterns(baseKey);
            if (patterns == null) continue;
            for (String pattern : patterns.split(";")) {
                String tp = pattern.trim();
                if (tp.length() <= 0 || !libUrl.matches(tp)) continue;
                return baseKey;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull PsiComment psiComment) {
        JSVariable[] variables;
        if (psiComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiComment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findAssociatedElement"));
        }
        PsiElement parent = psiComment.getParent();
        PsiElement next = null;
        if (parent instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)parent).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression lOperand = ((JSAssignmentExpression)expression).getLOperand();
                if (lOperand instanceof JSDefinitionExpression || lOperand instanceof JSReferenceExpression) {
                    next = lOperand;
                }
            } else if (expression instanceof JSReferenceExpression) {
                next = expression;
            }
        } else if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable) {
            next = parent;
        } else if (parent instanceof JSVarStatement && (variables = ((JSVarStatement)parent).getVariables()).length > 0) {
            next = variables[0];
        }
        return next;
    }

    @Nullable
    public static PsiElement findAttachedElementFromComment(PsiComment psiComment) {
        PsiElement next;
        PsiElement strictElement = JSDocumentationUtils.findAssociatedElement(psiComment);
        if (strictElement != null) {
            return strictElement;
        }
        for (next = psiComment.getNextSibling(); next instanceof PsiWhiteSpace || next instanceof PsiComment || next != null && !(next instanceof JSElement); next = next.getNextSibling()) {
        }
        PsiComment associatedComment = JSDocumentationUtils.findDocCommentWider(next);
        if (associatedComment != null && associatedComment != psiComment) {
            return null;
        }
        return next;
    }

    @Nullable
    public static String findNameOfClassAppliedTo(PsiComment comment) {
        String documentedClassName = JSDocumentationUtils.findDocForAnchor((PsiElement)comment, JSDocumentationProcessor.MetaDocType.CLASS, JSDocumentationProcessor.MetaDocType.NAME, JSDocumentationProcessor.MetaDocType.ALIAS);
        PsiElement namedElement = JSDocumentationUtils.findAttachedElementFromComment(comment);
        String codeName = JSDocumentationUtils.getQualifiedNameFromPsi(namedElement);
        return documentedClassName == null || codeName != null && codeName.endsWith(documentedClassName) ? codeName : documentedClassName;
    }

    @Nullable
    public static String getQualifiedNameFromPsi(@Nullable PsiElement namedElement) {
        JSQualifiedName name;
        if (namedElement instanceof JSDefinitionExpression) {
            namedElement = ((JSDefinitionExpression)namedElement).getExpression();
        }
        if (namedElement instanceof JSNamedElement && !(namedElement instanceof JSProperty)) {
            return ((JSNamedElement)namedElement).getName();
        }
        if (namedElement instanceof JSReferenceExpression && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)namedElement)) != null) {
            return name.getQualifiedName();
        }
        return null;
    }

    @NotNull
    public static JSElementBase.ClassOrInterface isClassOrInterface(JSQualifiedNamedElement element) {
        if (element instanceof JSParameter) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "isClassOrInterface"));
            }
            return classOrInterface;
        }
        JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        JSElementBase.ClassOrInterface classOrInterface = comment != null && comment.hasInterfaceTag() ? JSElementBase.ClassOrInterface.INTERFACE : (comment != null && comment.isClassExplicitly() ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    public static String appendPrefixToName(@NotNull String name, @NotNull String prefix) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "appendPrefixToName"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "appendPrefixToName"));
        }
        int i = StringUtil.lastIndexOfAny((CharSequence)name, (String)".#~");
        if (!name.startsWith(prefix, i + 1)) {
            name = new StringBuilder(name).insert(i + 1, prefix).toString();
        }
        return name;
    }

    public static boolean mayRelateTo(@NotNull JSDocComment docComment, @NotNull PsiElement element) {
        Collection typedefs;
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "mayRelateTo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "mayRelateTo"));
        }
        JSElementIndexingData indexingData = docComment.getIndexingData();
        if (indexingData != null && element instanceof JSPsiNamedElementBase && (typedefs = indexingData.getTypedefs()) != null && typedefs.size() == 1) {
            Pair pair = (Pair)ContainerUtil.getFirstItem((Collection)typedefs);
            assert (pair != null) : "typedef element must not be null";
            if (pair.first != null && !((String)pair.first).equals(((JSPsiNamedElementBase)element).getName())) {
                return false;
            }
        }
        return true;
    }

    public static void moveJSDoc(@Nullable PsiComment docComment, @NotNull PsiElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "moveJSDoc"));
        }
        if (docComment != null) {
            JSDocumentationUtils.copyJSDocComment(docComment, newElement);
            docComment.getParent().deleteChildRange((PsiElement)docComment, (PsiElement)docComment);
        }
    }

    public static void copyJSDocComment(@Nullable PsiComment docComment, @NotNull PsiElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "copyJSDocComment"));
        }
        if (newElement.getChildren().length > 0) {
            PsiElement child = newElement.getFirstChild();
            newElement.addBefore(docComment.copy(), child);
            JSChangeUtil.addWs(newElement.getNode(), child.getNode(), "\n");
        } else {
            newElement.add(docComment.copy());
        }
    }

    @Nullable
    public static DocTag getDocTag(String commentText) {
        List lines = StringUtil.split((String)commentText, (String)"\n");
        DocTag tag = null;
        String multilineCommentTag = "";
        for (String line : lines) {
            String commentLine = JSDocumentationUtils.prepareCommentLine(line);
            if (tag != null && tag.continueType && !commentLine.contains("@")) {
                tag.matchName = tag.matchName + commentLine;
                if (JSDocumentationUtils.getTypeStringLength(tag.matchName) > tag.matchName.length()) continue;
                tag = JSDocumentationUtils.handleCommentLine(multilineCommentTag + tag.matchName, null, null, patternToMetaDocTypeMap);
                continue;
            }
            tag = JSDocumentationUtils.handleCommentLine(line, null, null, patternToMetaDocTypeMap);
            if (tag == null || !tag.continueType) continue;
            multilineCommentTag = commentLine.substring(0, commentLine.length() - tag.matchName.length());
        }
        return tag;
    }

    @Nullable
    private static DocTag handleCommentLine(String commentText, @Nullable String lastParameterName, @Nullable JSDocumentationProcessor processor, @NotNull Map<Pattern, JSDocumentationProcessor.MetaDocType> patternToMetaDocTypeMap) {
        if (patternToMetaDocTypeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternToMetaDocTypeMap", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "handleCommentLine"));
        }
        for (Map.Entry<Pattern, String> entry : patternToHintMap.entrySet()) {
            JSDocumentationProcessor.MetaDocType docType;
            Pattern pattern = entry.getKey();
            Matcher matcher = commentText.contains(entry.getValue()) ? pattern.matcher(commentText) : null;
            if (matcher == null || !matcher.matches() || (docType = patternToMetaDocTypeMap.get(pattern)) == null) continue;
            DocTag docTag = new DocTag();
            docTag.type = docType;
            docTag.breakEnd = false;
            int groupCount = matcher.groupCount();
            String remainingLineContent = groupCount > 0 ? matcher.group(groupCount) : null;
            String matchName = groupCount > 1 ? matcher.group(1) : null;
            String matchValue = groupCount > 2 ? matcher.group(2) : null;
            boolean reportAboutOptionalParameter = false;
            boolean reportAboutFieldInParameter = false;
            boolean reportAboutDefaultValue = false;
            int groupForInitialValue = -1;
            String fieldName = null;
            if (pattern == ourJSDocTypePattern || pattern == ourJSDocEnumPattern || pattern == ourJSDocTypedefPattern || pattern == ourJSDocExtendsPattern || pattern == ourJSDocAugmentsPattern || pattern == ourJSDocImplementsPattern || pattern == ourJSDocReturnPattern || pattern == ourJSDocThisPattern || pattern == ourJSDocLendsPattern || pattern == ourJSDocMixinPattern || pattern == ourJSDocMixesPattern || pattern == ourJSDocThrowsPattern && remainingLineContent != null && remainingLineContent.startsWith("{") || pattern == ourJSDocMemberPattern || pattern == ourJSDocVarPattern || pattern == ourJSDocPrivatePattern || pattern == ourJSDocProtectedPattern || pattern == ourJSDocPublicPattern) {
                matchValue = null;
                if (remainingLineContent == null) {
                    matchName = null;
                } else {
                    int typeLength = JSDocumentationUtils.getTypeStringLength(remainingLineContent);
                    if (typeLength > remainingLineContent.length()) {
                        docTag.continueType = true;
                        docTag.matchName = JSDocumentationUtils.trimBrackets(remainingLineContent.substring(0, remainingLineContent.length()));
                        return docTag;
                    }
                    matchName = JSDocumentationUtils.trimBrackets(remainingLineContent.substring(0, typeLength));
                    remainingLineContent = remainingLineContent.substring(typeLength, remainingLineContent.length()).trim();
                }
            }
            if (pattern == ourJSDocParametersPattern) {
                String text = matcher.group(1);
                Matcher tailMatcher = ourYuiDocParametersPattern.matcher(text);
                if (tailMatcher.matches()) {
                    String typeWithTailText = tailMatcher.group(2);
                    int typeLength = JSDocumentationUtils.getTypeStringLength(typeWithTailText);
                    if (typeLength > typeWithTailText.length()) {
                        docTag.continueType = true;
                        docTag.matchName = typeWithTailText;
                        return docTag;
                    }
                    matchName = tailMatcher.group(1);
                    matchValue = JSDocumentationUtils.trimBrackets(typeWithTailText.substring(0, typeLength));
                    remainingLineContent = typeWithTailText.substring(typeLength);
                } else {
                    boolean hasType = text.trim().startsWith("{");
                    int typeLength = 0;
                    if (hasType) {
                        typeLength = JSDocumentationUtils.getTypeStringLength(text);
                        if (typeLength > text.length()) {
                            docTag.continueType = true;
                            docTag.matchName = text;
                            return docTag;
                        }
                        matchValue = JSDocumentationUtils.trimBrackets(text.substring(0, typeLength));
                    } else {
                        matchValue = null;
                    }
                    matcher = ourJSDocParametersRestPattern.matcher(text.substring(typeLength));
                    if (matcher.matches()) {
                        matchName = matcher.group(2);
                        remainingLineContent = matcher.group(7);
                        String typeAfterParamName = matcher.group(6);
                        if (typeAfterParamName != null) {
                            matchValue = typeAfterParamName;
                        } else {
                            fieldName = matcher.group(3);
                            reportAboutFieldInParameter = fieldName != null;
                            groupForInitialValue = 5;
                            reportAboutDefaultValue = matcher.group(5) != null;
                            String matchTypeDecorated = matcher.group(1);
                            boolean bl = reportAboutOptionalParameter = matchTypeDecorated != null && (matchTypeDecorated.startsWith("[") || matchTypeDecorated.startsWith("("));
                        }
                        if (matcher.group(4) != null) {
                            if (matchValue == null) {
                                matchValue = "*";
                            }
                            matchValue = "..." + matchValue;
                        }
                    }
                }
                lastParameterName = matchName;
            } else if (pattern == ourJSDocPropertyPattern || pattern == ourJSDocConfigPattern) {
                if (matcher.start(1) != -1) {
                    String typeWithTailText = commentText.substring(matcher.start(1));
                    int typeLength = JSDocumentationUtils.getTypeStringLength(typeWithTailText);
                    if (typeLength > typeWithTailText.length()) {
                        docTag.continueType = true;
                        docTag.matchName = typeWithTailText;
                        return docTag;
                    }
                    matchValue = JSDocumentationUtils.trimBrackets(typeWithTailText.substring(0, typeLength));
                    remainingLineContent = typeWithTailText.substring(typeLength);
                } else {
                    matchValue = null;
                    remainingLineContent = matcher.group(2);
                }
                matcher = ourJSDocPropertyRestPattern.matcher(remainingLineContent);
                if (matcher.matches()) {
                    reportAboutOptionalParameter = !StringUtil.isEmpty((String)matcher.group(1));
                    matchName = matcher.group(2);
                    remainingLineContent = StringUtil.trim((String)matcher.group(4));
                    if (pattern == ourJSDocConfigPattern) {
                        fieldName = matchName;
                        if (fieldName != null) {
                            reportAboutOptionalParameter = true;
                            reportAboutFieldInParameter = true;
                            groupForInitialValue = 3;
                            reportAboutDefaultValue = matcher.group(3) != null;
                        }
                        matchName = lastParameterName;
                    }
                }
            } else if (pattern == ourJSDocCfgPattern && matchValue != null) {
                String tmp = matchValue;
                matchValue = matchName;
                matchName = tmp;
            } else if (pattern == ourJSDocTypedefPattern || pattern == ourJSDocMemberPattern || pattern == ourJSDocVarPattern || pattern == ourJSDocConstantPattern) {
                if (StringUtil.isNotEmpty((String)remainingLineContent) && (matcher = ourJSDocNameTailPattern.matcher(remainingLineContent)).matches() && matcher.group(1) != null) {
                    matchValue = matcher.group(1);
                    remainingLineContent = matcher.group(2);
                }
                String tmp = matchName;
                matchName = matchValue;
                matchValue = tmp;
            }
            String matched = pattern.pattern();
            docTag.matchName = matchName;
            docTag.matchValue = matchValue;
            docTag.lastParameterName = lastParameterName;
            if (reportAboutFieldInParameter) {
                docTag.matchName = JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName);
                docTag.type = JSDocumentationProcessor.MetaDocType.FIELD;
            }
            if (processor != null) {
                if (reportAboutFieldInParameter) {
                    if (!processor.onPatternMatch(JSDocumentationProcessor.MetaDocType.FIELD, JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName), matchValue, remainingLineContent, commentText, matched)) {
                        return docTag;
                    }
                } else if (!processor.onPatternMatch(docType, matchName, matchValue, remainingLineContent, commentText, matched)) {
                    docTag.breakEnd = true;
                }
                if (reportAboutOptionalParameter && !processor.onPatternMatch(JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS, JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName), null, null, commentText, matched)) {
                    return docTag;
                }
                if (reportAboutDefaultValue) {
                    processor.onPatternMatch(JSDocumentationProcessor.MetaDocType.DEFAULT, JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName), null, matcher.group(groupForInitialValue), commentText, matched);
                }
            }
            return docTag;
        }
        return null;
    }

    public static List<PsiElement> getElementsForExternalDocumentation(PsiElement original) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        if (!(original instanceof JSReferenceExpression)) {
            elements.add(original);
        }
        return elements;
    }

    @Nullable
    public static JSDocParametersMappingToFunctionInfo checkDocCommentMatchesFunctionSignature(@NotNull JSDocComment docComment, @NotNull JSFunction function) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "checkDocCommentMatchesFunctionSignature"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "checkDocCommentMatchesFunctionSignature"));
        }
        JSParameter[] parameters = function.getParameterVariables();
        HashMap<String, Integer> actualParameters = new HashMap<String, Integer>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            actualParameters.put(parameters[i].getName(), i);
        }
        HashMap<String, Integer> matchingTagIndexes = new HashMap<String, Integer>();
        HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
        Map<Integer, Integer> tagsToParameters = JSDocumentationUtils.getTagToParameterMap(docComment, function, tagNames);
        for (Map.Entry<Integer, Integer> entry : tagsToParameters.entrySet()) {
            Integer paramIndex = entry.getValue();
            if (paramIndex == -1 || paramIndex == Integer.MAX_VALUE) continue;
            matchingTagIndexes.put(parameters[paramIndex].getName(), entry.getKey());
        }
        HashMap<Integer, String> paramsToRemove = new HashMap<Integer, String>();
        Collection matchedTags = matchingTagIndexes.values();
        for (Map.Entry entry : tagNames.entrySet()) {
            Integer tagIndex = (Integer)entry.getKey();
            if (matchedTags.contains(tagIndex) || tagsToParameters.get(tagIndex) >= 0 && (tagsToParameters.get(tagIndex) >= parameters.length || parameters[tagsToParameters.get(tagIndex)].isRest())) continue;
            paramsToRemove.put(tagIndex, (String)entry.getValue());
        }
        if (!paramsToRemove.isEmpty()) {
            Iterator iterator = paramsToRemove.values().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!"arguments".equals(string)) continue;
                iterator.remove();
                break;
            }
        }
        List<Pair<Integer, String>> parametersToAdd = Collections.emptyList();
        if (matchingTagIndexes.size() < actualParameters.size()) {
            parametersToAdd = new ArrayList();
            for (JSParameter parameter : parameters) {
                String parameterName = parameter.getName();
                Integer tagIndex = (Integer)matchingTagIndexes.get(parameterName);
                if (tagIndex != null) continue;
                int insertionPlace = -1;
                int insertedParameterIndex = (Integer)actualParameters.get(parameterName);
                for (Map.Entry entry : matchingTagIndexes.entrySet()) {
                    if (insertedParameterIndex < (Integer)actualParameters.get(entry.getKey())) {
                        insertionPlace = insertionPlace == -1 ? (Integer)entry.getValue() : Math.min(insertionPlace, (Integer)entry.getValue());
                        continue;
                    }
                    if (insertedParameterIndex <= (Integer)actualParameters.get(entry.getKey())) continue;
                    insertionPlace = Math.max(insertionPlace, (Integer)entry.getValue() + 1);
                }
                parametersToAdd.add((Pair<Integer, String>)Pair.create((Object)(insertionPlace == -1 ? Integer.MAX_VALUE : insertionPlace), (Object)parameterName));
            }
        }
        if (parametersToAdd.isEmpty() && paramsToRemove.isEmpty()) {
            return null;
        }
        boolean bl = !tagsToParameters.isEmpty() || !paramsToRemove.isEmpty();
        return new JSDocParametersMappingToFunctionInfo(parametersToAdd, paramsToRemove, bl);
    }

    @NotNull
    public static Map<Integer, Integer> getTagToParameterMap(@NotNull JSDocComment docComment, @NotNull JSFunction function, @Nullable Map<Integer, String> outTagNames) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getTagToParameterMap"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getTagToParameterMap"));
        }
        JSParameter[] parameters = function.getParameterVariables();
        HashMap<String, Integer> actualParameters = new HashMap<String, Integer>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            actualParameters.put(parameters[i].getName(), i);
        }
        JSDocTag[] tags = docComment.getTags();
        TIntIntHashMapDecorator result = new TIntIntHashMapDecorator(new TIntIntHashMap());
        for (int i = 0; i < tags.length; ++i) {
            JSDocTag tag = tags[i];
            DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
            if (docTag == null || docTag.type != JSDocumentationProcessor.MetaDocType.PARAMETER) continue;
            if (outTagNames != null) {
                outTagNames.put(i, docTag.matchName);
            }
            if (actualParameters.containsKey(docTag.matchName)) {
                result.put(i, actualParameters.get(docTag.matchName));
                continue;
            }
            boolean rest = false;
            if (docTag.matchValue != null) {
                JSParameterTypeDecorator parameterType = new JSTypeParser(docTag.matchValue, JSTypeSource.EMPTY).parseParameterType();
                boolean bl = rest = parameterType != null && parameterType.isRest();
            }
            if (rest) {
                result.put(i, Integer.MAX_VALUE);
                continue;
            }
            result.put(i, -1);
        }
        TIntIntHashMapDecorator tIntIntHashMapDecorator = result;
        if (tIntIntHashMapDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getTagToParameterMap"));
        }
        return tIntIntHashMapDecorator;
    }

    public static JSContext findJSContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "findJSContext"));
        }
        PsiComment comment = JSDocumentationUtils.findDocComment(element);
        if (comment instanceof JSDocComment) {
            return ((JSDocComment)comment).getJSContext();
        }
        return JSContext.UNKNOWN;
    }

    public static boolean isExtendedTypeName(String type) {
        return ourJSDocExtendedTypeNamePattern.matcher(type).matches();
    }

    public static boolean hasTagProvidingNamespace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "hasTagProvidingNamespace"));
        }
        return JSDocumentationUtils.findDocForAnchor(element, JSDocumentationProcessor.MetaDocType.CLASS, JSDocumentationProcessor.MetaDocType.CONSTRUCTOR, JSDocumentationProcessor.MetaDocType.ENUM, JSDocumentationProcessor.MetaDocType.INTERFACE, JSDocumentationProcessor.MetaDocType.NAMESPACE) != null;
    }

    @Nullable
    public static TextRange getParameterNameRange(@NotNull JSDocTag paramTag) {
        if (paramTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramTag", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getParameterNameRange"));
        }
        PsiElement data = paramTag.getDocCommentData();
        if (data == null) {
            return null;
        }
        Matcher matcher = ourJSDocParametersRestPattern.matcher(data.getText());
        if (!matcher.matches() || matcher.groupCount() < 2) {
            return null;
        }
        int offsetInParent = data.getStartOffsetInParent();
        int start = matcher.start(2);
        int end = matcher.end(2);
        return start >= 0 && end >= 0 ? new TextRange(offsetInParent + start, offsetInParent + end) : null;
    }

    @NotNull
    public static JSNamespace getNamespaceFromJSDoc(@NotNull JSNamedElement element) {
        PsiComment docComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getNamespaceFromJSDoc"));
        }
        if (DialectDetector.isJavaScript((PsiElement)element) && (docComment = JSDocumentationUtils.findDocComment((PsiElement)element)) instanceof JSDocComment) {
            JSDocComment jsDocComment = (JSDocComment)docComment;
            JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(jsDocComment.getNamespace(), jsDocComment.getJSContext(), jsDocComment.isNamespaceExplicitlyDeclared());
            if (jSNamespaceImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getNamespaceFromJSDoc"));
            }
            return jSNamespaceImpl;
        }
        JSNamespace jSNamespace = JSNamespaceImpl.UNDEFINED;
        if (jSNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationUtils", "getNamespaceFromJSDoc"));
        }
        return jSNamespace;
    }

    static {
        patternToHintMap.put(ourJSDocParametersPattern, "@pa");
        patternToMetaDocTypeMap.put(ourJSDocParametersPattern, JSDocumentationProcessor.MetaDocType.PARAMETER);
        patternToHintMap.put(ourDojoParametersPattern, ":");
        inlinePatternToMetaDocTypeMap.put(ourDojoParametersPattern, JSDocumentationProcessor.MetaDocType.PARAMETER);
        patternToHintMap.put(ourJSDocMethodPattern, "@m");
        patternToMetaDocTypeMap.put(ourJSDocMethodPattern, JSDocumentationProcessor.MetaDocType.METHOD);
        patternToHintMap.put(ourJSDocOptionalPattern, "@op");
        patternToMetaDocTypeMap.put(ourJSDocOptionalPattern, JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS);
        patternToHintMap.put(ourJSDocEventPattern, "@ev");
        patternToMetaDocTypeMap.put(ourJSDocEventPattern, JSDocumentationProcessor.MetaDocType.EVENT);
        patternToHintMap.put(ourJSDocCfgPattern, "@cf");
        patternToMetaDocTypeMap.put(ourJSDocCfgPattern, JSDocumentationProcessor.MetaDocType.CONFIG);
        patternToHintMap.put(ourJSDocConfigPattern, "@conf");
        patternToMetaDocTypeMap.put(ourJSDocConfigPattern, JSDocumentationProcessor.MetaDocType.CONFIG);
        patternToHintMap.put(ourJSDocExtendsPattern, "@ex");
        patternToMetaDocTypeMap.put(ourJSDocExtendsPattern, JSDocumentationProcessor.MetaDocType.EXTENDS);
        patternToHintMap.put(ourJSDocAugmentsPattern, "@au");
        patternToMetaDocTypeMap.put(ourJSDocAugmentsPattern, JSDocumentationProcessor.MetaDocType.EXTENDS);
        patternToHintMap.put(ourJSDocThrowsPattern, "@th");
        patternToMetaDocTypeMap.put(ourJSDocThrowsPattern, JSDocumentationProcessor.MetaDocType.THROWS);
        patternToHintMap.put(ourJSDocRemarkPattern, "@rem");
        patternToMetaDocTypeMap.put(ourJSDocRemarkPattern, JSDocumentationProcessor.MetaDocType.NOTE);
        patternToHintMap.put(ourJSDocReturnPattern, "@ret");
        patternToMetaDocTypeMap.put(ourJSDocReturnPattern, JSDocumentationProcessor.MetaDocType.RETURN);
        patternToHintMap.put(ourJSDocBrowserPattern, "@b");
        patternToMetaDocTypeMap.put(ourJSDocBrowserPattern, JSDocumentationProcessor.MetaDocType.BROWSER);
        patternToHintMap.put(ourJSDocPublicPattern, "@pu");
        patternToMetaDocTypeMap.put(ourJSDocPublicPattern, JSDocumentationProcessor.MetaDocType.PUBLIC);
        patternToHintMap.put(ourJSDocProtectedPattern, "@prot");
        patternToMetaDocTypeMap.put(ourJSDocProtectedPattern, JSDocumentationProcessor.MetaDocType.PROTECTED);
        patternToHintMap.put(ourJSDocStaticPattern, "@st");
        patternToMetaDocTypeMap.put(ourJSDocStaticPattern, JSDocumentationProcessor.MetaDocType.STATIC);
        patternToHintMap.put(ourJSDocSeePattern, "@se");
        patternToMetaDocTypeMap.put(ourJSDocSeePattern, JSDocumentationProcessor.MetaDocType.SEE);
        patternToHintMap.put(ourJSDocDescriptionPattern, "@des");
        patternToMetaDocTypeMap.put(ourJSDocDescriptionPattern, JSDocumentationProcessor.MetaDocType.DESCRIPTION);
        patternToHintMap.put(ourJSDocDeprecatedPattern, "@dep");
        patternToMetaDocTypeMap.put(ourJSDocDeprecatedPattern, JSDocumentationProcessor.MetaDocType.DEPRECATED);
        patternToHintMap.put(ourJSDocConstructorPattern, "@cons");
        patternToMetaDocTypeMap.put(ourJSDocConstructorPattern, JSDocumentationProcessor.MetaDocType.CONSTRUCTOR);
        patternToHintMap.put(ourJSDocConstructsPattern, "@cons");
        patternToMetaDocTypeMap.put(ourJSDocConstructsPattern, JSDocumentationProcessor.MetaDocType.CONSTRUCTS);
        patternToHintMap.put(ourJSDocClassPattern, "@cl");
        patternToMetaDocTypeMap.put(ourJSDocClassPattern, JSDocumentationProcessor.MetaDocType.CLASS);
        patternToHintMap.put(ourJSDocLendsPattern, "@le");
        patternToMetaDocTypeMap.put(ourJSDocLendsPattern, JSDocumentationProcessor.MetaDocType.LENDS);
        patternToHintMap.put(ourJSDocPrivatePattern, "@pri");
        patternToMetaDocTypeMap.put(ourJSDocPrivatePattern, JSDocumentationProcessor.MetaDocType.PRIVATE);
        patternToHintMap.put(ourJSDocNamespacePattern, "@n");
        patternToMetaDocTypeMap.put(ourJSDocNamespacePattern, JSDocumentationProcessor.MetaDocType.NAMESPACE);
        patternToHintMap.put(ourJSDocNamePattern, "@n");
        patternToMetaDocTypeMap.put(ourJSDocNamePattern, JSDocumentationProcessor.MetaDocType.NAME);
        patternToHintMap.put(ourJSDocPropertyPattern, "@prop");
        patternToMetaDocTypeMap.put(ourJSDocPropertyPattern, JSDocumentationProcessor.MetaDocType.PROPERTY);
        patternToHintMap.put(ourJSDocTypePattern, "@ty");
        patternToMetaDocTypeMap.put(ourJSDocTypePattern, JSDocumentationProcessor.MetaDocType.TYPE);
        patternToHintMap.put(ourJSDocFinalPattern, "@f");
        patternToMetaDocTypeMap.put(ourJSDocFinalPattern, JSDocumentationProcessor.MetaDocType.FINAL);
        patternToHintMap.put(ourJSDocConstantPattern, "@const");
        patternToMetaDocTypeMap.put(ourJSDocConstantPattern, JSDocumentationProcessor.MetaDocType.FINAL);
        patternToHintMap.put(ourJSDocRequiresPattern, "@req");
        patternToMetaDocTypeMap.put(ourJSDocRequiresPattern, JSDocumentationProcessor.MetaDocType.REQUIRES);
        patternToHintMap.put(ourJSDocDefaultPattern, "@def");
        patternToMetaDocTypeMap.put(ourJSDocDefaultPattern, JSDocumentationProcessor.MetaDocType.DEFAULT);
        patternToHintMap.put(ourJSDocInheritDocPattern, "@inh");
        patternToMetaDocTypeMap.put(ourJSDocInheritDocPattern, JSDocumentationProcessor.MetaDocType.INHERIT_DOC);
        patternToHintMap.put(ourJSDocTypedefPattern, "@typ");
        patternToMetaDocTypeMap.put(ourJSDocTypedefPattern, JSDocumentationProcessor.MetaDocType.TYPEDEF);
        patternToHintMap.put(ourJSDocEnumPattern, "@en");
        patternToMetaDocTypeMap.put(ourJSDocEnumPattern, JSDocumentationProcessor.MetaDocType.ENUM);
        patternToHintMap.put(ourJSDocInterfacePattern, "@int");
        patternToMetaDocTypeMap.put(ourJSDocInterfacePattern, JSDocumentationProcessor.MetaDocType.INTERFACE);
        patternToHintMap.put(ourJSDocImplementsPattern, "@imp");
        patternToMetaDocTypeMap.put(ourJSDocImplementsPattern, JSDocumentationProcessor.MetaDocType.IMPLEMENTS);
        patternToHintMap.put(ourJSDocOverridePattern, "@ov");
        patternToMetaDocTypeMap.put(ourJSDocOverridePattern, JSDocumentationProcessor.MetaDocType.OVERRIDE);
        patternToHintMap.put(ourJSDocThisPattern, "@th");
        patternToMetaDocTypeMap.put(ourJSDocThisPattern, JSDocumentationProcessor.MetaDocType.THIS);
        patternToHintMap.put(ourJSDocMixinPattern, "@mix");
        patternToMetaDocTypeMap.put(ourJSDocMixinPattern, JSDocumentationProcessor.MetaDocType.MIXIN);
        patternToHintMap.put(ourJSDocMixesPattern, "@mix");
        patternToMetaDocTypeMap.put(ourJSDocMixesPattern, JSDocumentationProcessor.MetaDocType.MIXES);
        patternToHintMap.put(ourJSDocFunctionPattern, "@fun");
        patternToMetaDocTypeMap.put(ourJSDocFunctionPattern, JSDocumentationProcessor.MetaDocType.FUNCTION);
        patternToHintMap.put(ourJSDocExportsPattern, "@exp");
        patternToMetaDocTypeMap.put(ourJSDocExportsPattern, JSDocumentationProcessor.MetaDocType.EXPORTS);
        patternToHintMap.put(ourJSDocTemplatePattern, "@tem");
        patternToMetaDocTypeMap.put(ourJSDocTemplatePattern, JSDocumentationProcessor.MetaDocType.TEMPLATE);
        patternToHintMap.put(ourJSDocAuthorPattern, "@aut");
        patternToMetaDocTypeMap.put(ourJSDocAuthorPattern, JSDocumentationProcessor.MetaDocType.AUTHOR);
        patternToHintMap.put(ourJSDocExamplePattern, "@exa");
        patternToMetaDocTypeMap.put(ourJSDocExamplePattern, JSDocumentationProcessor.MetaDocType.EXAMPLE);
        patternToHintMap.put(ourJSDocFileOverviewPattern, "@fil");
        patternToMetaDocTypeMap.put(ourJSDocFileOverviewPattern, JSDocumentationProcessor.MetaDocType.FILE_OVERVIEW);
        patternToHintMap.put(ourJSDocSincePattern, "@sin");
        patternToMetaDocTypeMap.put(ourJSDocSincePattern, JSDocumentationProcessor.MetaDocType.SINCE);
        patternToHintMap.put(ourJSDocVersionPattern, "@ver");
        patternToMetaDocTypeMap.put(ourJSDocVersionPattern, JSDocumentationProcessor.MetaDocType.VERSION);
        patternToHintMap.put(ourJSDocMemberOfPattern, "@mem");
        patternToMetaDocTypeMap.put(ourJSDocMemberOfPattern, JSDocumentationProcessor.MetaDocType.MEMBER_OF);
        patternToHintMap.put(ourJSDocFieldOfPattern, "@fie");
        patternToMetaDocTypeMap.put(ourJSDocFieldOfPattern, JSDocumentationProcessor.MetaDocType.MEMBER_OF);
        patternToHintMap.put(ourJSDocMethodOfPattern, "@met");
        patternToMetaDocTypeMap.put(ourJSDocMethodOfPattern, JSDocumentationProcessor.MetaDocType.MEMBER_OF);
        patternToHintMap.put(ourJSDocAbstractPattern, "@abs");
        patternToMetaDocTypeMap.put(ourJSDocAbstractPattern, JSDocumentationProcessor.MetaDocType.ABSTRACT);
        patternToHintMap.put(ourJSDocVirtualPattern, "@vir");
        patternToMetaDocTypeMap.put(ourJSDocVirtualPattern, JSDocumentationProcessor.MetaDocType.ABSTRACT);
        patternToHintMap.put(ourJSDocAliasPattern, "@ali");
        patternToMetaDocTypeMap.put(ourJSDocAliasPattern, JSDocumentationProcessor.MetaDocType.ALIAS);
        patternToHintMap.put(ourJSDocCallbackPattern, "@cal");
        patternToMetaDocTypeMap.put(ourJSDocCallbackPattern, JSDocumentationProcessor.MetaDocType.CALLBACK);
        patternToHintMap.put(ourJSDocExternalPattern, "@ext");
        patternToMetaDocTypeMap.put(ourJSDocExternalPattern, JSDocumentationProcessor.MetaDocType.EXTERNAL);
        patternToHintMap.put(ourJSDocHostPattern, "@hos");
        patternToMetaDocTypeMap.put(ourJSDocHostPattern, JSDocumentationProcessor.MetaDocType.EXTERNAL);
        patternToHintMap.put(ourJSDocGlobalPattern, "@glo");
        patternToMetaDocTypeMap.put(ourJSDocGlobalPattern, JSDocumentationProcessor.MetaDocType.GLOBAL);
        patternToHintMap.put(ourJSDocMemberPattern, "@mem");
        patternToMetaDocTypeMap.put(ourJSDocMemberPattern, JSDocumentationProcessor.MetaDocType.MEMBER);
        patternToHintMap.put(ourJSDocVarPattern, "@var");
        patternToMetaDocTypeMap.put(ourJSDocVarPattern, JSDocumentationProcessor.MetaDocType.MEMBER);
        patternToHintMap.put(ourJSDocModulePattern, "@mod");
        patternToMetaDocTypeMap.put(ourJSDocModulePattern, JSDocumentationProcessor.MetaDocType.MODULE);
        patternToHintMap.put(ourJSDocFiresPattern, "@fir");
        patternToMetaDocTypeMap.put(ourJSDocFiresPattern, JSDocumentationProcessor.MetaDocType.FIRES);
        patternToHintMap.put(ourJSDocEmitsPattern, "@emi");
        patternToMetaDocTypeMap.put(ourJSDocEmitsPattern, JSDocumentationProcessor.MetaDocType.FIRES);
        patternToHintMap.put(ourJSDocTodoPattern, "@tod");
        patternToMetaDocTypeMap.put(ourJSDocTodoPattern, JSDocumentationProcessor.MetaDocType.TODO);
        prefixToPatternToHintMap = new THashMap();
        prefixToPatternToHintMap.put(Pattern.compile("^\\s*description:(.*)$"), "descr");
        prefixToPatternToHintMap.put(Pattern.compile("^ summary(?:\\:)?(.*)$"), "summ");
        prefixToPatternToHintMap.put(Pattern.compile("^\\s*\\*(?:\\*)?(.*)$"), "*");
        prefixToPatternToHintMap.put(Pattern.compile("^[/]+(.*)$"), "/");
        prefixToPatternToHintMap.put(Pattern.compile("^\\s*Parameters:(.*)$"), "Parame");
        DOC_COMMENT_ALLOWED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.COMMENTS_AND_WHITESPACES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.ATTRIBUTE_LIST})});
        ourPrimitiveTypeFilter = JSKeywordSets.PRIMITIVE_TYPES;
        ourTypeFilter = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION}), ourPrimitiveTypeFilter, JSElementTypes.TYPESCRIPT_OR_ES6_TYPES});
    }

    public static class JSDocParametersMappingToFunctionInfo {
        private List<Pair<Integer, String>> myParamsToAdd;
        private Map<Integer, String> myParamsToRemove;
        private boolean myHasParamTag;

        public JSDocParametersMappingToFunctionInfo(List<Pair<Integer, String>> paramsToAdd, Map<Integer, String> paramsToRemove, boolean hasParamTag) {
            this.myParamsToAdd = paramsToAdd;
            this.myParamsToRemove = paramsToRemove;
            this.myHasParamTag = hasParamTag;
        }

        public List<Pair<Integer, String>> getParamsToAdd() {
            return this.myParamsToAdd;
        }

        public Map<Integer, String> getParamsToRemove() {
            return this.myParamsToRemove;
        }

        public boolean hasParamTag() {
            return this.myHasParamTag;
        }
    }

    public static class DocTag {
        public JSDocumentationProcessor.MetaDocType type;
        public String matchName;
        public String matchValue;
        public String lastParameterName;
        public boolean breakEnd;
        public boolean continueType;
    }
}

