/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSAutocompleteCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCheckContentsCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSCoverageCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSFindModuleCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSGetDefinitionCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSStatusCommand;
import com.intellij.lang.javascript.flow.protocol.commands.FlowJSTypeInfoCommand;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServerService
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance(FlowJSServerService.class);
    public static final long SMALL_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
    public static final long MIDDLE_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    public static final long LARGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long COMPLETION_TIMEOUT_MILLIS = 1000L;
    public static final int QUOTA_MILLIS = 100;
    @NotNull
    protected final Project myProject;
    @Nullable
    private JSLanguageService myService;
    @NotNull
    private Set<VirtualFile> myServerPaths;

    public FlowJSServerService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "<init>"));
        }
        this.myProject = project;
        this.myServerPaths = ContainerUtil.newHashSet();
    }

    @NotNull
    protected JSLanguageServiceImpl createService() {
        FlowJSStandardOutputProtocol protocol = new FlowJSStandardOutputProtocol(this.myProject);
        JSLanguageServiceToolWindowManager toolWindowManager = FlowJSToolWindowProvider.getToolWindow(this.myProject);
        JSLanguageService.ServiceInfoReporter errorReporter = toolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, toolWindowManager, false) : JSLanguageService.DEFAULT_REPORTER;
        JSLanguageServiceDefaultCacheData cacheData = new JSLanguageServiceDefaultCacheData(){

            public int hashCode() {
                return FlowJSServerService.this.myProject.hashCode();
            }

            @Override
            @Nullable
            public JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
                if (input == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/flow/FlowJSServerService$1", "updateCacheAndGetServiceObject"));
                }
                return new TypeScriptReloadProjectsCommand().toSerializableObject();
            }
        };
        JSLanguageServiceImpl jSLanguageServiceImpl = new JSLanguageServiceImpl(this.myProject, protocol, toolWindowManager, errorReporter, cacheData);
        if (jSLanguageServiceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "createService"));
        }
        return jSLanguageServiceImpl;
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "getService"));
        }
        FlowJSServerService service = (FlowJSServerService)ServiceManager.getService((Project)project, FlowJSServerService.class);
        if (service == null) {
            return null;
        }
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(service.myProject).getFlowSettings();
        if (!settings.isTypeCheckingEnabled()) {
            return null;
        }
        String flowPath = settings.getFlowExecutablePath();
        if (StringUtil.isEmpty((String)flowPath)) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(flowPath);
        JSLanguageServiceToolWindowManager flowJSToolWindowProvider = FlowJSToolWindowProvider.getToolWindow(project);
        if (virtualFile == null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (flowJSToolWindowProvider != null) {
                    ImmutableList<JSLanguageServiceAnnotationResult> results = JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.validation.message.flowjs.path", (Object[])new Object[0]));
                    flowJSToolWindowProvider.logProjectErrors(results, true);
                }
            });
            return null;
        }
        return service;
    }

    public void restartService() {
        if (this.myService != null) {
            Disposer.dispose((Disposable)this.myService);
        }
        this.myService = this.createService();
    }

    public <T> Future<T> sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandResultProcessor<T> processor, @NotNull FlowJSConfig config) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "sendCommand"));
        }
        if (this.myService == null) {
            this.restartService();
        }
        this.myServerPaths.add(config.getConfigDirectory());
        return this.myService.execute(command, processor);
    }

    @Nullable
    public FlowJSConfig getConfig(@NotNull VirtualFile file) {
        Collection<FlowJSConfig> configCollection;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "getConfig"));
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        if (configService != null && (configCollection = configService.getConfigOfFile(file)).size() >= 1) {
            return this.getClosestConfig(configCollection, file);
        }
        return null;
    }

    private FlowJSConfig getClosestConfig(@NotNull Collection<FlowJSConfig> configCollection, @NotNull VirtualFile file) {
        if (configCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configCollection", "com/intellij/lang/javascript/flow/FlowJSServerService", "getClosestConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "getClosestConfig"));
        }
        HashSet filePathElements = ContainerUtil.newHashSet();
        this.addAllElements(file, filePathElements);
        int diffForFile = Integer.MAX_VALUE;
        int diffForConfig = Integer.MAX_VALUE;
        FlowJSConfig closestConfig = (FlowJSConfig)ContainerUtil.getFirstItem(configCollection);
        for (FlowJSConfig config : configCollection) {
            HashSet configPathElements = ContainerUtil.newHashSet();
            this.addAllElements(config.getConfigDirectory(), configPathElements);
            HashSet configPathElementsCopy = ContainerUtil.newHashSet();
            configPathElementsCopy.addAll(configPathElements);
            HashSet filePathElementsCopy = ContainerUtil.newHashSet();
            filePathElementsCopy.addAll(filePathElements);
            filePathElementsCopy.removeAll(configPathElements);
            configPathElementsCopy.removeAll(filePathElements);
            if (diffForConfig == 0) {
                if (diffForFile <= filePathElementsCopy.size()) continue;
                diffForFile = filePathElementsCopy.size();
                closestConfig = config;
                continue;
            }
            long currentSum = diffForConfig + diffForFile;
            long tempSum = filePathElementsCopy.size() + configPathElementsCopy.size();
            if (configPathElementsCopy.size() != 0 && currentSum <= tempSum) continue;
            diffForConfig = configPathElementsCopy.size();
            diffForFile = filePathElementsCopy.size();
            closestConfig = config;
        }
        return closestConfig;
    }

    private void addAllElements(@NotNull VirtualFile file, Set<String> filePathElements) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "addAllElements"));
        }
        for (String element : file.getPath().split("/")) {
            if (element.equals("") || element.equals(file.getName())) continue;
            filePathElements.add(element);
        }
    }

    public PsiElement getDefinitionOfElement(@NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull PsiElement element, @NotNull FlowJSConfig config) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getDefinitionOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        this.setCommandLineParams(request, config);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        FlowJSGetDefinitionCommand commandWithArgument = new FlowJSGetDefinitionCommand(request, document.getText(), virtualFile.getParent().getCanonicalPath());
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromDefinitionCommandAnswer(requestAnswer, virtualFile);
    }

    @Nullable
    private PsiElement getPsiElementFromDefinitionCommandAnswer(@NotNull List<JsonObject> answer, @NotNull VirtualFile currentFile) {
        JsonElement path;
        JsonObject answerJson;
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/javascript/flow/FlowJSServerService", "getPsiElementFromDefinitionCommandAnswer"));
        }
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getPsiElementFromDefinitionCommandAnswer"));
        }
        if (!answer.isEmpty() && (answerJson = answer.get(0)) != null && !(path = answerJson.get("path")).getAsString().isEmpty()) {
            VirtualFile virtualFile;
            int startLine = answerJson.get("line").getAsInt() - 1;
            int startColumn = answerJson.get("start").getAsInt() - 1;
            if (startLine >= 0 && startColumn >= 0 && (virtualFile = !path.getAsString().equals("-") ? LocalFileSystem.getInstance().findFileByPath(path.getAsString()) : currentFile) != null) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
                try {
                    Document document = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile).getDocument();
                    if (document != null) {
                        int offset = document.getLineStartOffset(startLine) + startColumn;
                        if (psiFile != null) {
                            return psiFile.findElementAt(offset);
                        }
                    }
                }
                catch (NullPointerException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public PsiElement findModuleOfElement(@NotNull VirtualFile file, @NotNull PsiElement element, @NotNull FlowJSConfig config) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "findModuleOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        this.setCommandLineParams(request, config);
        request.add(StringUtil.unquoteString((String)element.getText()));
        request.add(file.getPath());
        FlowJSFindModuleCommand commandWithArgument = new FlowJSFindModuleCommand(request, null, file.getParent().getCanonicalPath());
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        return this.getPsiElementFromFindModuleCommandAnswer(requestAnswer);
    }

    @Nullable
    private PsiElement getPsiElementFromFindModuleCommandAnswer(List<JsonObject> answerList) {
        JsonObject answer;
        if (!answerList.isEmpty() && (answer = answerList.get(0)).has("file")) {
            String path = answer.get("file").getAsString();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null) {
                return PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            }
        }
        return null;
    }

    public String getTypeOfElement(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull FlowJSConfig config) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        int offset = element.getTextOffset();
        int line = document.getLineNumber(offset) + 1;
        int column = offset - document.getLineStartOffset(line - 1) + element.getTextLength();
        this.setCommandLineParams(request, config);
        request.add(virtualFile.getName());
        request.add(String.valueOf(line));
        request.add(String.valueOf(column));
        FlowJSTypeInfoCommand commandWithArgument = new FlowJSTypeInfoCommand(request, document.getText(), virtualFile.getParent().getCanonicalPath());
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, SMALL_TIMEOUT);
        return this.getTypeFromAnswer(requestAnswer);
    }

    @NotNull
    private String getTypeFromAnswer(List<JsonObject> answer) {
        JsonObject answerJson;
        String type = "";
        if (!answer.isEmpty() && (answerJson = answer.get(0)).has("type")) {
            type = answerJson.get("type").getAsString();
        }
        String string = type;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getTypeFromAnswer"));
        }
        return string;
    }

    private void setCommandLineParams(List<String> request, FlowJSConfig config) {
        request.add("--root");
        request.add(config.getConfigDirectory().getPath());
        request.add("--json");
    }

    @NotNull
    public List<JsonObject> getCompletionOfElement(@NotNull PsiFile originalFile, @NotNull Document document, @NotNull FlowJSConfig config, @NotNull CompletionParameters parameters, @NotNull String text) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        ArrayList<String> request = new ArrayList<String>();
        this.setCommandLineParams(request, config);
        request.add(originalFile.getVirtualFile().getCanonicalPath());
        PsiDirectory directory = originalFile.getContainingDirectory();
        String filePath = directory != null ? directory.getVirtualFile().getPath() : originalFile.getProject().getBasePath();
        int line = document.getLineNumber(parameters.getOffset());
        request.add(String.valueOf(line + 1));
        request.add(String.valueOf(parameters.getOffset() - document.getLineStartOffset(line) + "IntellijIdeaRulezzz ".length()));
        FlowJSAutocompleteCommand commandWithArgument = new FlowJSAutocompleteCommand(request, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        TypeScriptLanguageServiceUtil.awaitFuture(future, 1000L, 100L, null);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCompletionOfElement"));
        }
        return arrayList;
    }

    @NotNull
    public List<JsonObject> checkContentOfFile(@NotNull FlowJSConfig config, @NotNull String text, @NotNull String fileName, @NotNull String filePath) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        this.setCommandLineParams(parameterList, config);
        parameterList.add(fileName);
        FlowJSCheckContentsCommand commandWithArgument = new FlowJSCheckContentsCommand(parameterList, text, filePath);
        ArrayList<JsonObject> requestAnswer = new ArrayList<JsonObject>();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, MIDDLE_TIMEOUT);
        ArrayList<JsonObject> arrayList = requestAnswer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "checkContentOfFile"));
        }
        return arrayList;
    }

    public List<JSLanguageServiceAnnotationResult> getAllErrors() {
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        ArrayList<JSLanguageServiceAnnotationResult> allErrors = new ArrayList<JSLanguageServiceAnnotationResult>();
        if (configService != null) {
            Collection<FlowJSConfig> configFiles = configService.getConfigFiles();
            FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this.myProject);
            if (fileIndexFacade != null) {
                configFiles.forEach(config -> allErrors.addAll(this.getErrorsFromDir((FlowJSConfig)config)));
            }
        }
        return allErrors;
    }

    public static List<JSLanguageServiceAnnotationResult> parseFlowErrors(@NotNull JsonObject json, @Nullable String filePath) {
        JsonElement hasErrors;
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/lang/javascript/flow/FlowJSServerService", "parseFlowErrors"));
        }
        ArrayList<JSLanguageServiceAnnotationResult> listOfErrors = new ArrayList<JSLanguageServiceAnnotationResult>();
        VirtualFile currentVirtualFile = null;
        if (filePath != null) {
            currentVirtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        if ((hasErrors = json.get("passed")) != null && !hasErrors.getAsBoolean()) {
            try {
                JsonArray errorArray = json.getAsJsonArray("errors");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    int line = 0;
                    int column = 0;
                    int lineEnd = 0;
                    int columnEnd = 0;
                    StringBuilder errorText = new StringBuilder();
                    String localFilePath = null;
                    String errorCategory = errorObject.get("level").getAsString();
                    JsonArray messageArray = errorObject.getAsJsonArray("message");
                    boolean isFirst = true;
                    for (JsonElement message : messageArray) {
                        JsonObject messageObject = message.getAsJsonObject();
                        if (messageObject.get("type").getAsString().equals("Blame")) {
                            String currentFilePath = messageObject.get("path").getAsString();
                            if (currentFilePath == null) continue;
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(currentFilePath);
                            if (currentVirtualFile == null || currentVirtualFile.equals(virtualFile)) {
                                localFilePath = currentFilePath;
                                JsonObject loc = messageObject.get("loc").getAsJsonObject();
                                JsonObject start = loc.get("start").getAsJsonObject();
                                JsonObject end = loc.get("end").getAsJsonObject();
                                if (line == 0) {
                                    line = start.get("line").getAsInt();
                                    column = start.get("column").getAsInt();
                                    lineEnd = end.get("line").getAsInt();
                                    columnEnd = end.get("column").getAsInt();
                                }
                            }
                        }
                        if (isFirst) {
                            errorText.append("Flow: ");
                        }
                        errorText.append(messageObject.get("descr").getAsString());
                        if (!isFirst) {
                            errorText.append(" ");
                        }
                        if (!isFirst || messageArray.size() <= 1) continue;
                        errorText.append(". ");
                        isFirst = false;
                    }
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(errorText.toString(), localFilePath != null && !localFilePath.isEmpty() ? localFilePath : filePath, errorCategory, line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    private List<JSLanguageServiceAnnotationResult> getErrorsFromDir(@NotNull FlowJSConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getErrorsFromDir"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add("--json");
        FlowJSStatusCommand commandWithArgument = new FlowJSStatusCommand(parameterList, config.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList<JSLanguageServiceAnnotationResult> errors = new ArrayList<JSLanguageServiceAnnotationResult>();
        if (requestAnswer.size() > 0) {
            errors.addAll(FlowJSServerService.parseFlowErrors((JsonObject)requestAnswer.get(0), null));
        }
        return errors;
    }

    public List<JSLanguageServiceAnnotationResult> getCoverageOfFile(@NotNull FlowJSConfig config, @NotNull PsiFile originalFile) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCoverageOfFile"));
        }
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/lang/javascript/flow/FlowJSServerService", "getCoverageOfFile"));
        }
        ArrayList<String> parameterList = new ArrayList<String>();
        this.setCommandLineParams(parameterList, config);
        parameterList.add(originalFile.getVirtualFile().getPath());
        FlowJSCoverageCommand commandWithArgument = new FlowJSCoverageCommand(parameterList, originalFile.getText(), config.getConfigDirectory().getPath());
        ArrayList requestAnswer = new ArrayList();
        Future<Boolean> future = this.sendCommand(commandWithArgument, (serviceObject, answer) -> requestAnswer.add(answer.getElement()), config);
        FlowJSServerService.awaitFuture(future, LARGE_TIMEOUT);
        ArrayList errors = ContainerUtil.newArrayList();
        if (!requestAnswer.isEmpty()) {
            errors.addAll(this.parseCoverageError((JsonObject)requestAnswer.get(0)));
        }
        return errors;
    }

    private List<JSLanguageServiceAnnotationResult> parseCoverageError(@NotNull JsonObject json) {
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/lang/javascript/flow/FlowJSServerService", "parseCoverageError"));
        }
        ArrayList listOfErrors = ContainerUtil.newArrayList();
        JsonElement expression = json.get("expressions");
        if (expression != null) {
            try {
                JsonArray errorArray = expression.getAsJsonObject().getAsJsonArray("uncovered_locs");
                for (JsonElement error : errorArray) {
                    if (!error.isJsonObject()) continue;
                    JsonObject errorObject = error.getAsJsonObject();
                    String source = errorObject.get("source").getAsString();
                    JsonObject start = errorObject.get("start").getAsJsonObject();
                    JsonObject end = errorObject.get("end").getAsJsonObject();
                    int line = start.get("line").getAsInt();
                    int column = start.get("column").getAsInt();
                    int lineEnd = end.get("line").getAsInt();
                    int columnEnd = end.get("column").getAsInt();
                    JSLanguageServiceAnnotationResult annotationResult = new JSLanguageServiceAnnotationResult(JSBundle.message((String)"js.flowjs.coverage.inspection.error.text", (Object[])new Object[0]), source != null ? source : "", "Warning", line, column, lineEnd, columnEnd);
                    listOfErrors.add(annotationResult);
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return listOfErrors;
    }

    public static boolean awaitFuture(@NotNull Future<Boolean> future, long period) {
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/lang/javascript/flow/FlowJSServerService", "awaitFuture"));
        }
        try {
            future.get(period, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return false;
        }
        return future.isDone();
    }

    public static void saveSyncAllUnsavedFiles(@NotNull PsiFile exceptThis) {
        if (exceptThis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptThis", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveSyncAllUnsavedFiles"));
        }
        List<Document> toSave = FlowJSServerService.getUnsavedFlowDocuments(exceptThis);
        if (!toSave.isEmpty()) {
            ApplicationManager.getApplication().invokeAndWait(() -> FlowJSServerService.saveFiles(toSave));
        }
    }

    @NotNull
    private static List<Document> getUnsavedFlowDocuments(@NotNull PsiFile exceptThis) {
        if (exceptThis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptThis", "com/intellij/lang/javascript/flow/FlowJSServerService", "getUnsavedFlowDocuments"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        VirtualFile exceptThisVFile = exceptThis.getVirtualFile();
        List<Document> list = Arrays.stream(FileDocumentManager.getInstance().getUnsavedDocuments()).filter(document -> {
            VirtualFile file = documentManager.getFile(document);
            return file != null && !file.equals(exceptThisVFile) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
        }).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getUnsavedFlowDocuments"));
        }
        return list;
    }

    public static boolean saveAsyncAllUnsavedFiles(@NotNull Runnable restartService, @NotNull PsiFile exceptThis) {
        if (restartService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restartService", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveAsyncAllUnsavedFiles"));
        }
        if (exceptThis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptThis", "com/intellij/lang/javascript/flow/FlowJSServerService", "saveAsyncAllUnsavedFiles"));
        }
        List<Document> toSave = FlowJSServerService.getUnsavedFlowDocuments(exceptThis);
        if (!toSave.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (restartService == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restartService", "com/intellij/lang/javascript/flow/FlowJSServerService", "lambda$saveAsyncAllUnsavedFiles$11"));
                }
                FlowJSServerService.saveFiles(toSave);
                restartService.run();
            });
            return true;
        }
        return false;
    }

    private static void saveFiles(Collection<Document> unsavedDocuments) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : unsavedDocuments) {
            fileDocumentManager.saveDocument(document);
        }
    }

    public void dispose() {
        if (this.myService != null) {
            Disposer.dispose((Disposable)this.myService);
        }
        this.myServerPaths.forEach(this::stopFlowServer);
    }

    private void stopFlowServer(@NotNull VirtualFile directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/javascript/flow/FlowJSServerService", "stopFlowServer"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        String path = FlowJSSettingsManager.getInstance(this.myProject).getFlowSettings().getFlowExecutablePath();
        if (path.isEmpty() || StringUtil.isEmpty((String)directory.getCanonicalPath())) {
            return;
        }
        commandLine.setExePath(path);
        commandLine.withWorkDirectory(directory.getCanonicalPath());
        commandLine.addParameter("stop");
        try {
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public static String isFlowServerAvailable(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/flow/FlowJSServerService", "isFlowServerAvailable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerService", "isFlowServerAvailable"));
        }
        if (path.isEmpty()) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.empty", (Object[])new Object[0]);
        }
        GeneralCommandLine line = new GeneralCommandLine();
        line.setExePath(path);
        line.addParameter("version");
        line.addParameter("--json");
        line.setWorkDirectory(project.getBasePath());
        final Ref answer = new Ref();
        final Ref answerReceived = Ref.create((Object)Boolean.FALSE);
        if (!FileUtil.exists((String)path)) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error", (Object[])new Object[0]);
        }
        try {
            OSProcessHandler handler = new OSProcessHandler(line);
            final StringBuilder resultJson = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        answerReceived.set((Object)Boolean.TRUE);
                        String text = event.getText();
                        resultJson.append(text);
                        if (FlowJSStandardOutputProtocol.verifyJson(resultJson.toString())) {
                            answer.set(null);
                        } else {
                            answer.set((Object)JSBundle.message((String)"js.flow.enable.flow.service.error.invalid.json", (Object[])new Object[]{resultJson}));
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        answerReceived.set((Object)Boolean.TRUE);
                        answer.set((Object)event.getText());
                    }
                }
            });
            handler.startNotify();
            if (handler.waitFor()) {
                if (((Boolean)answerReceived.get()).booleanValue() && answer.get() == null) {
                    return null;
                }
                return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{(Boolean)answerReceived.get() != false ? answer.get() : "Empty process output"});
            }
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Process doesn't respond"});
        }
        catch (ExecutionException e) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{e.getMessage()});
        }
    }

    @NotNull
    public static List<String> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList paths = ContainerUtil.newArrayList();
        String execFileName = FlowJSServerService.getFlowExecutableFilename();
        List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)execFileName);
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        ArrayList infos = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName(infos, "flow-bin", project.getBaseDir(), null, false);
        for (CompletionModuleInfo info : infos) {
            VirtualFile moduleDir = info.getVirtualFile();
            if (info.getType() != ModuleType.NODE_MODULES_DIR || moduleDir == null) continue;
            VirtualFile execFile = VfsUtil.findRelativeFile((VirtualFile)moduleDir, (String[])new String[]{"..", ".bin", execFileName});
            if (execFile != null && !execFile.isDirectory()) {
                paths.add(execFile.getPath());
                continue;
            }
            VirtualFile execFileInVendor = VfsUtil.findRelativeFile((VirtualFile)moduleDir, (String[])new String[]{"vendor", execFileName});
            if (execFileInVendor == null || execFileInVendor.isDirectory()) continue;
            paths.add(execFileInVendor.getPath());
        }
        ContainerUtil.removeDuplicates((Collection)paths);
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "calcPossibleFlowExecutableFiles"));
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    private static String getFlowExecutableFilename() {
        String string = SystemInfo.isWindows ? "flow.exe" : "flow";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerService", "getFlowExecutableFilename"));
        }
        return string;
    }
}

