/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;

public class FlowJSPsiTypeParser<T extends ES6Parser<?, ?, ?, ?>>
extends TypeScriptPsiTypeParser<T> {
    static final Key<Boolean> FORCED_TYPE_KEY = Key.create((String)"js.parser.forced.type");

    public FlowJSPsiTypeParser(T parser) {
        super(parser);
    }

    private boolean parseInUnionOrIntersectionTypeInFlow(boolean expectedUnion, boolean parentStartParsing) {
        boolean result;
        int typeCounter = 0;
        PsiBuilder.Marker unionTypeMarker = this.builder.mark();
        do {
            if (this.builder.getTokenType() == JSTokenTypes.OR || this.builder.getTokenType() == JSTokenTypes.AND) {
                this.builder.advanceLexer();
            }
            boolean bl = expectedUnion ? this.parseInUnionOrIntersectionTypeInFlow(false, typeCounter == 1) : (result = this.parseDistinctType(parentStartParsing && ++typeCounter == 1));
        } while (result && this.builder.getTokenType() == (expectedUnion ? JSTokenTypes.OR : JSTokenTypes.AND));
        if (typeCounter == 1) {
            unionTypeMarker.drop();
        } else {
            unionTypeMarker.done(TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE);
        }
        return result;
    }

    @Override
    protected boolean parseDistinctType(boolean regularType) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.QUEST) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseDistinctType(true);
            marker.done(FlowJSElementTypes.MAYBE_TYPE);
            return true;
        }
        if (firstToken == JSTokenTypes.MULT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            return true;
        }
        if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            return this.parserSingleType();
        }
        if (firstToken == JSTokenTypes.LBRACE_OR) {
            return this.parseObjectType(JSTokenTypes.OR_RBRACE, "javascript.parser.message.missing.or_rbrace");
        }
        return super.parseDistinctType(true);
    }

    @Override
    public boolean parseTypeMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.parseAttributeList(JSTokenTypes.STATIC_KEYWORD);
        return super.parseTypeMember(marker);
    }

    @Override
    public boolean tryParseType() {
        if (Boolean.TRUE.equals(this.builder.getUserData(FORCED_TYPE_KEY)) && this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
        }
        return super.tryParseType();
    }

    @Override
    protected boolean parseTypeParameter() {
        PsiBuilder.Marker typeParameter = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.PLUS) {
            this.builder.advanceLexer();
        }
        if (this.builder.getTokenType() == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
        }
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            typeParameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseType();
        } else if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            this.parseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                this.parseType();
            }
        }
        typeParameter.done(TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    @Override
    protected boolean allowLastCommaInTupleType() {
        return true;
    }

    @Override
    public boolean parseTypeAliasType() {
        return this.parseInUnionOrIntersectionTypeInFlow(true, true);
    }
}

