/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSFileReferencesInspection
extends JSInspection {
    public static final String SHORT_NAME = JSFileReferencesInspection.calcShortNameFromClass(JSFileReferencesInspection.class);
    public boolean myIgnoreComplexCases = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.file.references.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFileReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFileReferencesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JSBundle.message((String)"js.file.references.inspection.ignore.complex.cases", (Object[])new Object[0]), (InspectionProfileEntry)this, "myIgnoreComplexCases");
    }

    public static boolean acceptsReference(@NotNull FileReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/inspections/JSFileReferencesInspection", "acceptsReference"));
        }
        PsiElement element = reference.getElement();
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element instanceof PsiComment ? element.getParent() : element);
        if (holder == null) {
            return false;
        }
        if (holder.isTypeScript) {
            if (element instanceof ES6FromClause || element instanceof PsiComment || element instanceof ES6ImportExportSpecifier) {
                return false;
            }
            if (TypeScriptPsiUtil.isLiteralModuleAugmentationName(element)) {
                return false;
            }
        }
        return !holder.isECMA4;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                this.checkReferences((PsiElement)node);
            }

            public void visitES6FromClause(ES6FromClause fromClause) {
                this.checkReferences((PsiElement)fromClause);
            }

            private void checkReferences(PsiElement node) {
                HashMap hardRefs = new HashMap();
                MultiMap softRefs = MultiMap.create();
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof FileReference) || !JSFileReferencesInspection.acceptsReference((FileReference)ref)) continue;
                    FileReference fileRef = (FileReference)ref;
                    TextRange range = ref.getRangeInElement();
                    if (ref.isSoft() && JSFileReferencesInspection.this.myIgnoreComplexCases) {
                        softRefs.putValue((Object)range, (Object)fileRef);
                        continue;
                    }
                    if (hardRefs.containsKey(range) && hardRefs.get(range) == null) continue;
                    ResolveResult[] results = fileRef.multiResolve(false);
                    if (results.length != 0) {
                        hardRefs.put(range, null);
                        continue;
                    }
                    hardRefs.put(range, fileRef);
                }
                block1: for (Map.Entry entry : hardRefs.entrySet()) {
                    FileReference ref = (FileReference)entry.getValue();
                    if (ref == null) continue;
                    for (FileReference softRef : softRefs.get(entry.getKey())) {
                        if (softRef.multiResolve(false).length <= 0) continue;
                        continue block1;
                    }
                    String message = XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
                    holder.registerProblem(node, ref.getRangeInElement(), message, ref.getQuickFixes());
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSFileReferencesInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

