/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertVarToLetConstInspection
extends JSInspection
implements ES6CoolRefactoring {
    public static final String ES6_CONVERT_VAR_TO_LET_CONST = "ES6ConvertVarToLetConst";
    public boolean myConservativeOption = !ApplicationManager.getApplication().isUnitTestMode();
    public boolean myEmulateBatch = false;
    public boolean myEmulateDoNotShow = false;
    private static final Set<Class> ourBlockLikeTypes = new HashSet<Class>();

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVarStatement(JSVarStatement node) {
                boolean isBatch;
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                ASTNode varNode = node.getNode().findChildByType(JSTokenTypes.VAR_KEYWORD);
                if (varNode == null) {
                    return;
                }
                boolean bl = isBatch = !holder.isOnTheFly() || ES6ConvertVarToLetConstInspection.this.myEmulateBatch && ApplicationManager.getApplication().isUnitTestMode();
                if (isBatch) {
                    ES6ConvertVarToLetConstQuickFix fix = new ES6ConvertVarToLetConstQuickFix(node).setInBatch(true).setConservative(ES6ConvertVarToLetConstInspection.this.myConservativeOption);
                    holder.registerProblem(varNode.getPsi(), JSBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                } else {
                    boolean asIntention = ES6ConvertVarToLetConstInspection.this.checkHighlightLevel(node, holder);
                    holder.registerProblem(varNode.getPsi(), JSBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(true).setForceFix(asIntention), new ES6ConvertVarToLetConstQuickFix(node).forceVariant(false).setForceFix(asIntention)});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private boolean checkHighlightLevel(@NotNull JSVarStatement node, @NotNull ProblemsHolder holder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "checkHighlightLevel"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "checkHighlightLevel"));
        }
        if (this.myEmulateDoNotShow && ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        boolean asIntention = false;
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)holder.getProject()).getCurrentProfile();
        HighlightDisplayKey id = HighlightDisplayKey.findById((String)ES6_CONVERT_VAR_TO_LET_CONST);
        if (id != null) {
            HighlightDisplayLevel errorLevel = profile.getErrorLevel(id, (PsiElement)node);
            asIntention = HighlightDisplayLevel.DO_NOT_SHOW.equals(errorLevel);
        }
        return asIntention;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if (ES6_CONVERT_VAR_TO_LET_CONST == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "getID"));
        }
        return ES6_CONVERT_VAR_TO_LET_CONST;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JSBundle.message((String)"js.convert.var.to.let.or.const.inspection.conservative.option", (Object[])new Object[0]), JSBundle.message((String)"js.convert.var.to.let.or.const.inspection.conservative.option", (Object[])new Object[0]), "myConservativeOption");
    }

    @Override
    @NotNull
    public String getShortName() {
        if (ES6_CONVERT_VAR_TO_LET_CONST == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "getShortName"));
        }
        return ES6_CONVERT_VAR_TO_LET_CONST;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.convert.var.to.let.or.const.inspection.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "getDisplayName"));
        }
        return string;
    }

    private static boolean isBlockLike(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "isBlockLike"));
        }
        Class<?> clazz = element.getClass();
        if (!JSStatement.class.isAssignableFrom(clazz)) {
            return false;
        }
        for (Class type : ourBlockLikeTypes) {
            if (!type.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static ScopeInfo getScopeInformation(PsiElement element) {
        ScopeInfo scope = new ScopeInfo();
        PsiElement current = element.getParent();
        while (current != null && (scope.functionParent == null || scope.blockParent == null)) {
            if (JSUtils.isScopeOwner(current)) {
                scope.functionParent = (JSNamedElement)current;
            } else if (scope.blockParent == null && ES6ConvertVarToLetConstInspection.isBlockLike(current)) {
                if (scope.wrappingBlockParent == null) {
                    JSVarStatement forDeclaration = null;
                    if (current instanceof JSForInStatement && (forDeclaration = ((JSForInStatement)current).getDeclarationStatement()) != null || current instanceof JSForStatement && (forDeclaration = ((JSForStatement)current).getVarDeclaration()) != null) {
                        scope.wrappingBlockParent = current;
                        if (PsiTreeUtil.isAncestor((PsiElement)forDeclaration, (PsiElement)element, (boolean)false)) {
                            current = current.getParent();
                            continue;
                        }
                    }
                }
                scope.blockParent = current;
            }
            if (current instanceof PsiFile || (scope.isEmbedded = current instanceof JSEmbeddedContent)) {
                scope.topLevel = true;
                break;
            }
            current = current.getParent();
        }
        if (scope.wrappingBlockParent == null) {
            scope.wrappingBlockParent = scope.blockParent;
        }
        return scope;
    }

    static Pair<List<JSVariable>, Boolean> findDuplicates(final @NotNull JSVariable variable, final @NotNull PsiElement variableScopeElement, @Nullable PsiElement variableBlockScope) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "findDuplicates"));
        }
        if (variableScopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableScopeElement", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection", "findDuplicates"));
        }
        final ArrayList varDuplicates = new ArrayList();
        final ArrayList letConstDuplicates = new ArrayList();
        Ref success = new Ref((Object)true);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope(variableScopeElement, new JSResolveProcessorBase(null){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspection$2", "execute"));
                }
                if (!PsiTreeUtil.isAncestor((PsiElement)variableScopeElement, (PsiElement)element, (boolean)false)) {
                    return true;
                }
                if (element instanceof JSVariable && element != variable && variable.getName().equals(((JSVariable)element).getName())) {
                    if (element.getParent() != null && element.getParent().getNode().findChildByType(JSTokenTypes.VAR_KEYWORD) == null) {
                        letConstDuplicates.add((JSVariable)element);
                    } else {
                        varDuplicates.add((JSVariable)element);
                    }
                }
                return true;
            }
        }, false);
        if (!letConstDuplicates.isEmpty()) {
            boolean conflicting = false;
            HashSet<PsiElement> varDuplicatesBlocks = new HashSet<PsiElement>();
            if (variableBlockScope == null) {
                varDuplicatesBlocks.add(variableScopeElement);
            } else {
                varDuplicatesBlocks.add(variableBlockScope);
            }
            for (JSVariable duplicate : varDuplicates) {
                varDuplicatesBlocks.add(ES6ConvertVarToLetConstInspection.getBlockScope((PsiElement)duplicate, variableScopeElement));
            }
            block1: for (JSVariable letConst : letConstDuplicates) {
                PsiElement block = ES6ConvertVarToLetConstInspection.getBlockScope((PsiElement)letConst, variableScopeElement);
                if (varDuplicatesBlocks.contains(block)) {
                    conflicting = true;
                    break;
                }
                for (PsiElement duplicatesBlock : varDuplicatesBlocks) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)duplicatesBlock, (boolean)false)) continue;
                    conflicting = true;
                    continue block1;
                }
            }
            success.set((Object)(!conflicting ? 1 : 0));
        }
        return Pair.create(varDuplicates, (Object)success.get());
    }

    static PsiElement getBlockScope(PsiElement element, PsiElement stopParent) {
        PsiElement current;
        for (current = element.getParent(); current != null && !ES6ConvertVarToLetConstInspection.isBlockLike(current) && current != stopParent; current = current.getParent()) {
        }
        return current;
    }

    static {
        Collections.addAll(ourBlockLikeTypes, JSBlockStatement.class, JSIfStatement.class, JSForInStatement.class, JSLoopStatement.class, JSSwitchStatement.class);
    }

    static class ScopeInfo {
        boolean isEmbedded;
        boolean topLevel = false;
        PsiElement blockParent = null;
        PsiElement wrappingBlockParent = null;
        JSNamedElement functionParent = null;

        ScopeInfo() {
        }
    }
}

