/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterAnnotationResult<T extends JSLinterState> {
    private final JSLinterInput<T> myInput;
    private final List<JSLinterError> myErrors;
    private final JSLinterErrorBase myFileWideErrorMessage;
    private final List<JSLinterFileLevelAnnotation> myFileLevelAnnotations;
    private List<JSLinterErrorBase> myWarnings;
    private final VirtualFile myConfigFile;

    public JSLinterAnnotationResult(@NotNull JSLinterInput<T> input, @NotNull List<JSLinterError> errors, @Nullable JSLinterErrorBase fileWideErrorMessage, @NotNull List<JSLinterFileLevelAnnotation> fileLevelAnnotations, @Nullable VirtualFile configFile) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "<init>"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "<init>"));
        }
        if (fileLevelAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLevelAnnotations", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "<init>"));
        }
        this.myInput = input;
        this.myErrors = errors;
        this.myFileWideErrorMessage = fileWideErrorMessage;
        this.myFileLevelAnnotations = fileLevelAnnotations;
        this.myConfigFile = configFile;
    }

    public void addWarning(@NotNull JSLinterErrorBase warning) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "addWarning"));
        }
        if (this.myWarnings == null) {
            this.myWarnings = new ArrayList<JSLinterErrorBase>();
        }
        this.myWarnings.add(warning);
    }

    @NotNull
    public JSLinterInput getInput() {
        JSLinterInput<T> jSLinterInput = this.myInput;
        if (jSLinterInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getInput"));
        }
        return jSLinterInput;
    }

    @NotNull
    public T getState() {
        T t = this.myInput.getState();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getState"));
        }
        return t;
    }

    @NotNull
    public List<JSLinterError> getErrors() {
        List<JSLinterError> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getErrors"));
        }
        return list;
    }

    @Nullable
    public JSLinterErrorBase getFileWideErrorMessage() {
        return this.myFileWideErrorMessage;
    }

    @NotNull
    public List<JSLinterFileLevelAnnotation> getFileLevelAnnotations() {
        List<JSLinterFileLevelAnnotation> list = this.myFileLevelAnnotations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "getFileLevelAnnotations"));
        }
        return list;
    }

    @Nullable
    public List<JSLinterErrorBase> getWarnings() {
        return this.myWarnings;
    }

    @Nullable
    public VirtualFile getConfigFile() {
        return this.myConfigFile;
    }

    public static <T extends JSLinterState> JSLinterAnnotationResult<T> createLinterResult(@NotNull JSLinterInput<T> input, @NotNull List<JSLinterError> errors, @Nullable VirtualFile configFile) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterResult"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterResult"));
        }
        return new JSLinterAnnotationResult<T>(input, errors, null, Collections.emptyList(), configFile);
    }

    public static <T extends JSLinterState> JSLinterAnnotationResult<T> createLinterFailResult(@NotNull JSLinterInput<T> input, @NotNull String fileWideErrorMessage) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterFailResult"));
        }
        if (fileWideErrorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWideErrorMessage", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterFailResult"));
        }
        return JSLinterAnnotationResult.createLinterFailResult(input, fileWideErrorMessage, null);
    }

    public static <T extends JSLinterState> JSLinterAnnotationResult<T> createLinterFailResult(@NotNull JSLinterInput<T> input, @NotNull String fileWideErrorMessage, @Nullable VirtualFile configFile) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterFailResult"));
        }
        if (fileWideErrorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWideErrorMessage", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterFailResult"));
        }
        return new JSLinterAnnotationResult<T>(input, Collections.emptyList(), new JSLinterErrorBase(fileWideErrorMessage), Collections.emptyList(), configFile);
    }

    public static <T extends JSLinterState> JSLinterAnnotationResult<T> createLinterFailResult(@NotNull JSLinterInput<T> input, @NotNull JSLinterErrorBase fileWideErrorMessage, @Nullable VirtualFile configFile) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterFailResult"));
        }
        if (fileWideErrorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWideErrorMessage", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "createLinterFailResult"));
        }
        return new JSLinterAnnotationResult<T>(input, Collections.emptyList(), fileWideErrorMessage, Collections.emptyList(), configFile);
    }

    @NotNull
    public static <T extends JSLinterState> JSLinterAnnotationResult<T> create(@NotNull JSLinterInput<T> input, @NotNull JSLinterFileLevelAnnotation fileLevelAnnotation) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "create"));
        }
        if (fileLevelAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLevelAnnotation", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "create"));
        }
        JSLinterAnnotationResult<T> jSLinterAnnotationResult = new JSLinterAnnotationResult<T>(input, Collections.emptyList(), null, Collections.singletonList(fileLevelAnnotation), null);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterAnnotationResult", "create"));
        }
        return jSLinterAnnotationResult;
    }
}

