/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterConfigFileUtil {
    @Nullable
    public static VirtualFile findFile(@NotNull Project project, @NotNull VirtualFile initialDir, @NotNull String basename) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "findFile"));
        }
        if (initialDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDir", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "findFile"));
        }
        if (basename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basename", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "findFile"));
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "lambda$findFile$0"));
            }
            if (initialDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDir", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "lambda$findFile$0"));
            }
            if (basename == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basename", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "lambda$findFile$0"));
            }
            if (project.isDisposed()) {
                return null;
            }
            for (VirtualFile dir = initialDir; dir != null; dir = dir.getParent()) {
                VirtualFile file = dir.findChild(basename);
                if (file == null || !file.isValid() || file.isDirectory() || ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file, false) == null) continue;
                return file;
            }
            return null;
        });
    }

    @Nullable
    public static VirtualFile findFileUpFileSystemRoot(@NotNull VirtualFile initialDir, @NotNull String basename) {
        if (initialDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDir", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "findFileUpFileSystemRoot"));
        }
        if (basename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basename", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "findFileUpFileSystemRoot"));
        }
        for (VirtualFile dir = initialDir; dir != null; dir = dir.getParent()) {
            VirtualFile file = dir.findChild(basename);
            if (file == null || !file.isValid() || file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static String loadActualText(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "loadActualText"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            String string = document.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "loadActualText"));
            }
            return string;
        }
        String string = VfsUtilCore.loadText((VirtualFile)file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "loadActualText"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "findLocalFileByPath"));
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    @Nullable
    public static JsonProperty getProperty(@NotNull PsiElement position) {
        JsonObject objectLiteralExpression;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "getProperty"));
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)position, JsonProperty.class, (boolean)false);
        if (property != null && (objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            return property;
        }
        return null;
    }

    @Nullable
    public static PsiElement getFirstChildAsStringLiteral(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "getFirstChildAsStringLiteral"));
        }
        PsiElement firstElement = property.getFirstChild();
        if (firstElement != null && JSLinterConfigFileUtil.isStringLiteral(firstElement)) {
            return firstElement;
        }
        return null;
    }

    public static boolean isStringLiteral(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "isStringLiteral"));
        }
        return element instanceof JsonStringLiteral;
    }

    public static boolean isArray(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil", "isArray"));
        }
        return element instanceof JsonArray;
    }

    public static void skipOtherCompletionContributors(CompletionParameters parameters, CompletionResultSet result) {
        result.runRemainingContributors(parameters, result1 -> {}, true);
    }
}

