/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByCommentFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintExternalAnnotator;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintInspection
extends JSLinterInspection<JSHintState> {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"settings.javascript.linters.jshint.configurable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintInspection", "getDisplayName"));
        }
        return string;
    }

    public static HighlightDisplayKey getHighlightDisplayKey() {
        return JSHintInspection.getHighlightDisplayKeyByClass(JSHintInspection.class);
    }

    @NotNull
    protected JSHintExternalAnnotator getExternalAnnotatorForBatchInspection() {
        JSHintExternalAnnotator jSHintExternalAnnotator = JSHintExternalAnnotator.getInstanceForBatchInspection();
        if (jSHintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintInspection", "getExternalAnnotatorForBatchInspection"));
        }
        return jSHintExternalAnnotator;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new JSHintSuppressByCommentFix(HighlightDisplayKey.find((String)this.getShortName()), JSInspectionSuppressor.getHolderClass(element))};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintInspection", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public static class JSHintSuppressByCommentFix
    extends SuppressByCommentFix {
        public JSHintSuppressByCommentFix(HighlightDisplayKey key, Class<? extends PsiElement> suppressionHolderClass) {
            super(key, suppressionHolderClass);
        }

        @NotNull
        public String getText() {
            if ("Suppress for line" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintInspection$JSHintSuppressByCommentFix", "getText"));
            }
            return "Suppress for line";
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintInspection$JSHintSuppressByCommentFix", "createSuppression"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/JSHintInspection$JSHintSuppressByCommentFix", "createSuppression"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/lang/javascript/linter/jshint/JSHintInspection$JSHintSuppressByCommentFix", "createSuppression"));
            }
            if (!element.isValid()) {
                return;
            }
            PsiFile psiFile = element.getContainingFile();
            if (psiFile != null) {
                psiFile = psiFile.getOriginalFile();
            }
            if (psiFile == null || !psiFile.isValid()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return;
            }
            int lineNo = document.getLineNumber(element.getTextOffset());
            int lineEndOffset = document.getLineEndOffset(lineNo);
            CommandProcessor.getInstance().executeCommand(project, () -> document.insertString(lineEndOffset, (CharSequence)" // jshint ignore:line"), null, null);
        }
    }
}

