/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleProgress {
    private static long DELAY_MILLIS = 100L;
    private final ConsoleViewImpl myConsoleView;
    private final AtomicReference<Alarm> myAlarmRef;
    private int myCounter;
    private int myPrevOffset;

    public ConsoleProgress(@NotNull ConsoleViewImpl consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/modules/ConsoleProgress", "<init>"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/modules/ConsoleProgress", "<init>"));
        }
        this.myAlarmRef = new AtomicReference();
        this.myCounter = 0;
        this.myPrevOffset = -1;
        this.myConsoleView = consoleView;
        if (!processHandler.isProcessTerminated()) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    ConsoleProgress.this.start();
                }

                public void processTerminated(ProcessEvent event) {
                    ConsoleProgress.this.stop();
                }
            });
        }
    }

    @Nullable
    public static ConsoleProgress install(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/modules/ConsoleProgress", "install"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/modules/ConsoleProgress", "install"));
        }
        if (consoleView instanceof ConsoleViewImpl) {
            ConsoleViewImpl view = (ConsoleViewImpl)consoleView;
            return new ConsoleProgress(view, processHandler);
        }
        return null;
    }

    private char nextChar() {
        ++this.myCounter;
        return this.getCurrentChar();
    }

    private char getCurrentChar() {
        return "-\\|/".charAt(this.myCounter % 4);
    }

    private void start() {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        if (!this.myAlarmRef.compareAndSet(null, alarm)) {
            Disposer.dispose((Disposable)alarm);
            return;
        }
        alarm.addRequest(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    Document document = ConsoleProgress.this.getDocument();
                    if (document != null) {
                        ConsoleProgress.this.undoPrevInsert(document);
                        int offset = document.getTextLength();
                        char ch = ConsoleProgress.this.nextChar();
                        document.insertString(offset, (CharSequence)Character.toString(ch));
                        ConsoleProgress.this.myPrevOffset = offset;
                    }
                });
                alarm.addRequest((Runnable)this, DELAY_MILLIS, ModalityState.any());
            }
        }, DELAY_MILLIS, ModalityState.any());
    }

    @Nullable
    private Document getDocument() {
        Editor editor = this.myConsoleView.getEditor();
        if (editor != null) {
            return editor.getDocument();
        }
        return null;
    }

    private void undoPrevInsert(@NotNull Document document) {
        char ch;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/modules/ConsoleProgress", "undoPrevInsert"));
        }
        CharSequence sequence = document.getCharsSequence();
        if (this.myPrevOffset >= 0 && this.myPrevOffset < sequence.length() && (ch = sequence.charAt(this.myPrevOffset)) == this.getCurrentChar()) {
            document.deleteString(this.myPrevOffset, this.myPrevOffset + 1);
        }
        this.myPrevOffset = -1;
    }

    private void stop() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Alarm alarm = this.myAlarmRef.get();
            if (alarm != null) {
                alarm.cancelAllRequests();
                Disposer.dispose((Disposable)alarm);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                Document document = this.getDocument();
                if (document != null) {
                    this.undoPrevInsert(document);
                }
            });
        }, ModalityState.any());
    }
}

