/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportES6ModuleFix;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ES6ModulesSuggester
implements JsModulesSuggester {
    @NotNull
    private final LocalInspectionToolSession mySession;
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final JSReferenceExpression myNode;
    @NotNull
    private final List<Pair<JSReferenceExpression, List<LocalQuickFix>>> myResult;

    public ES6ModulesSuggester(@NotNull LocalInspectionToolSession session, @NotNull ModuleReferenceInfo info, @NotNull JSReferenceExpression node) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "<init>"));
        }
        this.mySession = session;
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myResult = new ArrayList<Pair<JSReferenceExpression, List<LocalQuickFix>>>();
    }

    @Override
    public boolean isResolvedGlobally(@NotNull ResolveResult result, Set<VirtualFile> predefinedFiles) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "isResolvedGlobally"));
        }
        return NodeModuleUtil.isResolvedGloballyCommonJS(result, predefinedFiles, this.mySession);
    }

    @Override
    public void findFixes(ResolveResult[] resolveResults, @NotNull Set<VirtualFile> predefinedFiles) {
        if (predefinedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFiles", "com/intellij/lang/javascript/modules/ES6ModulesSuggester", "findFixes"));
        }
        NodeJSModulesSearcher searcher = new NodeJSModulesSearcher(this.mySession, this.myModuleReferenceInfo, this.myNode, resolveResults, predefinedFiles).ignoreNodeLibraryAssociation();
        List descriptors = searcher.find();
        if (descriptors.isEmpty()) {
            return;
        }
        boolean exactMath = false;
        for (ModuleFixCreator.FixDescriptor descriptor2 : descriptors) {
            if (exactMath |= descriptor2.isTwoWordsMath()) break;
        }
        boolean finalExactMath = exactMath;
        descriptors = ContainerUtil.filter(descriptors, descriptor -> {
            if (finalExactMath && !descriptor.isTwoWordsMath()) {
                return false;
            }
            String fromPath = descriptor.getFromPath();
            int idx = fromPath.indexOf("node_modules");
            return idx < 0 || fromPath.indexOf("test", idx) <= 0 && fromPath.indexOf("examples", idx) <= 0;
        });
        boolean singleQuotes = !JSCodeStyleSettings.getSettings((PsiElement)this.myNode).USE_DOUBLE_QUOTES;
        ArrayList<ImportES6ModuleFix> list = new ArrayList<ImportES6ModuleFix>();
        for (ModuleFixCreator.FixDescriptor descriptor3 : descriptors) {
            list.add(new ImportES6ModuleFix(this.myNode, descriptor3, singleQuotes));
        }
        this.myResult.add((Pair<JSReferenceExpression, List<LocalQuickFix>>)Pair.create((Object)this.myNode, list));
        if (this.myModuleReferenceInfo.haveTail()) {
            Project project = this.myNode.getProject();
            List<JSReferenceExpression> tailRef = this.myModuleReferenceInfo.getTailRef();
            JSReferenceExpression expression = tailRef.get(0);
            ArrayList<ImportES6ModuleFix> secondWordList = new ArrayList<ImportES6ModuleFix>(list);
            for (ModuleFixCreator.FixDescriptor descriptor4 : descriptors) {
                secondWordList.add(new ImportES6ModuleFix(expression, new ModuleFixCreator.FixDescriptor(descriptor4).withTail((SmartPsiElementPointer<JSReferenceExpression>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)expression), new String[]{expression.getReferenceName()}), singleQuotes));
            }
            this.myResult.add((Pair<JSReferenceExpression, List<LocalQuickFix>>)Pair.create((Object)expression, secondWordList));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.myResult.isEmpty();
    }

    @Override
    public List<Pair<JSReferenceExpression, List<LocalQuickFix>>> getFixes() {
        return this.myResult;
    }
}

