/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.TypeScriptInterfaceStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInterfaceImpl
extends TypeScriptClassBase<TypeScriptInterfaceStub>
implements TypeScriptInterface {
    private static final String CALL_SIGNATURE_NAME_HOLDER = "CALL^SIGNATURE";
    private volatile String myName;

    public TypeScriptInterfaceImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptInterfaceImpl(TypeScriptInterfaceStub stub) {
        super(stub, JSStubElementTypes.TYPESCRIPT_INTERFACE);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "setName"));
        }
        this.myName = null;
        return super.setName(newName);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptInterface((TypeScriptInterface)this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getName() {
        TypeScriptInterfaceStub stub = (TypeScriptInterfaceStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = this.myName;
        if (name != null) {
            return name;
        }
        this.myName = name = this.doGetName();
        return name;
    }

    @Nullable
    private String doGetName() {
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return ((JSReferenceExpression)node.getPsi()).getReferencedName();
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        ASTNode node = this.findNameIdentifier();
        return node == null ? super.getTextOffset() : node.getStartOffset();
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    public TypeScriptObjectType getBody() {
        return (TypeScriptObjectType)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.OBJECT_TYPE);
    }

    public boolean isInterface() {
        return true;
    }

    @Override
    @NotNull
    public JSClass[] getSupers() {
        JSClass[] jSClassArray = this.getSuperClasses();
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getSupers"));
        }
        return jSClassArray;
    }

    @Override
    @NotNull
    public JSFunction[] getFunctions() {
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            if (JSFunction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getFunctions"));
            }
            return JSFunction.EMPTY_ARRAY;
        }
        JSFunction[] jSFunctionArray = (JSFunction[])Arrays.stream(body.getTypeMembers()).filter(el -> el instanceof JSFunction).toArray(JSFunction[]::new);
        if (jSFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getFunctions"));
        }
        return jSFunctionArray;
    }

    @Override
    @NotNull
    public JSField[] getFields() {
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            if (JSField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getFields"));
            }
            return JSField.EMPTY_ARRAY;
        }
        JSField[] jSFieldArray = (JSField[])Arrays.stream(body.getTypeMembers()).filter(el -> el instanceof JSField).toArray(JSField[]::new);
        if (jSFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getFields"));
        }
        return jSFieldArray;
    }

    @Override
    @Nullable
    public JSFunction findFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            return null;
        }
        return super.findFunctionByNameAndKind(name, kind);
    }

    @Override
    @NotNull
    public TypeScriptFunction[] findFunctionsByNameAndKind(String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            if (TypeScriptFunction.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "findFunctionsByNameAndKind"));
            }
            return TypeScriptFunction.EMPTY;
        }
        TypeScriptFunction[] typeScriptFunctionArray = super.findFunctionsByNameAndKind(name, kind);
        if (typeScriptFunctionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "findFunctionsByNameAndKind"));
        }
        return typeScriptFunctionArray;
    }

    @Override
    @Nullable
    public JSFunction getConstructor() {
        return null;
    }

    @Override
    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    @Override
    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        TypeScriptObjectType body = this.getBody();
        List list = body != null ? ContainerUtil.list((Object[])body.getTypeMembers()) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getMembers"));
        }
        return list;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.INTERFACE;
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "isClassOrInterface"));
        }
        return classOrInterface;
    }

    @Override
    protected boolean hasCallSignature() {
        return this.findFunctionByName(CALL_SIGNATURE_NAME_HOLDER) != null;
    }

    @Override
    protected String getMethodName(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getMethodName"));
        }
        if (function instanceof TypeScriptCallSignature) {
            return CALL_SIGNATURE_NAME_HOLDER;
        }
        return super.getMethodName(function);
    }

    @Override
    protected void clearCachesSync() {
        super.clearCachesSync();
        this.myName = null;
    }
}

