/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ResultSink {
    @Nullable
    private DialectOptionHolder myHolder;
    @Nullable
    public final PsiElement place;
    protected List<PsiElement> myResults;

    public boolean isActionScript() {
        return this.myHolder != null && this.myHolder.isECMA4;
    }

    public boolean isTypeScript() {
        return this.myHolder != null && this.myHolder.isTypeScript;
    }

    public boolean isES6() {
        return this.myHolder != null && this.myHolder.isECMA6;
    }

    public ResultSink(@Nullable PsiElement _place) {
        this.place = _place;
        this.myHolder = _place != null ? DialectDetector.dialectOfElement(_place) : null;
    }

    public abstract String getName();

    @Nullable
    public PsiElement getResult() {
        return this.myResults != null ? this.myResults.get(this.myResults.size() - 1) : null;
    }

    @Nullable
    public List<PsiElement> getResults() {
        return this.myResults != null ? this.myResults : null;
    }

    public int getResultCount() {
        return this.myResults != null ? this.myResults.size() : 0;
    }

    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        if (this.myResults == null) {
            this.myResults = new SmartList();
        }
        this.myResults.add(element);
        return true;
    }

    public boolean accepts(PsiElement element) {
        return true;
    }

    public void startingParent(PsiElement parent, ResolveProcessor resolveProcessor) {
    }

    public void addPossibleCandidateResult(PsiElement element, @Nullable String problemKey) {
    }

    public boolean skipTopLevelItems() {
        return false;
    }

    public boolean needTopLevelClassName(String name) {
        return true;
    }

    public void setNestingLevel(int nestingLevel) {
    }

    public int getNestingLevel() {
        return 0;
    }

    public void startGlobalDeclarations() {
    }
}

