/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubIndexingUtils {
    public static void addImplicitNamespaces(@NotNull JSQualifiedName elementQualifiedName, @NotNull Collection<JSImplicitElement> outElements, @Nullable PsiElement element) {
        if (elementQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementQualifiedName", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "addImplicitNamespaces"));
        }
        if (outElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outElements", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "addImplicitNamespaces"));
        }
        for (JSQualifiedName parent = elementQualifiedName.getParent(); parent != null; parent = parent.getParent()) {
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(parent.getName(), element).setNamespace(parent.getParent()).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Namespace);
            outElements.add(new JSImplicitElementImpl(builder));
        }
    }

    public static void processExtendCall(@NotNull JSReferenceExpression typeExpression, @NotNull JSReferenceExpression baseTypeExpression, @NotNull JSContext extensionContext, @NotNull JSElementIndexingData outIndexingData) {
        if (typeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (baseTypeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseTypeExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (extensionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionContext", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (outIndexingData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        JSStubIndexingUtils.processExtendCall(JSStubIndexingUtils.getNamespaceFromReferenceExpression(typeExpression, extensionContext), JSStubIndexingUtils.getNamespaceFromReferenceExpression(baseTypeExpression, extensionContext), outIndexingData);
    }

    @NotNull
    public static JSNamespace getNamespaceFromReferenceExpression(@NotNull JSReferenceExpression referenceExpression, @NotNull JSContext jsContext) {
        JSQualifiedName qualifiedName;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "getNamespaceFromReferenceExpression"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "getNamespaceFromReferenceExpression"));
        }
        JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(referenceExpression);
        if (ns == null) {
            ns = JSSymbolUtil.createNamespaceFromReferenceExpression(referenceExpression, jsContext, true);
        }
        if (ns != null) {
            qualifiedName = ns.getQualifiedName();
            if (ns.getJSContext() != JSContext.UNKNOWN) {
                jsContext = JSTypeUtils.combineJSContexts(jsContext, ns.getJSContext());
            }
        } else {
            qualifiedName = null;
        }
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(qualifiedName, jsContext, false);
        if (jSNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "getNamespaceFromReferenceExpression"));
        }
        return jSNamespaceImpl;
    }

    public static void processExtendCall(@NotNull JSNamespace ns, @NotNull JSNamespace baseNs, @NotNull JSElementIndexingData outIndexingData) {
        String baseTypeString;
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (baseNs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNs", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        if (outIndexingData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "processExtendCall"));
        }
        JSQualifiedName qualifiedName = ns.getQualifiedName();
        String typeString = qualifiedName != null ? qualifiedName.getQualifiedName() : null;
        JSQualifiedName baseQualifiedName = baseNs.getQualifiedName();
        String string = baseTypeString = baseQualifiedName != null ? baseQualifiedName.getQualifiedName() : null;
        if (typeString == null || baseTypeString == null) {
            return;
        }
        if (ns.getJSContext() != JSContext.STATIC && baseNs.getJSContext() != JSContext.STATIC) {
            outIndexingData.addBaseType(typeString, baseTypeString);
        }
        if (ns.getJSContext() != JSContext.INSTANCE && baseNs.getJSContext() != JSContext.INSTANCE) {
            outIndexingData.addBaseType(JSNamedType.appendStaticSuffix(typeString), JSNamedType.appendStaticSuffix(baseTypeString));
        }
        if (ns.getJSContext() != JSContext.INSTANCE && baseNs.getJSContext() != JSContext.STATIC) {
            outIndexingData.addBaseType(JSNamedType.appendStaticSuffix(typeString), baseTypeString);
        }
        if (ns.getJSContext() != JSContext.STATIC && baseNs.getJSContext() != JSContext.INSTANCE) {
            outIndexingData.addBaseType(typeString, JSNamedType.appendStaticSuffix(baseTypeString));
        }
    }

    @Nullable
    public static String evaluateTypeString(@NotNull JSReferenceExpression typeExpression) {
        if (typeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeExpression", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "evaluateTypeString"));
        }
        JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(typeExpression);
        if (ns != null && ns.getQualifiedName() != null) {
            return ns.getQualifiedName().getQualifiedName();
        }
        JSQualifiedName qualifiedName = JSSymbolUtil.getReferencedNamespace((JSExpression)typeExpression);
        return qualifiedName != null ? qualifiedName.getQualifiedName() : null;
    }

    public static boolean keepsInitializerStub(@NotNull JSInitializerOwner initializerOwner) {
        if (initializerOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializerOwner", "com/intellij/lang/javascript/psi/stubs/impl/JSStubIndexingUtils", "keepsInitializerStub"));
        }
        return JSStubIndexingUtils.isInStubTree(initializerOwner.getInitializer());
    }

    public static boolean isInStubTree(@Nullable JSExpression element) {
        if ((element = JSUtils.unparenthesize(element)) == null) {
            return false;
        }
        ASTNode elementNode = element.getNode();
        IElementType initializerElementType = elementNode.getElementType();
        return initializerElementType instanceof IStubElementType && ((IStubElementType)initializerElementType).shouldCreateStub(elementNode);
    }
}

