/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.util.CheckingVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class SideEffectsVisitor
extends CheckingVisitor {
    public boolean check(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "check"));
        }
        expression.accept((PsiElementVisitor)this);
        return this.result;
    }

    public void visitJSElement(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "visitJSElement"));
        }
        if (!this.result) {
            super.visitJSElement(element);
        }
    }

    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "visitJSAssignmentExpression"));
        }
        this.setPositiveResult();
    }

    public void visitJSCallExpression(@NotNull JSCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "visitJSCallExpression"));
        }
        this.setPositiveResult();
    }

    public void visitJSNewExpression(@NotNull JSNewExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "visitJSNewExpression"));
        }
        this.setPositiveResult();
    }

    public void visitJSPostfixExpression(@NotNull JSPostfixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "visitJSPostfixExpression"));
        }
        if (this.result || this.checkPrefixOrPostSign(expression.getOperationSign())) {
            return;
        }
        super.visitJSPostfixExpression(expression);
    }

    public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/util/SideEffectsVisitor", "visitJSPrefixExpression"));
        }
        if (this.result || this.checkPrefixOrPostSign(expression.getOperationSign())) {
            return;
        }
        super.visitJSPrefixExpression(expression);
    }

    private boolean checkPrefixOrPostSign(IElementType sign) {
        if (JSTokenTypes.PLUSPLUS.equals(sign) || JSTokenTypes.MINUSMINUS.equals(sign)) {
            this.setPositiveResult();
            return true;
        }
        return false;
    }
}

