/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonNamesValidator;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyRenameInputValidator
implements RenameInputValidator {
    private JsonNamesValidator myJSONNamesValidator;

    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.psiElement(JSProperty.class).with((PatternCondition)new PatternCondition<JSProperty>("withStringLiteralChild"){

            public boolean accepts(@NotNull JSProperty property, ProcessingContext context) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/refactoring/JSPropertyRenameInputValidator$1", "accepts"));
                }
                LeafPsiElement nameSuggestionContext = JSPropertyRenameInputValidator.getNameSuggestionContext(property.getProject());
                if (nameSuggestionContext == null) {
                    return false;
                }
                return property.getFirstChild() == nameSuggestionContext;
            }
        });
    }

    public boolean isInputValid(String newName, PsiElement psiElement, ProcessingContext context) {
        JsonNamesValidator jsonNamesValidator = this.getJSONNamesValidator();
        Project project = psiElement.getProject();
        return jsonNamesValidator.isIdentifier(newName, project);
    }

    @Nullable
    private static LeafPsiElement getNameSuggestionContext(@NotNull Project project) {
        LeafPsiElement leaf;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/JSPropertyRenameInputValidator", "getNameSuggestionContext"));
        }
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset());
        if (nameSuggestionContext instanceof LeafPsiElement && (leaf = (LeafPsiElement)nameSuggestionContext).getElementType() == JSTokenTypes.STRING_LITERAL) {
            return leaf;
        }
        return null;
    }

    @NotNull
    private JsonNamesValidator getJSONNamesValidator() {
        JsonNamesValidator jsonNamesValidator = this.myJSONNamesValidator;
        if (jsonNamesValidator == null) {
            NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JsonLanguage.INSTANCE);
            jsonNamesValidator = namesValidator instanceof JsonNamesValidator ? (JsonNamesValidator)namesValidator : new JsonNamesValidator();
            this.myJSONNamesValidator = jsonNamesValidator;
        }
        JsonNamesValidator jsonNamesValidator2 = this.myJSONNamesValidator;
        if (jsonNamesValidator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/JSPropertyRenameInputValidator", "getJSONNamesValidator"));
        }
        return jsonNamesValidator2;
    }
}

